/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.auth;

import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RawPublicKeyIdentityTest {
    private static final String URI_PREFIX = "ni:///sha-256;";
    private static PublicKey publicKey;

    @BeforeClass
    public static void init() {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            KeyPair keyPair = generator.generateKeyPair();
            publicKey = keyPair.getPublic();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    @Test
    public void testGetNameReturnsNamedInterfaceUri() {
        RawPublicKeyIdentity id = new RawPublicKeyIdentity(publicKey);
        RawPublicKeyIdentityTest.assertThatNameIsValidNamedInterfaceUri(id.getName());
    }

    @Test
    public void testGetSubjectInfoReturnsEncodedKey() {
        RawPublicKeyIdentity id = new RawPublicKeyIdentity(publicKey);
        Assert.assertArrayEquals((byte[])id.getKey().getEncoded(), (byte[])id.getSubjectInfo());
    }

    @Test
    public void testConstructorCreatesPublicKeyFromSubjectInfo() throws GeneralSecurityException {
        byte[] subjectInfo = publicKey.getEncoded();
        RawPublicKeyIdentity principal = new RawPublicKeyIdentity(subjectInfo, publicKey.getAlgorithm());
        Assert.assertThat((Object)principal.getKey(), (Matcher)CoreMatchers.is((Object)publicKey));
    }

    private static void assertThatNameIsValidNamedInterfaceUri(String name) {
        Assert.assertTrue((boolean)name.startsWith(URI_PREFIX));
        String hash = name.substring(URI_PREFIX.length());
        Assert.assertFalse((boolean)hash.endsWith("="));
        Assert.assertFalse((boolean)hash.contains("+"));
        Assert.assertFalse((boolean)hash.contains("/"));
        Assert.assertFalse((boolean)hash.endsWith("\n"));
        Assert.assertFalse((boolean)hash.endsWith("\r"));
    }
}

