/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.MessageCallback;

public class SimpleMessageCallback
implements MessageCallback {
    private final CountDownLatch latchCalls;
    private final boolean countContextEstablished;
    private final MessageCallback chained;
    private EndpointContext context;
    private Throwable sendError;
    private boolean sent;
    private boolean connecting;
    private int retransmittedDtlsFlight;
    private Check endpointContextCheck = new Check(){

        @Override
        public boolean check() {
            return null != SimpleMessageCallback.this.context || null != SimpleMessageCallback.this.sendError;
        }
    };
    private Check sentCheck = new Check(){

        @Override
        public boolean check() {
            return SimpleMessageCallback.this.sent || null != SimpleMessageCallback.this.sendError;
        }
    };

    public SimpleMessageCallback() {
        this(0, false, null);
    }

    public SimpleMessageCallback(int calls, boolean countContextEstablished) {
        this(calls, countContextEstablished, null);
    }

    public SimpleMessageCallback(int calls, boolean countContextEstablished, MessageCallback chained) {
        this.latchCalls = new CountDownLatch(calls);
        this.countContextEstablished = countContextEstablished;
        this.chained = chained;
    }

    @Override
    public synchronized void onConnecting() {
        this.connecting = true;
    }

    @Override
    public synchronized void onDtlsRetransmission(int flight) {
        this.retransmittedDtlsFlight = flight;
    }

    @Override
    public synchronized void onContextEstablished(EndpointContext context) {
        this.context = context;
        this.notify();
        if (this.countContextEstablished) {
            this.latchCalls.countDown();
        }
        if (this.chained != null) {
            this.chained.onContextEstablished(context);
        }
    }

    @Override
    public synchronized void onSent() {
        this.sent = true;
        this.notify();
        this.latchCalls.countDown();
        if (this.chained != null) {
            this.chained.onSent();
        }
    }

    @Override
    public synchronized void onError(Throwable sendError) {
        this.sendError = sendError;
        this.notify();
        this.latchCalls.countDown();
        if (this.chained != null) {
            this.chained.onError(sendError);
        }
    }

    public synchronized String toString() {
        long count = this.latchCalls.getCount();
        if (count > 0L) {
            return count + " pending calls ...";
        }
        if (this.sent) {
            return String.format("sent %s", this.context);
        }
        if (this.sendError != null) {
            return String.format("error %s, %s", this.sendError, this.context);
        }
        if (this.context != null) {
            return String.format("context %s", this.context);
        }
        return "waiting ...";
    }

    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.latchCalls.await(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public long getPendingCalls() {
        return this.latchCalls.getCount();
    }

    public synchronized EndpointContext getEndpointContext() {
        return this.context;
    }

    public synchronized boolean isSent() {
        return this.sent;
    }

    public synchronized boolean isConnecting() {
        return this.connecting;
    }

    public synchronized int getRetransmittedDtlsFlight() {
        return this.retransmittedDtlsFlight;
    }

    public synchronized Throwable getError() {
        return this.sendError;
    }

    public synchronized EndpointContext getEndpointContext(long timeout) throws InterruptedException {
        this.wait(this.endpointContextCheck, timeout);
        return this.context;
    }

    public synchronized boolean isSent(long timeout) throws InterruptedException {
        this.wait(this.sentCheck, timeout);
        return this.sent;
    }

    public synchronized Throwable getError(long timeout) throws InterruptedException {
        this.wait(this.sentCheck, timeout);
        return this.sendError;
    }

    private void wait(Check check, long timeout) throws InterruptedException {
        long left;
        long end = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeout);
        while (!check.check() && (left = TimeUnit.NANOSECONDS.toMillis(end - System.nanoTime())) > 0L) {
            this.wait(left);
        }
    }

    private static interface Check {
        public boolean check();
    }
}

