/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadsRule
implements TestRule {
    public static final Logger LOGGER = LoggerFactory.getLogger(ThreadsRule.class.getName());
    private volatile Description description;
    private List<Thread> activeThreads;
    private final String[] excludes;

    public ThreadsRule(String ... excludes) {
        this.excludes = excludes;
    }

    public String toString() {
        Description description = this.description;
        if (null == description) {
            return super.toString();
        }
        if (description.isTest()) {
            return description.getDisplayName() + " (@Rule)";
        }
        return description.getDisplayName() + " (@ClassRule)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startRule(Description description) {
        this.activeThreads = this.getActiveThreads();
        ThreadsRule threadsRule = this;
        synchronized (threadsRule) {
            this.description = description;
        }
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeRule(boolean reportLeakAsException) {
        this.shutdown();
        this.checkThreadLeak(this.activeThreads, reportLeakAsException);
        ThreadsRule threadsRule = this;
        synchronized (threadsRule) {
            this.description = null;
        }
    }

    public List<Thread> getActiveThreads() {
        for (int i = 0; i < 5; ++i) {
            int count = Thread.activeCount();
            Thread[] active = new Thread[count];
            if (Thread.enumerate(active) != count) continue;
            if (this.excludes == null || this.excludes.length == 0) {
                return Arrays.asList(active);
            }
            ArrayList<Thread> threads = new ArrayList<Thread>();
            for (Thread thread : active) {
                boolean skip = false;
                for (String pattern : this.excludes) {
                    if (!thread.getName().matches(pattern)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                threads.add(thread);
            }
            return threads;
        }
        throw new IllegalStateException("Active threads unstable! " + Thread.activeCount());
    }

    public void checkThreadLeak(List<Thread> activeThreads, boolean reportLeakAsException) {
        ArrayList<Thread> listAfter = new ArrayList<Thread>(this.getActiveThreads());
        listAfter.removeAll(activeThreads);
        if (!listAfter.isEmpty()) {
            for (Thread thread : listAfter) {
                try {
                    thread.join(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            listAfter = new ArrayList<Thread>(this.getActiveThreads());
            listAfter.removeAll(activeThreads);
            if (!listAfter.isEmpty()) {
                this.dump("leaking " + this.description, listAfter);
                if (reportLeakAsException) {
                    throw new IllegalStateException("Active threads differs by " + listAfter.size() + "! (" + this.description + ")");
                }
            }
        }
    }

    public void dump(String message, List<Thread> list) {
        LOGGER.info("Threads {}: {} threads", (Object)message, (Object)list.size());
        for (Thread thread : list) {
            StackTraceElement[] stackTrace;
            ThreadGroup threadGroup = thread.getThreadGroup();
            if (threadGroup != null) {
                LOGGER.info("Threads {} : {}-{}", this.description, thread.getName(), threadGroup.getName());
            } else {
                LOGGER.info("Threads {} : {}", (Object)this.description, (Object)thread.getName());
            }
            if (!LOGGER.isTraceEnabled()) continue;
            for (StackTraceElement trace : stackTrace = thread.getStackTrace()) {
                LOGGER.trace("   {}", (Object)trace);
            }
        }
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ThreadsRule.this.startRule(description);
                try {
                    base.evaluate();
                }
                catch (Throwable t) {
                    ThreadsRule.this.closeRule(false);
                    throw t;
                }
                ThreadsRule.this.closeRule(true);
            }
        };
    }

    protected void initialize() {
    }

    protected void shutdown() {
    }
}

