/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import org.eclipse.californium.scandium.dtls.cipher.InvalidMacException;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCipher;

public class CCMBlockCipher {
    public static final String CIPHER_NAME = "AES/ECB/NoPadding";
    public static final ThreadLocalCipher CIPHER = new ThreadLocalCipher("AES/ECB/NoPadding");

    public static final byte[] decrypt(SecretKey key, byte[] nonce, byte[] a, byte[] c, int numAuthenticationBytes) throws GeneralSecurityException {
        int i;
        Cipher cipher = (Cipher)CIPHER.current();
        cipher.init(1, key);
        int lengthM = c.length - numAuthenticationBytes;
        int blockSize = cipher.getBlockSize();
        byte[] decrypted = new byte[lengthM];
        byte[] T = new byte[numAuthenticationBytes];
        BlockCipher blockCiper = new BlockCipher(cipher, nonce);
        int blockNo = 0;
        byte[] block = blockCiper.updateBlock(blockNo++);
        for (i = 0; i < numAuthenticationBytes; ++i) {
            T[i] = (byte)(c[lengthM + i] ^ block[i]);
        }
        i = 0;
        while (i < lengthM) {
            block = blockCiper.updateBlock(blockNo++);
            int blockEnd = i + blockSize;
            if (blockEnd > lengthM) {
                blockEnd = lengthM;
            }
            int j = 0;
            while (i < blockEnd) {
                decrypted[i] = (byte)(c[i] ^ block[j]);
                ++i;
                ++j;
            }
        }
        MacCipher macCipher = new MacCipher(cipher, nonce, a, decrypted, numAuthenticationBytes);
        byte[] mac = macCipher.getMac();
        if (MessageDigest.isEqual(T, mac)) {
            return decrypted;
        }
        throw new InvalidMacException(mac, T);
    }

    public static final byte[] encrypt(SecretKey key, byte[] nonce, byte[] a, byte[] m, int numAuthenticationBytes) throws GeneralSecurityException {
        int i;
        Cipher cipher = (Cipher)CIPHER.current();
        cipher.init(1, key);
        int blockSize = cipher.getBlockSize();
        int lengthM = m.length;
        MacCipher macCipher = new MacCipher(cipher, nonce, a, m, numAuthenticationBytes);
        byte[] mac = macCipher.getMac();
        byte[] encrypted = new byte[lengthM + numAuthenticationBytes];
        BlockCipher blockCiper = new BlockCipher(cipher, nonce);
        int blockNo = 0;
        byte[] block = blockCiper.updateBlock(blockNo++);
        for (i = 0; i < numAuthenticationBytes; ++i) {
            encrypted[i + lengthM] = (byte)(mac[i] ^ block[i]);
        }
        i = 0;
        while (i < lengthM) {
            block = blockCiper.updateBlock(blockNo++);
            int blockEnd = i + blockSize;
            if (blockEnd > lengthM) {
                blockEnd = lengthM;
            }
            int j = 0;
            while (i < blockEnd) {
                encrypted[i] = (byte)(m[i] ^ block[j]);
                ++i;
                ++j;
            }
        }
        return encrypted;
    }

    private static class MacCipher
    extends Block {
        private final Cipher cipher;
        private final byte[] mac;

        private MacCipher(Cipher cipher, byte[] nonce, byte[] a, byte[] m, int numAuthenticationBytes) throws ShortBufferException {
            super(cipher == null ? 0 : cipher.getBlockSize());
            this.cipher = cipher;
            int lengthM = m.length;
            int lengthA = a.length;
            int nonceL = nonce.length;
            int L = this.blockSize - 1 - nonceL;
            if (L < 2 || L > 8) {
                throw new IllegalArgumentException("Nonce length " + nonceL + " invalid for blocksize " + this.blockSize + " (valid length [" + (this.blockSize - 9) + "-" + (this.blockSize - 3) + "])");
            }
            int adata = 0;
            if (lengthA > 0) {
                adata = 1;
            }
            int mPrime = (numAuthenticationBytes - 2) / 2;
            int lPrime = L - 1;
            this.block[0] = (byte)(64 * adata + 8 * mPrime + lPrime);
            System.arraycopy(nonce, 0, this.block, 1, nonceL);
            if (this.setIntAtEnd(nonceL + 1, lengthM) != 0) {
                throw new IllegalArgumentException("Length " + lengthM + " too large for nonce " + nonceL + " and blocksize " + this.blockSize + " bytes.");
            }
            cipher.update(this.block, 0, this.blockSize, this.block);
            if (lengthA > 0) {
                int offset;
                int first = 65280;
                if (lengthA > 0 && lengthA < 65280) {
                    this.xorInt(0, 2, lengthA);
                    offset = 2;
                } else {
                    this.xorInt(0, 2, 65534);
                    this.xorInt(2, 6, lengthA);
                    offset = 6;
                }
                this.update(a, offset);
            }
            this.update(m, 0);
            this.mac = Arrays.copyOf(this.block, numAuthenticationBytes);
        }

        private void update(byte[] data, int initialBlockOffset) throws ShortBufferException {
            int length = data.length;
            int i = 0;
            while (i < length) {
                int blockEnd = i + this.blockSize - initialBlockOffset;
                if (blockEnd > length) {
                    blockEnd = length;
                }
                int j = initialBlockOffset;
                while (i < blockEnd) {
                    int n = j++;
                    this.block[n] = (byte)(this.block[n] ^ data[i]);
                    ++i;
                }
                initialBlockOffset = 0;
                this.cipher.update(this.block, 0, this.blockSize, this.block);
            }
        }

        private byte[] getMac() {
            return this.mac;
        }

        protected int xorInt(int offset, int end, int number) {
            while (end > offset) {
                int n = --end;
                this.block[n] = (byte)(this.block[n] ^ (byte)number);
                number >>>= 8;
            }
            return number;
        }
    }

    private static class BlockCipher
    extends Block {
        private final Cipher cipher;
        private final byte[] xblock;
        private final int nonceL;

        private BlockCipher(Cipher cipher, byte[] nonce) {
            super(cipher == null ? 0 : cipher.getBlockSize());
            this.cipher = cipher;
            this.nonceL = nonce.length;
            int L = this.blockSize - 1 - this.nonceL;
            if (L < 2 || L > 8) {
                throw new IllegalArgumentException("Nonce length " + this.nonceL + " invalid for blocksize " + this.blockSize + " (valid length [" + (this.blockSize - 9) + "-" + (this.blockSize - 3) + "])");
            }
            this.xblock = new byte[this.blockSize];
            this.block[0] = (byte)(L - 1);
            System.arraycopy(nonce, 0, this.block, 1, this.nonceL);
        }

        private byte[] updateBlock(int index) throws ShortBufferException {
            if (this.setIntAtEnd(this.nonceL + 1, index) != 0) {
                throw new IllegalArgumentException("Index " + index + " too large for nonce " + this.nonceL + " and blocksize " + this.blockSize + " bytes.");
            }
            this.cipher.update(this.block, 0, this.blockSize, this.xblock);
            return this.xblock;
        }
    }

    private static abstract class Block {
        protected final int blockSize;
        protected final byte[] block;

        protected Block(int blockSize) {
            this.blockSize = blockSize;
            this.block = new byte[blockSize];
        }

        protected int setIntAtEnd(int offset, int number) {
            int backOffset = this.blockSize;
            while (backOffset > offset) {
                this.block[--backOffset] = (byte)number;
                number >>>= 8;
            }
            return number;
        }
    }
}

