/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.interceptors;

import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.interceptors.MessageInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTracer
implements MessageInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageTracer.class.getCanonicalName());

    @Override
    public void sendRequest(Request request) {
        LOGGER.info("{} <== req {}", new Object[]{request.getDestinationContext(), request});
    }

    @Override
    public void sendResponse(Response response) {
        LOGGER.info("{} <== res {}", new Object[]{response.getDestinationContext(), response});
    }

    @Override
    public void sendEmptyMessage(EmptyMessage message) {
        LOGGER.info("{} <== emp {}", new Object[]{message.getDestinationContext(), message});
    }

    @Override
    public void receiveRequest(Request request) {
        LOGGER.info("{} ==> req {}", new Object[]{request.getSourceContext(), request});
    }

    @Override
    public void receiveResponse(Response response) {
        LOGGER.info("{} ==> res {}", new Object[]{response.getSourceContext(), response});
    }

    @Override
    public void receiveEmptyMessage(EmptyMessage message) {
        LOGGER.info("{} ==> emp {}", new Object[]{message.getSourceContext(), message});
    }
}

