/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.pskstore;

import java.net.InetSocketAddress;
import java.util.Arrays;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.ServerNames;

public class StaticPskStore
implements PskStore {
    private final byte[] key;
    private final PskPublicInformation fixedIdentity;

    public StaticPskStore(String identity, byte[] key) {
        this(new PskPublicInformation(identity), key);
    }

    public StaticPskStore(PskPublicInformation identity, byte[] key) {
        this.fixedIdentity = identity;
        this.key = Arrays.copyOf(key, key.length);
    }

    @Override
    public PskPublicInformation getIdentity(InetSocketAddress inetAddress) {
        return this.fixedIdentity;
    }

    @Override
    public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
        return this.getIdentity(peerAddress);
    }

    @Override
    public byte[] getKey(PskPublicInformation identity) {
        if (!this.fixedIdentity.equals(identity)) {
            return null;
        }
        if (!this.fixedIdentity.isCompliantEncoding()) {
            identity.normalize(this.fixedIdentity.getPublicInfoAsString());
        }
        return this.key;
    }

    @Override
    public byte[] getKey(ServerNames serverNames, PskPublicInformation identity) {
        return this.getKey(identity);
    }
}

