/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.security.SecureRandom;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.network.TokenGenerator;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomTokenGenerator
implements TokenGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomTokenGenerator.class.getName());
    private static final int DEFAULT_TOKEN_LENGTH = 8;
    private final int tokenSize;
    private final SecureRandom rng;

    public RandomTokenGenerator(NetworkConfig networkConfig) {
        if (networkConfig == null) {
            throw new NullPointerException("NetworkConfig must not be null");
        }
        this.rng = new SecureRandom();
        this.rng.nextInt(10);
        this.tokenSize = networkConfig.getInt("TOKEN_SIZE_LIMIT", 8);
        LOGGER.info("using tokens of {} bytes in length", (Object)this.tokenSize);
    }

    @Override
    public Token createToken(boolean longTermScope) {
        byte[] token = new byte[this.tokenSize];
        this.rng.nextBytes(token);
        token[0] = longTermScope ? (byte)(token[0] | 1) : (byte)(token[0] & 0xFE);
        return Token.fromProvider(token);
    }
}

