/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.FastInteger;

final class NumberUtility {
    private static final EInteger[] ValueBigIntPowersOfTen = new EInteger[]{EInteger.FromInt32(1), EInteger.FromInt32(10), EInteger.FromInt64(100L), EInteger.FromInt64(1000L), EInteger.FromInt64(10000L), EInteger.FromInt64(100000L), EInteger.FromInt64(1000000L), EInteger.FromInt64(10000000L), EInteger.FromInt64(100000000L), EInteger.FromInt64(1000000000L), EInteger.FromInt64(10000000000L), EInteger.FromInt64(100000000000L), EInteger.FromInt64(1000000000000L), EInteger.FromInt64(10000000000000L), EInteger.FromInt64(100000000000000L), EInteger.FromInt64(1000000000000000L), EInteger.FromInt64(10000000000000000L), EInteger.FromInt64(100000000000000000L), EInteger.FromInt64(1000000000000000000L)};
    private static final EInteger[] ValueBigIntPowersOfFive = new EInteger[]{EInteger.FromInt32(1), EInteger.FromInt64(5L), EInteger.FromInt64(25L), EInteger.FromInt64(125L), EInteger.FromInt64(625L), EInteger.FromInt64(3125L), EInteger.FromInt64(15625L), EInteger.FromInt64(78125L), EInteger.FromInt64(390625L), EInteger.FromInt64(1953125L), EInteger.FromInt64(9765625L), EInteger.FromInt64(48828125L), EInteger.FromInt64(244140625L), EInteger.FromInt64(1220703125L), EInteger.FromInt64(6103515625L), EInteger.FromInt64(30517578125L), EInteger.FromInt64(152587890625L), EInteger.FromInt64(762939453125L), EInteger.FromInt64(3814697265625L), EInteger.FromInt64(19073486328125L), EInteger.FromInt64(95367431640625L), EInteger.FromInt64(476837158203125L), EInteger.FromInt64(2384185791015625L), EInteger.FromInt64(11920928955078125L), EInteger.FromInt64(59604644775390625L), EInteger.FromInt64(298023223876953125L), EInteger.FromInt64(1490116119384765625L), EInteger.FromInt64(7450580596923828125L)};
    private static final EInteger ValueBigShiftIteration = EInteger.FromInt64(1000000L);
    private static final PowerCache ValuePowerOfFiveCache = new PowerCache();
    private static final PowerCache ValuePowerOfTenCache = new PowerCache();
    private static final EInteger ValueBigInt36 = EInteger.FromInt64(36L);
    private static final EInteger ValueFivePower40 = EInteger.FromInt64(95367431640625L).Multiply(EInteger.FromInt64(95367431640625L));

    private NumberUtility() {
    }

    static int ShiftLeftOne(int[] arr) {
        int carry = 0;
        for (int i = 0; i < arr.length; ++i) {
            int item = arr[i];
            arr[i] = arr[i] << 1 | carry;
            carry = item >> 31 != 0 ? 1 : 0;
        }
        return carry;
    }

    private static int CountTrailingZeros(int numberValue) {
        if (numberValue == 0) {
            return 32;
        }
        int i = 0;
        if (numberValue << 16 == 0) {
            numberValue >>= 16;
            i += 16;
        }
        if (numberValue << 24 == 0) {
            numberValue >>= 8;
            i += 8;
        }
        if (numberValue << 28 == 0) {
            numberValue >>= 4;
            i += 4;
        }
        if (numberValue << 30 == 0) {
            numberValue >>= 2;
            i += 2;
        }
        if (numberValue << 31 == 0) {
            ++i;
        }
        return i;
    }

    static int BitPrecisionInt(int numberValue) {
        if (numberValue == 0) {
            return 0;
        }
        int i = 32;
        if (numberValue >> 16 == 0) {
            numberValue <<= 16;
            i -= 8;
        }
        if (numberValue >> 24 == 0) {
            numberValue <<= 8;
            i -= 8;
        }
        if (numberValue >> 28 == 0) {
            numberValue <<= 4;
            i -= 4;
        }
        if (numberValue >> 30 == 0) {
            numberValue <<= 2;
            i -= 2;
        }
        if (numberValue >> 31 == 0) {
            --i;
        }
        return i;
    }

    static int ShiftAwayTrailingZerosTwoElements(int[] arr) {
        int a0 = arr[0];
        int a1 = arr[1];
        int tz = NumberUtility.CountTrailingZeros(a0);
        if (tz == 0) {
            return 0;
        }
        if (tz < 32) {
            int carry = a1 << 32 - tz;
            arr[0] = a0 >> tz & Integer.MAX_VALUE >> tz - 1 | carry;
            arr[1] = a1 >> tz & Integer.MAX_VALUE >> tz - 1;
            return tz;
        }
        tz = NumberUtility.CountTrailingZeros(a1);
        arr[0] = tz == 32 ? 0 : (tz > 0 ? a1 >> tz & Integer.MAX_VALUE >> tz - 1 : a1);
        arr[1] = 0;
        return 32 + tz;
    }

    static EInteger ShiftLeft(EInteger val, EInteger bigShift) {
        if (val.isZero()) {
            return val;
        }
        while (bigShift.compareTo(ValueBigShiftIteration) > 0) {
            val = val.ShiftLeft(1000000);
            bigShift = bigShift.Subtract(ValueBigShiftIteration);
        }
        int lastshift = bigShift.ToInt32Checked();
        val = val.ShiftLeft(lastshift);
        return val;
    }

    static EInteger ShiftLeftInt(EInteger val, int shift) {
        if (val.isZero()) {
            return val;
        }
        while (shift > 1000000) {
            val = val.ShiftLeft(1000000);
            shift -= 1000000;
        }
        int lastshift = shift;
        val = val.ShiftLeft(lastshift);
        return val;
    }

    static boolean HasBitSet(int[] arr, int bit) {
        return bit >> 5 < arr.length && (arr[bit >> 5] & 1 << (bit & 0x1F)) != 0;
    }

    static EInteger FindPowerOfFiveFromBig(EInteger diff) {
        int sign = diff.signum();
        if (sign < 0) {
            return EInteger.FromInt32(0);
        }
        if (sign == 0) {
            return EInteger.FromInt32(1);
        }
        FastInteger intcurexp = FastInteger.FromBig(diff);
        if (intcurexp.CompareToInt(54) <= 0) {
            return NumberUtility.FindPowerOfFive(intcurexp.AsInt32());
        }
        EInteger mantissa = EInteger.FromInt32(1);
        EInteger origdiff = diff;
        EInteger bigpow = ValuePowerOfFiveCache.GetCachedPower(origdiff);
        if (bigpow != null) {
            return bigpow;
        }
        EInteger[] otherPower = ValuePowerOfFiveCache.FindCachedPowerOrSmaller(origdiff);
        if (otherPower != null) {
            intcurexp.SubtractBig(otherPower[0]);
            mantissa = bigpow = otherPower[1];
        } else {
            bigpow = EInteger.FromInt32(0);
        }
        while (intcurexp.signum() > 0) {
            if (intcurexp.CompareToInt(27) <= 0) {
                bigpow = NumberUtility.FindPowerOfFive(intcurexp.AsInt32());
                mantissa = mantissa.Multiply(bigpow);
                break;
            }
            if (intcurexp.CompareToInt(9999999) <= 0) {
                bigpow = NumberUtility.FindPowerOfFive(1).Pow(intcurexp.AsInt32());
                mantissa = mantissa.Multiply(bigpow);
                break;
            }
            if (bigpow.isZero()) {
                bigpow = NumberUtility.FindPowerOfFive(1).Pow(9999999);
            }
            mantissa = mantissa.Multiply(bigpow);
            intcurexp.AddInt(-9999999);
        }
        ValuePowerOfFiveCache.AddPower(origdiff, mantissa);
        return mantissa;
    }

    static EInteger FindPowerOfTenFromBig(EInteger bigintExponent) {
        int sign = bigintExponent.signum();
        if (sign < 0) {
            return EInteger.FromInt32(0);
        }
        if (sign == 0) {
            return EInteger.FromInt32(1);
        }
        if (bigintExponent.compareTo(ValueBigInt36) <= 0) {
            return NumberUtility.FindPowerOfTen(bigintExponent.ToInt32Checked());
        }
        FastInteger intcurexp = FastInteger.FromBig(bigintExponent);
        EInteger mantissa = EInteger.FromInt32(1);
        EInteger bigpow = EInteger.FromInt32(0);
        while (intcurexp.signum() > 0) {
            if (intcurexp.CompareToInt(18) <= 0) {
                bigpow = NumberUtility.FindPowerOfTen(intcurexp.AsInt32());
                mantissa = mantissa.Multiply(bigpow);
                break;
            }
            if (intcurexp.CompareToInt(9999999) <= 0) {
                int val = intcurexp.AsInt32();
                bigpow = NumberUtility.FindPowerOfFive(val);
                bigpow = bigpow.ShiftLeft(val);
                mantissa = mantissa.Multiply(bigpow);
                break;
            }
            if (bigpow.isZero()) {
                bigpow = NumberUtility.FindPowerOfFive(9999999);
                bigpow = bigpow.ShiftLeft(9999999);
            }
            mantissa = mantissa.Multiply(bigpow);
            intcurexp.AddInt(-9999999);
        }
        return mantissa;
    }

    static EInteger FindPowerOfFive(int precision) {
        EInteger ret;
        EInteger[] otherPower;
        if (precision < 0) {
            return EInteger.FromInt32(0);
        }
        if (precision <= 27) {
            return ValueBigIntPowersOfFive[precision];
        }
        if (precision == 40) {
            return ValueFivePower40;
        }
        int startPrecision = precision;
        EInteger bigpow = ValuePowerOfFiveCache.GetCachedPowerInt(precision);
        if (bigpow != null) {
            return bigpow;
        }
        EInteger origPrecision = EInteger.FromInt32(precision);
        if (precision <= 54) {
            if ((precision & 1) == 0) {
                EInteger ret2 = ValueBigIntPowersOfFive[precision >> 1];
                ret2 = ret2.Multiply(ret2);
                ValuePowerOfFiveCache.AddPower(origPrecision, ret2);
                return ret2;
            }
            EInteger ret3 = ValueBigIntPowersOfFive[27];
            bigpow = ValueBigIntPowersOfFive[precision - 27];
            ret3 = ret3.Multiply(bigpow);
            ValuePowerOfFiveCache.AddPower(origPrecision, ret3);
            return ret3;
        }
        if (precision > 40 && precision <= 94) {
            EInteger ret4 = ValueFivePower40;
            bigpow = NumberUtility.FindPowerOfFive(precision - 40);
            ret4 = ret4.Multiply(bigpow);
            ValuePowerOfFiveCache.AddPower(origPrecision, ret4);
            return ret4;
        }
        boolean first = true;
        bigpow = EInteger.FromInt32(0);
        while ((otherPower = ValuePowerOfFiveCache.FindCachedPowerIntOrSmaller(precision)) != null) {
            EInteger otherPower0 = otherPower[0];
            EInteger otherPower1 = otherPower[1];
            precision -= otherPower0.ToInt32Checked();
            bigpow = first ? otherPower[1] : bigpow.Multiply(otherPower1);
            first = false;
        }
        EInteger eInteger = ret = !first ? bigpow : EInteger.FromInt32(1);
        while (precision > 0) {
            if (precision <= 27) {
                bigpow = ValueBigIntPowersOfFive[precision];
                ret = first ? bigpow : ret.Multiply(bigpow);
                first = false;
                break;
            }
            if (precision <= 9999999) {
                bigpow = ValueBigIntPowersOfFive[1].Pow(precision);
                if (precision != startPrecision) {
                    EInteger bigprec = EInteger.FromInt32(precision);
                    ValuePowerOfFiveCache.AddPower(bigprec, bigpow);
                }
                ret = first ? bigpow : ret.Multiply(bigpow);
                first = false;
                break;
            }
            if (bigpow.isZero()) {
                bigpow = NumberUtility.FindPowerOfFive(9999999);
            }
            ret = first ? bigpow : ret.Multiply(bigpow);
            first = false;
            precision -= 9999999;
        }
        ValuePowerOfFiveCache.AddPower(origPrecision, ret);
        return ret;
    }

    static EInteger FindPowerOfTen(int precision) {
        EInteger ret;
        EInteger[] otherPower;
        if (precision < 0) {
            return EInteger.FromInt32(0);
        }
        if (precision <= 18) {
            return ValueBigIntPowersOfTen[precision];
        }
        int startPrecision = precision;
        EInteger bigpow = ValuePowerOfTenCache.GetCachedPowerInt(precision);
        if (bigpow != null) {
            return bigpow;
        }
        EInteger origPrecision = EInteger.FromInt32(precision);
        if (precision <= 27) {
            int prec = precision;
            EInteger ret2 = ValueBigIntPowersOfFive[prec];
            ret2 = ret2.ShiftLeft(prec);
            ValuePowerOfTenCache.AddPower(origPrecision, ret2);
            return ret2;
        }
        if (precision <= 36) {
            if ((precision & 1) == 0) {
                EInteger ret3 = ValueBigIntPowersOfTen[precision >> 1];
                ret3 = ret3.Multiply(ret3);
                ValuePowerOfTenCache.AddPower(origPrecision, ret3);
                return ret3;
            }
            EInteger ret4 = ValueBigIntPowersOfTen[18];
            bigpow = ValueBigIntPowersOfTen[precision - 18];
            ret4 = ret4.Multiply(bigpow);
            ValuePowerOfTenCache.AddPower(origPrecision, ret4);
            return ret4;
        }
        boolean first = true;
        bigpow = EInteger.FromInt32(0);
        while ((otherPower = ValuePowerOfTenCache.FindCachedPowerOrSmaller(EInteger.FromInt32(precision))) != null) {
            EInteger otherPower0 = otherPower[0];
            EInteger otherPower1 = otherPower[1];
            if (precision != otherPower0.ToInt32Checked()) {
                // empty if block
            }
            precision -= otherPower0.ToInt32Checked();
            bigpow = first ? otherPower[1] : bigpow.Multiply(otherPower1);
            first = false;
        }
        EInteger eInteger = ret = !first ? bigpow : EInteger.FromInt32(1);
        while (precision > 0) {
            if (precision <= 18) {
                bigpow = ValueBigIntPowersOfTen[precision];
                ret = first ? bigpow : ret.Multiply(bigpow);
                first = false;
                break;
            }
            if (precision <= 9999999) {
                bigpow = NumberUtility.FindPowerOfFive(precision);
                bigpow = bigpow.ShiftLeft(precision);
                if (precision != startPrecision) {
                    EInteger bigprec = EInteger.FromInt32(precision);
                    ValuePowerOfTenCache.AddPower(bigprec, bigpow);
                }
                ret = first ? bigpow : ret.Multiply(bigpow);
                first = false;
                break;
            }
            if (bigpow.isZero()) {
                bigpow = NumberUtility.FindPowerOfTen(9999999);
            }
            ret = first ? bigpow : ret.Multiply(bigpow);
            first = false;
            precision -= 9999999;
        }
        ValuePowerOfTenCache.AddPower(origPrecision, ret);
        return ret;
    }

    public static EInteger ReduceTrailingZeros(EInteger bigmant, FastInteger exponentMutable, int radix, FastInteger digits, FastInteger precision, FastInteger idealExp) {
        if (bigmant.isZero()) {
            exponentMutable.SetInt(0);
            return bigmant;
        }
        EInteger bigradix = EInteger.FromInt32(radix);
        int bitToTest = 0;
        FastInteger bitsToShift = new FastInteger(0);
        while (!(bigmant.isZero() || precision != null && digits.compareTo(precision) == 0 || idealExp != null && exponentMutable.compareTo(idealExp) == 0)) {
            if (radix == 2) {
                if (bitToTest < Integer.MAX_VALUE) {
                    if (bigmant.GetSignedBit(bitToTest)) break;
                    ++bitToTest;
                    bitsToShift.Increment();
                } else {
                    if (!bigmant.isEven()) break;
                    bigmant = bigmant.ShiftRight(1);
                }
            } else {
                EInteger[] divrem = bigmant.DivRem(bigradix);
                EInteger bigquo = divrem[0];
                EInteger bigrem = divrem[1];
                if (!bigrem.isZero()) break;
                bigmant = bigquo;
            }
            exponentMutable.Increment();
            if (digits == null) continue;
            digits.Decrement();
        }
        if (radix == 2 && !bitsToShift.isValueZero()) {
            while (bitsToShift.CompareToInt(1000000) > 0) {
                bigmant = bigmant.ShiftRight(1000000);
                bitsToShift.SubtractInt(1000000);
            }
            int tmpshift = bitsToShift.AsInt32();
            bigmant = bigmant.ShiftRight(tmpshift);
        }
        return bigmant;
    }

    private static final class PowerCache {
        private static final int MaxSize = 128;
        private final EInteger[] outputs = new EInteger[128];
        private final EInteger[] inputs = new EInteger[128];
        private final int[] inputsInts = new int[128];
        private int size;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EInteger[] FindCachedPowerOrSmaller(EInteger bi) {
            EInteger[] ret = null;
            EInteger minValue = null;
            if (bi.CanFitInInt32()) {
                return this.FindCachedPowerIntOrSmaller(bi.ToInt32Checked());
            }
            EInteger[] eIntegerArray = this.outputs;
            synchronized (this.outputs) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.inputs[i].compareTo(bi) > 0 || minValue != null && this.inputs[i].compareTo(minValue) < 0) continue;
                    ret = new EInteger[]{this.inputs[i], this.outputs[i]};
                    minValue = this.inputs[i];
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EInteger[] FindCachedPowerIntOrSmaller(int precision) {
            EInteger[] ret = null;
            int integerMinValue = -1;
            EInteger[] eIntegerArray = this.outputs;
            synchronized (this.outputs) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.inputsInts[i] < 0 || this.inputsInts[i] > precision || integerMinValue != -1 && this.inputsInts[i] < integerMinValue) continue;
                    ret = new EInteger[]{this.inputs[i], this.outputs[i]};
                    integerMinValue = this.inputsInts[i];
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EInteger GetCachedPower(EInteger bi) {
            if (bi.CanFitInInt32()) {
                return this.GetCachedPowerInt(bi.ToInt32Checked());
            }
            EInteger[] eIntegerArray = this.outputs;
            synchronized (this.outputs) {
                for (int i = 0; i < this.size; ++i) {
                    if (!bi.equals(this.inputs[i])) continue;
                    if (i != 0) {
                        EInteger tmp = this.inputs[i];
                        this.inputs[i] = this.inputs[0];
                        this.inputs[0] = tmp;
                        int tmpi = this.inputsInts[i];
                        this.inputsInts[i] = this.inputsInts[0];
                        this.inputsInts[0] = tmpi;
                        tmp = this.outputs[i];
                        this.outputs[i] = this.outputs[0];
                        this.outputs[0] = tmp;
                        if (i != 1) {
                            tmp = this.inputs[i];
                            this.inputs[i] = this.inputs[1];
                            this.inputs[1] = tmp;
                            tmpi = this.inputsInts[i];
                            this.inputsInts[i] = this.inputsInts[1];
                            this.inputsInts[1] = tmpi;
                            tmp = this.outputs[i];
                            this.outputs[i] = this.outputs[1];
                            this.outputs[1] = tmp;
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.outputs[0];
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EInteger GetCachedPowerInt(int bi) {
            EInteger[] eIntegerArray = this.outputs;
            synchronized (this.outputs) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.inputsInts[i] < 0 || this.inputsInts[i] != bi) continue;
                    if (i != 0) {
                        EInteger tmp = this.inputs[i];
                        this.inputs[i] = this.inputs[0];
                        this.inputs[0] = tmp;
                        int tmpi = this.inputsInts[i];
                        this.inputsInts[i] = this.inputsInts[0];
                        this.inputsInts[0] = tmpi;
                        tmp = this.outputs[i];
                        this.outputs[i] = this.outputs[0];
                        this.outputs[0] = tmp;
                        if (i != 1) {
                            tmp = this.inputs[i];
                            this.inputs[i] = this.inputs[1];
                            this.inputs[1] = tmp;
                            tmpi = this.inputsInts[i];
                            this.inputsInts[i] = this.inputsInts[1];
                            this.inputsInts[1] = tmpi;
                            tmp = this.outputs[i];
                            this.outputs[i] = this.outputs[1];
                            this.outputs[1] = tmp;
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.outputs[0];
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void AddPower(EInteger input, EInteger output) {
            EInteger[] eIntegerArray = this.outputs;
            synchronized (this.outputs) {
                if (this.size < 128) {
                    for (int i = this.size; i > 0; --i) {
                        this.inputs[i] = this.inputs[i - 1];
                        this.inputsInts[i] = this.inputsInts[i - 1];
                        this.outputs[i] = this.outputs[i - 1];
                    }
                    this.inputs[0] = input;
                    this.inputsInts[0] = input.CanFitInInt32() ? input.ToInt32Checked() : -1;
                    this.outputs[0] = output;
                    ++this.size;
                } else {
                    for (int i = 127; i > 0; --i) {
                        this.inputs[i] = this.inputs[i - 1];
                        this.inputsInts[i] = this.inputsInts[i - 1];
                        this.outputs[i] = this.outputs[i - 1];
                    }
                    this.inputs[0] = input;
                    this.inputsInts[0] = input.CanFitInInt32() ? input.ToInt32Checked() : -1;
                    this.outputs[0] = output;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }
}

