/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.util.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CertificateTypeExtension
extends HelloExtension {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateTypeExtension.class.getName());
    protected static final int LIST_FIELD_LENGTH_BITS = 8;
    protected static final int EXTENSION_TYPE_BITS = 8;
    private final boolean isClientExtension;
    private final List<CertificateType> certificateTypes;

    protected CertificateTypeExtension(HelloExtension.ExtensionType type, byte[] extensionData) {
        super(type);
        ArrayList<CertificateType> types;
        if (extensionData == null) {
            throw new NullPointerException("extension data must not be null!");
        }
        if (extensionData.length == 0) {
            throw new IllegalArgumentException("extension data must not be empty!");
        }
        this.isClientExtension = extensionData.length > 1;
        DatagramReader reader = new DatagramReader(extensionData);
        if (this.isClientExtension) {
            int length = reader.read(8);
            types = new ArrayList<CertificateType>(length);
            for (int i = 0; i < length; ++i) {
                int typeCode = reader.read(8);
                CertificateType certificateType = CertificateType.getTypeFromCode(typeCode);
                if (certificateType != null) {
                    types.add(certificateType);
                    continue;
                }
                LOG.debug("Client indicated preference for unknown {} certificate type code [{}]", (Object)(this.getType().equals((Object)HelloExtension.ExtensionType.CLIENT_CERT_TYPE) ? "client" : "server"), (Object)typeCode);
            }
        } else {
            int typeCode = reader.read(8);
            CertificateType certificateType = CertificateType.getTypeFromCode(typeCode);
            if (certificateType != null) {
                types = new ArrayList(1);
                types.add(certificateType);
            } else {
                LOG.debug("Server selected an unknown {} certificate type code [{}]", (Object)(this.getType().equals((Object)HelloExtension.ExtensionType.CLIENT_CERT_TYPE) ? "client" : "server"), (Object)typeCode);
                throw new IllegalArgumentException("unknown certificate type code " + typeCode + "!");
            }
        }
        this.certificateTypes = ListUtils.init(types);
    }

    protected CertificateTypeExtension(HelloExtension.ExtensionType type, List<CertificateType> certificateTypes) {
        super(type);
        if (certificateTypes == null) {
            throw new NullPointerException("certificate types must not be null!");
        }
        if (certificateTypes.isEmpty()) {
            throw new IllegalArgumentException("certificate types data must not be empty!");
        }
        this.isClientExtension = true;
        this.certificateTypes = certificateTypes;
    }

    protected CertificateTypeExtension(HelloExtension.ExtensionType type, CertificateType certificateType) {
        super(type);
        if (certificateType == null) {
            throw new NullPointerException("certificate type must not be null!");
        }
        this.isClientExtension = false;
        this.certificateTypes = new ArrayList<CertificateType>(1);
        this.certificateTypes.add(certificateType);
    }

    public boolean isClientExtension() {
        return this.isClientExtension;
    }

    @Override
    public int getLength() {
        if (this.isClientExtension) {
            return 5 + this.certificateTypes.size();
        }
        return 5;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    protected void addExtensionData(DatagramWriter writer) {
        if (this.isClientExtension) {
            int listLength = this.certificateTypes.size();
            writer.write(1 + listLength, 16);
            writer.write(listLength, 8);
            for (CertificateType type : this.certificateTypes) {
                writer.write(type.getCode(), 8);
            }
        } else {
            writer.write(1, 16);
            writer.write(this.certificateTypes.get(0).getCode(), 8);
        }
    }

    public List<CertificateType> getCertificateTypes() {
        return this.certificateTypes;
    }
}

