/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.elements.assume.TimeAssume;
import org.eclipse.californium.elements.util.LeastRecentlyUsedCache;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class LeastRecentlyUsedCacheTest {
    private static final long THRESHOLD_MILLIS = 300L;
    LeastRecentlyUsedCache<Integer, String> cache;

    @Test
    public void testGetFailsWhenExpired() throws InterruptedException {
        int capacity = 5;
        int numberOfSessions = 1;
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(true);
        String eldest = this.cache.getEldest();
        Integer key = Integer.valueOf(eldest);
        Assert.assertNotNull((Object)this.cache.get(key));
        Thread.sleep(400L);
        Assert.assertNull((Object)this.cache.get(key));
    }

    @Test
    public void testGetSucceedsEvenExpired() throws InterruptedException {
        int capacity = 5;
        int numberOfSessions = 1;
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(false);
        String eldest = this.cache.getEldest();
        Integer key = Integer.valueOf(eldest);
        Assert.assertNotNull((Object)this.cache.get(key));
        Thread.sleep(400L);
        Assert.assertNotNull((Object)this.cache.get(key));
    }

    @Test
    public void testUpdate() throws InterruptedException {
        int capacity = 5;
        int numberOfSessions = 1;
        TimeAssume assume = new TimeAssume();
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(true);
        this.cache.setUpdatingOnReadAccess(false);
        String eldest = this.cache.getEldest();
        Integer key = Integer.valueOf(eldest);
        assume.sleep(150L);
        Assert.assertThat((Object)this.cache.get(key), assume.inTime(CoreMatchers.is((Matcher)CoreMatchers.notNullValue())));
        Assert.assertThat((Object)this.cache.update(key), assume.inTime(CoreMatchers.is((Object)true)));
        assume.sleep(250L);
        Assert.assertThat((Object)this.cache.get(key), assume.inTime(CoreMatchers.is((Matcher)CoreMatchers.notNullValue())));
        Assert.assertThat((Object)this.cache.update(key), assume.inTime(CoreMatchers.is((Object)true)));
        assume.sleep(150L);
        Assert.assertThat((Object)this.cache.get(key), assume.inTime(CoreMatchers.is((Matcher)CoreMatchers.notNullValue())));
        assume.sleep(250L);
        Assert.assertThat((Object)this.cache.get(key), assume.inTime(CoreMatchers.is((Matcher)CoreMatchers.nullValue())));
    }

    @Test
    public void testIteratorWhenExpired() throws InterruptedException {
        int capacity = 5;
        int numberOfSessions = 5;
        TimeAssume assume = new TimeAssume();
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(true);
        assume.sleep(150L);
        Iterator<String> valuesIterator = this.cache.valuesIterator();
        this.cache.setUpdatingOnReadAccess(true);
        this.assertNext(valuesIterator, assume);
        this.cache.setUpdatingOnReadAccess(false);
        this.assertNext(valuesIterator, assume);
        this.cache.setUpdatingOnReadAccess(true);
        this.assertNext(valuesIterator, assume);
        this.cache.setUpdatingOnReadAccess(false);
        this.assertNext(valuesIterator, assume);
        this.cache.setUpdatingOnReadAccess(true);
        this.assertNext(valuesIterator, assume);
        assume.sleep(170L, 100L);
        valuesIterator = this.cache.valuesIterator();
        this.assertNext(valuesIterator, assume);
        this.assertNext(valuesIterator, assume);
        this.assertNext(valuesIterator, assume);
        Assert.assertFalse((boolean)valuesIterator.hasNext());
    }

    private void assertNext(Iterator<String> iterator, TimeAssume assume) {
        String value = iterator.hasNext() ? iterator.next() : null;
        Assert.assertThat((Object)value, assume.inTime(CoreMatchers.is((Matcher)CoreMatchers.notNullValue())));
    }

    @Test
    public void testFindUniqueFailsWhenExpired() throws InterruptedException {
        int capacity = 5;
        int numberOfSessions = 3;
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(true);
        final String eldest = this.cache.getEldest();
        LeastRecentlyUsedCache.Predicate<String> predicate = new LeastRecentlyUsedCache.Predicate<String>(){

            @Override
            public boolean accept(String value) {
                return eldest.equals(value);
            }
        };
        Assert.assertNotNull((Object)this.cache.find(predicate));
        Thread.sleep(400L);
        Assert.assertNull((Object)this.cache.find(predicate));
    }

    @Test
    public void testFindUniqueSucceedsEvenExpired() throws InterruptedException {
        int capacity = 5;
        int numberOfSessions = 3;
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(false);
        final String eldest = this.cache.getEldest();
        LeastRecentlyUsedCache.Predicate<String> predicate = new LeastRecentlyUsedCache.Predicate<String>(){

            @Override
            public boolean accept(String value) {
                return eldest.equals(value);
            }
        };
        Assert.assertNotNull((Object)this.cache.find(predicate));
        Thread.sleep(400L);
        Assert.assertNotNull((Object)this.cache.find(predicate));
    }

    @Test
    public void testFindNoneUniqueSucceedsEvenFirstEvicted() throws InterruptedException {
        int capacity = 5;
        int numberOfSessions = 3;
        TimeAssume assume = new TimeAssume();
        this.givenACacheWithEntries(capacity, 300L, numberOfSessions);
        this.cache.setEvictingOnReadAccess(true);
        assume.sleep(150L);
        SkipFirsts predicate = new SkipFirsts(1);
        String value = this.cache.find(predicate, false);
        Assert.assertThat((Object)value, assume.inTime(CoreMatchers.is((Matcher)CoreMatchers.notNullValue())));
        assume.sleep(250L);
        EvictionCounter counter = new EvictionCounter();
        this.cache.addEvictionListener(counter);
        predicate = new SkipFirsts(0);
        Assert.assertThat((Object)this.cache.find(predicate, false), assume.inTime(CoreMatchers.is((Object)value)));
        Assert.assertThat((Object)counter.count, (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testStoreAddsNewValueIfCapacityNotReached() {
        int capacity = 10;
        this.givenACacheWithEntries(capacity, 0L, capacity - 1);
        Assert.assertThat((Object)this.cache.remainingCapacity(), (Matcher)CoreMatchers.is((Object)1));
        String eldest = this.cache.getEldest();
        String newValue = "50";
        Assert.assertTrue((boolean)this.cache.put(50, newValue));
        Assert.assertNotNull((Object)this.cache.get(Integer.valueOf(eldest)));
        Assert.assertThat((Object)this.cache.remainingCapacity(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testStoreEvictsEldestStaleEntry() {
        int capacity = 10;
        this.givenACacheWithEntries(capacity, 0L, capacity);
        Assert.assertThat((Object)this.cache.remainingCapacity(), (Matcher)CoreMatchers.is((Object)0));
        String eldest = this.cache.getEldest();
        String newValue = "50";
        Assert.assertTrue((boolean)this.cache.put(Integer.valueOf(newValue), newValue));
        Assert.assertNull((Object)this.cache.get(Integer.valueOf(eldest)));
    }

    @Test
    public void testStoreFailsIfCapacityReached() {
        int capacity = 10;
        int numberOfSessions = 10;
        this.givenACacheWithEntries(capacity, 30000L, numberOfSessions);
        Assert.assertThat((Object)this.cache.remainingCapacity(), (Matcher)CoreMatchers.is((Object)0));
        String eldest = this.cache.getEldest();
        String newValue = "50";
        Integer key = Integer.valueOf(newValue);
        Assert.assertFalse((boolean)this.cache.put(key, newValue));
        Assert.assertNull((Object)this.cache.get(key));
        Assert.assertNotNull((Object)this.cache.get(Integer.valueOf(eldest)));
    }

    @Test
    public void testContinuousEviction() {
        int capacity = 10;
        this.givenACacheWithEntries(capacity, 0L, 0);
        Assert.assertThat((Object)this.cache.remainingCapacity(), (Matcher)CoreMatchers.is((Object)capacity));
        final AtomicInteger evicted = new AtomicInteger(0);
        this.cache.addEvictionListener(new LeastRecentlyUsedCache.EvictionListener<String>(){

            @Override
            public void onEviction(String evictedSession) {
                evicted.incrementAndGet();
            }
        });
        int noOfSessions = 1000;
        for (int i = 0; i < noOfSessions; ++i) {
            Integer key = i + 1000;
            String value = String.valueOf(key);
            Assert.assertTrue((boolean)this.cache.put(key, value));
        }
        Assert.assertThat((Object)evicted.get(), (Matcher)CoreMatchers.is((Object)(noOfSessions - capacity)));
        Assert.assertThat((Object)this.cache.remainingCapacity(), (Matcher)CoreMatchers.is((Object)0));
    }

    private void givenACacheWithEntries(int capacity, long expirationThresholdMillis, int noOfEntries) {
        this.cache = new LeastRecentlyUsedCache(capacity, 0L);
        this.cache.setExpirationThreshold(expirationThresholdMillis, TimeUnit.MILLISECONDS);
        for (int i = 0; i < noOfEntries; ++i) {
            this.cache.put(i, Integer.toString(i));
        }
    }

    private static class EvictionCounter
    implements LeastRecentlyUsedCache.EvictionListener<String> {
        private int count;

        private EvictionCounter() {
        }

        @Override
        public void onEviction(String value) {
            ++this.count;
        }
    }

    private static class SkipFirsts
    implements LeastRecentlyUsedCache.Predicate<String> {
        private int skipCount;

        private SkipFirsts(int skipCount) {
            this.skipCount = skipCount;
        }

        @Override
        public boolean accept(String value) {
            return this.skipCount-- <= 0;
        }
    }
}

