/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.Arrays;
import org.eclipse.californium.elements.util.DatagramReader;

public class Asn1DerDecoder {
    private static final int MAX_SEQUENCE_LENGTH = 65536;
    private static final int TAG_SEQUENCE = 48;
    private static final int MAX_OID_LENGTH = 32;
    private static final int TAG_OID = 6;
    private static final byte[] OID_RSA_PUBLIC_KEY = new byte[]{42, -122, 72, -122, -9, 13, 1, 1, 1};
    private static final byte[] OID_DH_PUBLIC_KEY = new byte[]{42, -122, 72, -122, -9, 13, 1, 3, 1};
    private static final byte[] OID_DSA_PUBLIC_KEY = new byte[]{42, -122, 72, -50, 56, 4, 1};
    private static final byte[] OID_EC_PUBLIC_KEY = new byte[]{42, -122, 72, -50, 61, 2, 1};
    private static final EntityDefinition SEQUENCE = new EntityDefinition(48, 65536, "SEQUENCE");
    private static final EntityDefinition OID = new EntityDefinition(6, 32, "OID");

    public static byte[] readSequenceEntity(DatagramReader reader) {
        return SEQUENCE.readEntity(reader);
    }

    public static byte[] readSequenceValue(DatagramReader reader) {
        return SEQUENCE.readValue(reader);
    }

    public static byte[] readOidValue(DatagramReader reader) {
        return OID.readValue(reader);
    }

    public static String readSubjectPublicKeyAlgorithm(byte[] data) {
        DatagramReader reader = new DatagramReader(data);
        byte[] value = Asn1DerDecoder.readSequenceValue(reader);
        reader = new DatagramReader(value);
        value = Asn1DerDecoder.readSequenceValue(reader);
        reader = new DatagramReader(value);
        if (Arrays.equals(value = Asn1DerDecoder.readOidValue(reader), OID_EC_PUBLIC_KEY)) {
            return "EC";
        }
        if (Arrays.equals(value, OID_RSA_PUBLIC_KEY)) {
            return "RSA";
        }
        if (Arrays.equals(value, OID_DSA_PUBLIC_KEY)) {
            return "DSA";
        }
        if (Arrays.equals(value, OID_DH_PUBLIC_KEY)) {
            return "DH";
        }
        return null;
    }

    public static boolean equalKeyAlgorithmSynonyms(String keyAlgorithm1, String keyAlgorithm2) {
        if (!keyAlgorithm1.equals(keyAlgorithm2)) {
            if (keyAlgorithm1.equals("DH") && keyAlgorithm2.equals("DiffieHellman")) {
                return true;
            }
            return keyAlgorithm2.equals("DH") && keyAlgorithm1.equals("DiffieHellman");
        }
        return true;
    }

    private static class EntityDefinition {
        private static final int HEADER_LENGTH = 2;
        private final int expectedTag;
        private final int maxLength;
        private final String description;

        public EntityDefinition(int expectedTag, int maxLength, String description) {
            this.expectedTag = expectedTag;
            this.maxLength = maxLength;
            this.description = description;
        }

        public byte[] readEntity(DatagramReader reader) {
            return this.read(reader, true);
        }

        public byte[] readValue(DatagramReader reader) {
            return this.read(reader, false);
        }

        public byte[] read(DatagramReader reader, boolean entity) {
            int tag;
            int leftBytes = reader.bitsLeft() / 8;
            if (leftBytes < 2) {
                throw new IllegalArgumentException(String.format("Not enough bytes for %s! Required %d, available %d.", this.description, 2, leftBytes));
            }
            if (entity) {
                reader.mark();
            }
            if ((tag = reader.read(8)) != this.expectedTag) {
                throw new IllegalArgumentException(String.format("No %s, found %02x instead of %02x!", this.description, tag, this.expectedTag));
            }
            int length = reader.read(8);
            int entityLength = length + 2;
            if (length > 127) {
                if ((length &= 0x7F) > 4) {
                    throw new IllegalArgumentException(String.format("%s length-size %d too long!", this.description, length));
                }
                leftBytes = reader.bitsLeft() / 8;
                if (length > leftBytes) {
                    throw new IllegalArgumentException(String.format("%s length %d exceeds available bytes %d!", this.description, length, leftBytes));
                }
                byte[] lengthBytes = reader.readBytes(length);
                length = 0;
                for (int index = 0; index < lengthBytes.length; ++index) {
                    length <<= 8;
                    length += lengthBytes[index] & 0xFF;
                }
                entityLength = length + 2 + lengthBytes.length;
            }
            if (length > this.maxLength) {
                throw new IllegalArgumentException(String.format("%s lenght %d too large! (supported maxium %d)", this.description, length, this.maxLength));
            }
            leftBytes = reader.bitsLeft() / 8;
            if (length > leftBytes) {
                throw new IllegalArgumentException(String.format("%s lengh %d exceeds available bytes %d!", this.description, length, leftBytes));
            }
            if (entity) {
                reader.reset();
                length = entityLength;
            }
            return reader.readBytes(length);
        }
    }
}

