/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.runner;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatingTestRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepeatingTestRunner.class.getName());
    private static final int MEGA_BYTE = 0x100000;
    private static final int DEFAULT_MAXIMUM_REPEATS = 100;
    private static final int DEFAULT_ALIVE_INTERVAL_IN_MILLISECONDS = 1000;
    private final long maximumRepeats;
    private final int aliveIntervalInMilliseconds;

    public RepeatingTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
        Integer value = this.getProperty(RepeatingTestRunner.class.getName() + ".repeats");
        this.maximumRepeats = null == value ? 100L : (long)value.intValue();
        value = this.getProperty(RepeatingTestRunner.class.getName() + ".alive");
        this.aliveIntervalInMilliseconds = null == value ? 1000 : value;
    }

    private Integer getProperty(String name) {
        String value = System.getProperty(name);
        if (null != value) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException ex) {
                LOGGER.error("value for ''{}'' := ''{}'' is no number!", (Object)name, (Object)value);
            }
        }
        return null;
    }

    public void run(RunNotifier notifier) {
        if (0L == this.maximumRepeats) {
            LOGGER.info("repeat until error!");
        } else {
            LOGGER.info("maximum repeats: {}", (Object)this.maximumRepeats);
        }
        Thread alive = this.startAliveLogging();
        final AtomicInteger loop = new AtomicInteger();
        final AtomicInteger failureCounter = new AtomicInteger();
        notifier.addListener(new RunListener(){

            public void testStarted(Description description) throws Exception {
                RepeatingTestRunner.this.logInfo("test", "[loop={}] started {}.", new Object[]{loop, description});
            }

            public void testFinished(Description description) throws Exception {
                RepeatingTestRunner.this.logInfo("test", "[loop={}] finished {}.", new Object[]{loop, description});
            }

            public void testFailure(Failure failure) throws Exception {
                RepeatingTestRunner.this.logInfo("test", "[loop={}] failed {}.", new Object[]{loop, failure});
                failureCounter.incrementAndGet();
            }

            public void testAssumptionFailure(Failure failure) {
                failureCounter.incrementAndGet();
            }
        });
        while ((long)loop.incrementAndGet() <= this.maximumRepeats || 0L == this.maximumRepeats) {
            this.logInfo("while", "[loop={}] begin", loop);
            super.run(notifier);
            if (0 < failureCounter.get()) {
                this.logInfo("while", "[loop={}] failed!", loop);
                break;
            }
            this.logInfo("while", "[loop={}] ready", loop);
        }
        if (null != alive) {
            try {
                alive.join(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void logInfo(String tag, String format, Object ... parameters) {
        if (LOGGER.isInfoEnabled()) {
            Runtime runtime = Runtime.getRuntime();
            LOGGER.info(tag + ": " + format, parameters);
            LOGGER.info(tag + ": memory free {} MByte, total {} MByte, max {} MByte", runtime.freeMemory() / 0x100000L, runtime.totalMemory() / 0x100000L, runtime.maxMemory() / 0x100000L);
        }
    }

    private Thread startAliveLogging() {
        Thread live = null;
        if (0 < this.aliveIntervalInMilliseconds && LOGGER.isInfoEnabled()) {
            LOGGER.info("start alife logging every {}ms!", (Object)this.aliveIntervalInMilliseconds);
            live = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        int count = 0;
                        long start = System.nanoTime();
                        while (true) {
                            Thread.sleep(RepeatingTestRunner.this.aliveIntervalInMilliseconds);
                            long time = TimeUnit.NANOSECONDS.toMillis((System.nanoTime() - start) / (long)(++count));
                            RepeatingTestRunner.this.logInfo("alive", "{}. {}ms", new Object[]{count, time});
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }, "live");
            live.setDaemon(true);
            live.start();
        }
        return live;
    }
}

