/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.RemoteEndpoint;
import org.eclipse.californium.core.network.RemoteEndpointManager;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.stack.ReliabilityLayer;
import org.eclipse.californium.core.network.stack.congestioncontrol.BasicRto;
import org.eclipse.californium.core.network.stack.congestioncontrol.Cocoa;
import org.eclipse.californium.core.network.stack.congestioncontrol.CocoaStrong;
import org.eclipse.californium.core.network.stack.congestioncontrol.LinuxRto;
import org.eclipse.californium.core.network.stack.congestioncontrol.PeakhopperRto;

public abstract class CongestionControlLayer
extends ReliabilityLayer {
    protected NetworkConfig config;
    private static final long MAX_REMOTE_TRANSACTION_DURATION = 255000L;
    private static final int MAX_SUCCESSIVE_NONS = 7;
    protected static final int OVERALLRTOTYPE = 0;
    protected static final int STRONGRTOTYPE = 1;
    protected static final int WEAKRTOTYPE = 2;
    protected static final int NOESTIMATOR = 3;
    private static final int EXCHANGELIMIT = 50;
    private static final int MAX_RTO = 60000;
    private boolean appliesDithering;
    private RemoteEndpointManager remoteEndpointmanager;

    public CongestionControlLayer(NetworkConfig config) {
        super(config);
        this.config = config;
        this.remoteEndpointmanager = new RemoteEndpointManager(config);
        this.setDithering(false);
    }

    protected RemoteEndpoint getRemoteEndpoint(Exchange exchange) {
        return this.remoteEndpointmanager.getRemoteEndpoint(exchange);
    }

    public boolean appliesDithering() {
        return this.appliesDithering;
    }

    public void setDithering(boolean mode) {
        this.appliesDithering = mode;
    }

    private boolean processMessage(Exchange exchange, Message message) {
        CoAP.Type messageType = message.getType();
        if (messageType == CoAP.Type.CON) {
            if (!this.checkNSTART(exchange)) {
                return false;
            }
        } else if (this.getRemoteEndpoint(exchange).getNonConfirmableCounter() > 7) {
            if (exchange.getCurrentRequest().getDestinationContext().getPeerAddress().getPort() != 0) {
                exchange.getCurrentRequest().setType(CoAP.Type.CON);
            } else if (exchange.getCurrentResponse() != null) {
                exchange.getCurrentResponse().setType(CoAP.Type.CON);
            }
            this.getRemoteEndpoint(exchange).resetNonConfirmableCounter();
            if (!this.checkNSTART(exchange)) {
                return false;
            }
        } else {
            if (this.getRemoteEndpoint(exchange).getNonConfirmableQueue().size() != 50) {
                this.getRemoteEndpoint(exchange).getNonConfirmableQueue().add(exchange);
                if (!this.getRemoteEndpoint(exchange).getProcessingNON()) {
                    this.executor.schedule(new BucketThread(this.getRemoteEndpoint(exchange)), 0L, TimeUnit.MILLISECONDS);
                }
            }
            return false;
        }
        return true;
    }

    private boolean checkNSTART(Exchange exchange) {
        this.getRemoteEndpoint(exchange).checkForDeletedExchanges();
        if (this.getRemoteEndpoint(exchange).getNumberOfOngoingExchanges(exchange) < this.config.getInt("NSTART")) {
            this.getRemoteEndpoint(exchange).registerExchange(exchange, this.calculateVBF(this.getRemoteEndpoint(exchange).getRTO()));
            this.executor.schedule(new SweepCheckTask(this.getRemoteEndpoint(exchange), exchange), 255000L, TimeUnit.MILLISECONDS);
            return true;
        }
        if (this.getRemoteEndpoint(exchange).getConfirmableQueue().size() != 50) {
            this.getRemoteEndpoint(exchange).getConfirmableQueue().add(exchange);
        }
        return false;
    }

    private void calculateRTT(Exchange exchange) {
        long timestamp = this.getRemoteEndpoint(exchange).getExchangeTimestamp(exchange);
        if (timestamp != 0L) {
            long measuredRTT = System.currentTimeMillis() - timestamp;
            this.processRTTmeasurement(measuredRTT, exchange, exchange.getFailedTransmissionCount());
            this.getRemoteEndpoint(exchange).removeExchangeInfo(exchange);
        }
    }

    protected void processRTTmeasurement(long measuredRTT, Exchange exchange, int retransmissionCount) {
    }

    protected void checkAging(Exchange exchange) {
    }

    protected void initializeRTOEstimators(long measuredRTT, int estimatorType, RemoteEndpoint endpoint) {
        long newRTO = this.config.getInt("ACK_TIMEOUT");
        endpoint.updateRTO(newRTO);
    }

    protected void updateEstimator(long measuredRTT, int estimatorType, RemoteEndpoint endpoint) {
        long newRTO = this.config.getInt("ACK_TIMEOUT");
        endpoint.updateRTO(newRTO);
    }

    protected double calculateVBF(long rto) {
        return this.config.getFloat("ACK_TIMEOUT_SCALE");
    }

    private void checkRemoteEndpointQueue(Exchange exchange) {
        if (!this.getRemoteEndpoint(exchange).getConfirmableQueue().isEmpty()) {
            Exchange queuedExchange = this.getRemoteEndpoint(exchange).getConfirmableQueue().poll();
            if (queuedExchange.getCurrentResponse() != null) {
                this.sendResponse(queuedExchange, queuedExchange.getCurrentResponse());
            } else if (queuedExchange.getCurrentRequest() != null) {
                this.sendRequest(queuedExchange, queuedExchange.getCurrentRequest());
            }
        }
    }

    @Override
    public void sendRequest(Exchange exchange, Request request) {
        if (exchange.getFailedTransmissionCount() > 0) {
            super.sendRequest(exchange, request);
        } else if (this.processMessage(exchange, request)) {
            this.checkAging(exchange);
            super.sendRequest(exchange, request);
        }
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        if (exchange.getFailedTransmissionCount() > 0) {
            super.sendResponse(exchange, response);
        } else if (this.processMessage(exchange, response)) {
            this.checkAging(exchange);
            super.sendResponse(exchange, response);
        }
    }

    @Override
    protected void updateRetransmissionTimeout(Exchange exchange) {
        int timeout;
        if (exchange.getFailedTransmissionCount() == 0) {
            timeout = (int)this.getRemoteEndpoint(exchange).getRTO();
            if (this.appliesDithering()) {
                this.getRemoteEndpoint(exchange).matchCurrentRTO();
                timeout = (int)this.getRemoteEndpoint(exchange).getRTO();
                float ack_random_factor = this.config.getFloat("ACK_RANDOM_FACTOR");
                timeout = this.getRandomTimeout(timeout, (int)((float)timeout * ack_random_factor));
            }
        } else {
            int tempTimeout = (int)(this.getRemoteEndpoint(exchange).getExchangeVBF(exchange) * (double)exchange.getCurrentTimeout());
            timeout = tempTimeout < 60000 ? tempTimeout : 60000;
            this.getRemoteEndpoint(exchange).setCurrentRTO(timeout);
        }
        exchange.setCurrentTimeout(timeout);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        if (exchange.getFailedTransmissionCount() != 0) {
            this.getRemoteEndpoint(exchange).setEstimatorState(exchange);
        }
        super.receiveResponse(exchange, response);
        this.calculateRTT(exchange);
        this.checkRemoteEndpointQueue(exchange);
    }

    @Override
    public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        if (exchange.getFailedTransmissionCount() != 0) {
            this.getRemoteEndpoint(exchange).setEstimatorState(exchange);
        }
        super.receiveEmptyMessage(exchange, message);
        this.calculateRTT(exchange);
        this.checkRemoteEndpointQueue(exchange);
    }

    public void sendBucketRequest(Exchange exchange, Request request) {
        super.sendRequest(exchange, request);
    }

    public void sendBucketResponse(Exchange exchange, Response response) {
        super.sendResponse(exchange, response);
    }

    public static CongestionControlLayer newImplementation(NetworkConfig config) {
        String implementation;
        switch (implementation = config.getString("CONGESTION_CONTROL_ALGORITHM", "Cocoa")) {
            case "Cocoa": {
                return new Cocoa(config);
            }
            case "CocoaStrong": {
                return new CocoaStrong(config);
            }
            case "BasicRto": {
                return new BasicRto(config);
            }
            case "LinuxRto": {
                return new LinuxRto(config);
            }
            case "PeakhopperRto": {
                return new PeakhopperRto(config);
            }
        }
        LOGGER.info("configuration contains unsupported {}, using Cocoa", (Object)"CONGESTION_CONTROL_ALGORITHM");
        return new Cocoa(config);
    }

    private class SweepCheckTask
    implements Runnable {
        final RemoteEndpoint endpoint;
        final Exchange exchange;

        public SweepCheckTask(RemoteEndpoint endpoint, Exchange exchange) {
            this.endpoint = endpoint;
            this.exchange = exchange;
        }

        @Override
        public void run() {
            if (this.endpoint.removeExchangeInfo(this.exchange)) {
                CongestionControlLayer.this.checkRemoteEndpointQueue(this.exchange);
            }
        }
    }

    private class BucketThread
    implements Runnable {
        RemoteEndpoint endpoint;

        public BucketThread(RemoteEndpoint queue) {
            this.endpoint = queue;
        }

        @Override
        public void run() {
            if (!this.endpoint.getNonConfirmableQueue().isEmpty()) {
                this.endpoint.setProcessingNON(true);
                Exchange exchange = this.endpoint.getNonConfirmableQueue().poll();
                if (CongestionControlLayer.this.getRemoteEndpoint(exchange).getNonConfirmableCounter() <= 7) {
                    CongestionControlLayer.this.getRemoteEndpoint(exchange).increaseNonConfirmableCounter();
                    if (exchange.getCurrentRequest().getDestinationContext().getPeerAddress().getPort() != 0) {
                        CongestionControlLayer.this.sendBucketRequest(exchange, exchange.getCurrentRequest());
                    } else if (exchange.getCurrentResponse() != null) {
                        CongestionControlLayer.this.sendBucketResponse(exchange, exchange.getCurrentResponse());
                    }
                }
                CongestionControlLayer.this.executor.schedule(new BucketThread(CongestionControlLayer.this.getRemoteEndpoint(exchange)), CongestionControlLayer.this.getRemoteEndpoint(exchange).getRTO(), TimeUnit.MILLISECONDS);
            } else {
                this.endpoint.setProcessingNON(false);
            }
        }
    }
}

