/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.deduplication;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.deduplication.Deduplicator;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SweepDeduplicator
implements Deduplicator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SweepDeduplicator.class.getName());
    private final ConcurrentMap<Exchange.KeyMID, DedupExchange> incomingMessages = new ConcurrentHashMap<Exchange.KeyMID, DedupExchange>();
    private final SweepAlgorithm algorithm = new SweepAlgorithm();
    private final long sweepInterval;
    private final long exchangeLifetime;
    private volatile ScheduledFuture<?> jobStatus;

    public SweepDeduplicator(NetworkConfig config) {
        this.sweepInterval = config.getLong("MARK_AND_SWEEP_INTERVAL");
        this.exchangeLifetime = config.getLong("EXCHANGE_LIFETIME");
    }

    @Override
    public synchronized void start() {
        if (this.jobStatus == null) {
            this.jobStatus = ExecutorsUtil.getScheduledExecutor().scheduleAtFixedRate(this.algorithm, this.sweepInterval, this.sweepInterval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.jobStatus != null) {
            this.jobStatus.cancel(false);
            this.jobStatus = null;
            this.clear();
        }
    }

    @Override
    public Exchange findPrevious(Exchange.KeyMID key, Exchange exchange) {
        DedupExchange previous = this.incomingMessages.putIfAbsent(key, new DedupExchange(exchange));
        return null == previous ? null : previous.exchange;
    }

    @Override
    public Exchange find(Exchange.KeyMID key) {
        DedupExchange previous = (DedupExchange)this.incomingMessages.get(key);
        return null == previous ? null : previous.exchange;
    }

    @Override
    public void clear() {
        this.incomingMessages.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.incomingMessages.isEmpty();
    }

    @Override
    public int size() {
        return this.incomingMessages.size();
    }

    private class SweepAlgorithm
    implements Runnable {
        private SweepAlgorithm() {
        }

        @Override
        public void run() {
            try {
                LOGGER.trace("Start Mark-And-Sweep with {} entries", (Object)SweepDeduplicator.this.incomingMessages.size());
                this.sweep();
            }
            catch (Throwable t) {
                LOGGER.warn("Exception in Mark-and-Sweep algorithm", t);
            }
        }

        private void sweep() {
            if (!SweepDeduplicator.this.incomingMessages.isEmpty()) {
                long start = ClockUtil.nanoRealtime();
                long oldestAllowed = start - TimeUnit.MILLISECONDS.toNanos(SweepDeduplicator.this.exchangeLifetime);
                for (Map.Entry entry : SweepDeduplicator.this.incomingMessages.entrySet()) {
                    DedupExchange exchange = (DedupExchange)entry.getValue();
                    if (exchange.nanoTimestamp - oldestAllowed >= 0L) continue;
                    LOGGER.trace("Mark-And-Sweep removes {}", entry.getKey());
                    SweepDeduplicator.this.incomingMessages.remove(entry.getKey());
                }
                LOGGER.debug("Sweep run took {}ms", (Object)TimeUnit.NANOSECONDS.toMillis(ClockUtil.nanoRealtime() - start));
            }
        }
    }

    private static class DedupExchange {
        public final long nanoTimestamp;
        public final Exchange exchange;

        public DedupExchange(Exchange exchange) {
            this.exchange = exchange;
            this.nanoTimestamp = ClockUtil.nanoRealtime();
        }
    }
}

