/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.server.MessageDeliverer;
import org.eclipse.californium.core.server.ServerInterface;
import org.eclipse.californium.core.server.ServerMessageDeliverer;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.DiscoveryResource;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoapServer
implements ServerInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoapServer.class.getName());
    private final Resource root;
    private final NetworkConfig config;
    private MessageDeliverer deliverer;
    private final List<Endpoint> endpoints;
    private ScheduledExecutorService executor;
    private boolean detachExecutor;
    private boolean running;

    public CoapServer() {
        this(NetworkConfig.getStandard(), new int[0]);
    }

    public CoapServer(int ... ports) {
        this(NetworkConfig.getStandard(), ports);
    }

    public CoapServer(NetworkConfig config, int ... ports) {
        this.config = config != null ? config : NetworkConfig.getStandard();
        this.root = this.createRoot();
        this.deliverer = new ServerMessageDeliverer(this.root);
        CoapResource wellKnown = new CoapResource(".well-known");
        wellKnown.setVisible(false);
        wellKnown.add((CoapResource)new DiscoveryResource(this.root));
        this.root.add(wellKnown);
        this.endpoints = new ArrayList<Endpoint>();
        for (int port : ports) {
            CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
            builder.setPort(port);
            builder.setNetworkConfig(config);
            this.addEndpoint(builder.build());
        }
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this.setExecutor(executor, false);
    }

    public synchronized void setExecutor(ScheduledExecutorService executor, boolean detach) {
        if (this.executor != executor) {
            if (this.running) {
                throw new IllegalStateException("executor service can not be set on running server");
            }
            if (!this.detachExecutor && this.executor != null) {
                this.executor.shutdownNow();
            }
            this.executor = executor;
            this.detachExecutor = detach;
            for (Endpoint ep : this.endpoints) {
                ep.setExecutor(executor);
            }
        }
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            return;
        }
        LOGGER.info("Starting server");
        if (this.executor == null) {
            this.setExecutor(ExecutorsUtil.newScheduledThreadPool(this.config.getInt("PROTOCOL_STAGE_THREAD_COUNT"), new NamedThreadFactory("CoapServer#")));
        }
        if (this.endpoints.isEmpty()) {
            int port = this.config.getInt("COAP_PORT");
            LOGGER.info("no endpoints have been defined for server, setting up server endpoint on default port {}", (Object)port);
            CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
            builder.setPort(port);
            builder.setNetworkConfig(this.config);
            this.addEndpoint(builder.build());
        }
        int started = 0;
        for (Endpoint ep : this.endpoints) {
            try {
                ep.start();
                ++started;
            }
            catch (IOException e) {
                LOGGER.error("cannot start server endpoint [{}]", (Object)ep.getAddress(), (Object)e);
            }
        }
        if (started == 0) {
            throw new IllegalStateException("None of the server endpoints could be started");
        }
        this.running = true;
    }

    @Override
    public synchronized void stop() {
        if (this.running) {
            LOGGER.info("Stopping server");
            for (Endpoint ep : this.endpoints) {
                ep.stop();
            }
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void destroy() {
        block10: {
            LOGGER.info("Destroying server");
            try {
                if (this.detachExecutor) break block10;
                if (this.running) {
                    this.executor.shutdown();
                    try {
                        if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                            List<Runnable> runningTasks = this.executor.shutdownNow();
                            if (runningTasks.size() > 0) {
                                LOGGER.debug("ignoring remaining {} scheduled task(s)", (Object)runningTasks.size());
                            }
                            this.executor.awaitTermination(1L, TimeUnit.SECONDS);
                        }
                        break block10;
                    }
                    catch (InterruptedException e) {
                        this.executor.shutdownNow();
                        Thread.currentThread().interrupt();
                    }
                    break block10;
                }
                if (this.executor != null) {
                    this.executor.shutdownNow();
                }
            }
            finally {
                for (Endpoint ep : this.endpoints) {
                    ep.destroy();
                }
                LOGGER.info("CoAP server has been destroyed");
                this.running = false;
            }
        }
    }

    public void setMessageDeliverer(MessageDeliverer deliverer) {
        this.deliverer = deliverer;
        for (Endpoint endpoint : this.endpoints) {
            endpoint.setMessageDeliverer(deliverer);
        }
    }

    public MessageDeliverer getMessageDeliverer() {
        return this.deliverer;
    }

    @Override
    public void addEndpoint(Endpoint endpoint) {
        endpoint.setMessageDeliverer(this.deliverer);
        endpoint.setExecutor(this.executor);
        this.endpoints.add(endpoint);
    }

    @Override
    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public Endpoint getEndpoint(int port) {
        Endpoint endpoint = null;
        for (Endpoint ep : this.endpoints) {
            if (ep.getAddress().getPort() != port) continue;
            endpoint = ep;
        }
        return endpoint;
    }

    @Override
    public Endpoint getEndpoint(InetSocketAddress address) {
        Endpoint endpoint = null;
        for (Endpoint ep : this.endpoints) {
            if (!ep.getAddress().equals(address)) continue;
            endpoint = ep;
            break;
        }
        return endpoint;
    }

    @Override
    public CoapServer add(Resource ... resources) {
        for (Resource r : resources) {
            this.root.add(r);
        }
        return this;
    }

    @Override
    public boolean remove(Resource resource) {
        return this.root.delete(resource);
    }

    public Resource getRoot() {
        return this.root;
    }

    protected Resource createRoot() {
        return new RootResource();
    }

    private class RootResource
    extends CoapResource {
        private static final String SPACE = "                                               ";
        private final String VERSION;
        private final String msg;

        public RootResource() {
            super("");
            this.VERSION = CoapServer.class.getPackage().getImplementationVersion() != null ? "Cf " + CoapServer.class.getPackage().getImplementationVersion() : SPACE;
            String nodeId = CoapServer.this.config.getString("DTLS_CONNECTION_ID_NODE_ID");
            StringBuilder builder = new StringBuilder().append("************************************************************\n").append("CoAP RFC 7252").append(SPACE.substring(this.VERSION.length())).append(this.VERSION).append("\n").append("************************************************************\n").append("This server is using the Eclipse Californium (Cf) CoAP framework\n").append("published under EPL+EDL: http://www.eclipse.org/californium/\n").append("\n");
            if (nodeId != null && !nodeId.isEmpty()) {
                builder.append("node id = ").append(nodeId).append("\n\n");
            }
            this.msg = builder.append("(c) 2014, 2015, 2016 Institute for Pervasive Computing, ETH Zurich and others\n").append("************************************************************").toString();
        }

        @Override
        public void handleGET(CoapExchange exchange) {
            exchange.respond(CoAP.ResponseCode.CONTENT, this.msg);
        }

        @Override
        public List<Endpoint> getEndpoints() {
            return CoapServer.this.getEndpoints();
        }
    }
}

