/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.observe.NotificationListener;
import org.eclipse.californium.core.observe.ObserveNotificationOrderer;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoapObserveRelation {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoapObserveRelation.class.getCanonicalName());
    private static final ScheduledThreadPoolExecutor scheduler = ExecutorsUtil.getScheduledExecutor();
    private final Endpoint endpoint;
    private final long reregistrationBackoff;
    private final AtomicBoolean registrationPending = new AtomicBoolean(true);
    private final AtomicReference<ScheduledFuture<?>> reregistrationHandle = new AtomicReference();
    private volatile Request request;
    private volatile boolean canceled = false;
    private volatile CoapResponse current = null;
    private volatile ObserveNotificationOrderer orderer;
    private volatile NotificationListener notificationListener;
    private final Runnable reregister = new Runnable(){

        @Override
        public void run() {
            CoapObserveRelation.this.reregister();
        }
    };

    protected CoapObserveRelation(Request request, Endpoint endpoint) {
        this.request = request;
        this.endpoint = endpoint;
        this.orderer = new ObserveNotificationOrderer();
        this.reregistrationBackoff = endpoint.getConfig().getLong("NOTIFICATION_REREGISTRATION_BACKOFF");
    }

    public boolean reregister() {
        Request request = this.request;
        if (request.isCanceled()) {
            throw new IllegalStateException("observe request already canceled! token " + request.getTokenString());
        }
        CoapResponse response = this.current;
        if (response != null && !response.getOptions().hasObserve()) {
            throw new IllegalStateException("observe not supported by CoAP server!");
        }
        if (this.isCanceled()) {
            throw new IllegalStateException("observe already canceled!");
        }
        if (this.registrationPending.compareAndSet(false, true)) {
            Request refresh = Request.newGet();
            EndpointContext destinationContext = response != null ? response.advanced().getSourceContext() : request.getDestinationContext();
            refresh.setDestinationContext(destinationContext);
            refresh.setToken(request.getToken());
            refresh.setOptions(request.getOptions());
            for (MessageObserver mo : request.getMessageObservers()) {
                request.removeMessageObserver(mo);
                refresh.addMessageObserver(mo);
            }
            this.request = refresh;
            this.endpoint.sendRequest(refresh);
            this.orderer = new ObserveNotificationOrderer();
            return true;
        }
        return false;
    }

    private void sendCancelObserve() {
        CoapResponse response = this.current;
        Request request = this.request;
        EndpointContext destinationContext = response != null ? response.advanced().getSourceContext() : request.getDestinationContext();
        Request cancel = Request.newGet();
        cancel.setDestinationContext(destinationContext);
        cancel.setToken(request.getToken());
        cancel.setOptions(request.getOptions());
        cancel.setObserveCancel();
        cancel.addMessageObservers(request.getMessageObservers());
        this.endpoint.sendRequest(cancel);
    }

    private void cancel() {
        this.endpoint.cancelObservation(this.request.getToken());
        this.setCanceled(true);
    }

    public void proactiveCancel() {
        this.sendCancelObserve();
        this.cancel();
    }

    public void reactiveCancel() {
        Request request = this.request;
        if (CoAP.isTcpScheme(request.getScheme())) {
            LOGGER.info("change to cancel the observe {} proactive over TCP.", (Object)request.getTokenString());
            this.proactiveCancel();
        } else {
            request.cancel();
            this.cancel();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public CoapResponse getCurrent() {
        return this.current;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
        if (this.canceled) {
            this.setReregistrationHandle(null);
            if (this.notificationListener != null) {
                this.endpoint.removeNotificationListener(this.notificationListener);
            }
        }
    }

    public void setNotificationListener(NotificationListener listener) {
        this.notificationListener = listener;
    }

    protected boolean onResponse(CoapResponse response) {
        if (null != response && this.orderer.isNew(response.advanced())) {
            this.current = response;
            this.prepareReregistration(response);
            this.registrationPending.set(false);
            return true;
        }
        return false;
    }

    private void setReregistrationHandle(ScheduledFuture<?> reregistrationHandle) {
        ScheduledFuture<?> previousHandle = this.reregistrationHandle.getAndSet(reregistrationHandle);
        if (previousHandle != null) {
            if (previousHandle instanceof Runnable) {
                scheduler.remove((Runnable)((Object)previousHandle));
            } else {
                previousHandle.cancel(false);
            }
        }
    }

    private void prepareReregistration(CoapResponse response) {
        if (!this.isCanceled()) {
            long timeout = response.getOptions().getMaxAge() * 1000L + this.reregistrationBackoff;
            ScheduledFuture<?> f = scheduler.schedule(this.reregister, timeout, TimeUnit.MILLISECONDS);
            this.setReregistrationHandle(f);
        }
    }
}

