/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests;

import java.net.SocketException;
import java.util.logging.Level;
import org.eclipse.californium.core.CaliforniumLogger;
import org.eclipse.californium.core.CoapServer;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.interceptors.MessageTracer;
import org.eclipse.californium.plugtests.resources.Create;
import org.eclipse.californium.plugtests.resources.DefaultTest;
import org.eclipse.californium.plugtests.resources.Large;
import org.eclipse.californium.plugtests.resources.LargeCreate;
import org.eclipse.californium.plugtests.resources.LargePost;
import org.eclipse.californium.plugtests.resources.LargeUpdate;
import org.eclipse.californium.plugtests.resources.Link1;
import org.eclipse.californium.plugtests.resources.Link2;
import org.eclipse.californium.plugtests.resources.Link3;
import org.eclipse.californium.plugtests.resources.LocationQuery;
import org.eclipse.californium.plugtests.resources.LongPath;
import org.eclipse.californium.plugtests.resources.MultiFormat;
import org.eclipse.californium.plugtests.resources.Observe;
import org.eclipse.californium.plugtests.resources.ObserveLarge;
import org.eclipse.californium.plugtests.resources.ObserveNon;
import org.eclipse.californium.plugtests.resources.ObservePumping;
import org.eclipse.californium.plugtests.resources.ObserveReset;
import org.eclipse.californium.plugtests.resources.Path;
import org.eclipse.californium.plugtests.resources.Query;
import org.eclipse.californium.plugtests.resources.Separate;
import org.eclipse.californium.plugtests.resources.Shutdown;
import org.eclipse.californium.plugtests.resources.Validate;

public class PlugtestServer
extends CoapServer {
    public static final int ERR_INIT_FAILED = 1;
    private static final int port;

    public static void main(String[] args) {
        try {
            PlugtestServer server = new PlugtestServer();
            server.start();
            for (Endpoint ep : server.getEndpoints()) {
                ep.addInterceptor(new MessageTracer());
            }
            System.out.println(PlugtestServer.class.getSimpleName() + " listening on port " + port);
        }
        catch (Exception e) {
            System.err.printf("Failed to create " + PlugtestServer.class.getSimpleName() + ": %s\n", e.getMessage());
            System.err.println("Exiting");
            System.exit(1);
        }
    }

    public PlugtestServer() throws SocketException {
        NetworkConfig.getStandard().setInt("MAX_MESSAGE_SIZE", 64).setInt("PREFERRED_BLOCK_SIZE", 64).setInt("NOTIFICATION_CHECK_INTERVAL_COUNT", 4).setInt("NOTIFICATION_CHECK_INTERVAL", 30000).setString("HEALTH_STATUS_PRINT_LEVEL", "INFO");
        this.add(new DefaultTest());
        this.add(new LongPath());
        this.add(new Query());
        this.add(new Separate());
        this.add(new Large());
        this.add(new LargeUpdate());
        this.add(new LargeCreate());
        this.add(new LargePost());
        this.add(new Observe());
        this.add(new ObserveNon());
        this.add(new ObserveReset());
        this.add(new ObserveLarge());
        this.add(new ObservePumping());
        this.add(new LocationQuery());
        this.add(new MultiFormat());
        this.add(new Link1());
        this.add(new Link2());
        this.add(new Link3());
        this.add(new Path());
        this.add(new Validate());
        this.add(new Create());
        this.add(new Shutdown());
    }

    static {
        CaliforniumLogger.initialize();
        CaliforniumLogger.setLevel(Level.FINER);
        port = NetworkConfig.getStandard().getInt("COAP_PORT");
    }
}

