/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.deduplication;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.deduplication.Deduplicator;

public class SweepDeduplicator
implements Deduplicator {
    private static final Logger LOGGER = Logger.getLogger(SweepDeduplicator.class.getCanonicalName());
    private ConcurrentHashMap<Exchange.KeyMID, Exchange> incommingMessages;
    private NetworkConfig config;
    private SweepAlgorithm algorithm;
    private ScheduledExecutorService executor;
    private boolean started = false;

    public SweepDeduplicator(NetworkConfig config) {
        this.config = config;
        this.incommingMessages = new ConcurrentHashMap();
        this.algorithm = new SweepAlgorithm();
    }

    @Override
    public void start() {
        this.started = true;
        this.algorithm.schedule();
    }

    @Override
    public void stop() {
        this.started = false;
        this.algorithm.cancel();
    }

    @Override
    public void setExecutor(ScheduledExecutorService executor) {
        this.stop();
        this.executor = executor;
        if (this.started) {
            this.start();
        }
    }

    @Override
    public Exchange findPrevious(Exchange.KeyMID key, Exchange exchange) {
        Exchange previous = this.incommingMessages.putIfAbsent(key, exchange);
        return previous;
    }

    @Override
    public Exchange find(Exchange.KeyMID key) {
        return this.incommingMessages.get(key);
    }

    @Override
    public void clear() {
        this.incommingMessages.clear();
    }

    private class SweepAlgorithm
    implements Runnable {
        private ScheduledFuture<?> future;

        private SweepAlgorithm() {
        }

        @Override
        public void run() {
            try {
                LOGGER.finest("Start Mark-And-Sweep with " + SweepDeduplicator.this.incommingMessages.size() + " entries");
                this.sweep();
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Exception in Mark-and-Sweep algorithm", t);
            }
            finally {
                try {
                    this.schedule();
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, "Exception while scheduling Mark-and-Sweep algorithm", t);
                }
            }
        }

        private void sweep() {
            int lifecycle = SweepDeduplicator.this.config.getInt("EXCHANGE_LIFETIME");
            long oldestAllowed = System.currentTimeMillis() - (long)lifecycle;
            for (Map.Entry entry : SweepDeduplicator.this.incommingMessages.entrySet()) {
                Exchange exchange = (Exchange)entry.getValue();
                if (exchange.getTimestamp() >= oldestAllowed) continue;
                LOGGER.finer("Mark-And-Sweep removes " + entry.getKey());
                SweepDeduplicator.this.incommingMessages.remove(entry.getKey());
            }
        }

        private void schedule() {
            long period = SweepDeduplicator.this.config.getLong("MARK_AND_SWEEP_INTERVAL");
            this.future = SweepDeduplicator.this.executor.schedule(this, period, TimeUnit.MILLISECONDS);
        }

        private void cancel() {
            if (this.future != null) {
                this.future.cancel(true);
            }
        }
    }
}

