/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import org.eclipse.californium.core.server.resources.ResourceAttributes;

public class WebLink
implements Comparable<WebLink> {
    private String uri;
    private final ResourceAttributes attributes;

    public WebLink(String uri) {
        this.uri = uri;
        this.attributes = new ResourceAttributes();
    }

    public String getURI() {
        return this.uri;
    }

    public ResourceAttributes getAttributes() {
        return this.attributes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('<');
        builder.append(this.uri);
        builder.append('>');
        builder.append(' ').append(this.attributes.getTitle());
        if (this.attributes.containsAttribute("rt")) {
            builder.append("\n\t").append("rt").append(":\t").append(this.attributes.getResourceTypes());
        }
        if (this.attributes.containsAttribute("if")) {
            builder.append("\n\t").append("if").append(":\t").append(this.attributes.getInterfaceDescriptions());
        }
        if (this.attributes.containsAttribute("ct")) {
            builder.append("\n\t").append("ct").append(":\t").append(this.attributes.getContentTypes());
        }
        if (this.attributes.containsAttribute("sz")) {
            builder.append("\n\t").append("sz").append(":\t").append(this.attributes.getMaximumSizeEstimate());
        }
        if (this.attributes.hasObservable()) {
            builder.append("\n\t").append("obs");
        }
        return builder.toString();
    }

    @Override
    public int compareTo(WebLink other) {
        return this.uri.compareTo(other.getURI());
    }
}

