/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.security.Principal;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextMatcher;
import org.eclipse.californium.elements.auth.ExtensiblePrincipal;
import org.eclipse.californium.elements.util.Bytes;

public class PrincipalAndAnonymousEndpointContextMatcher
implements EndpointContextMatcher {
    @Override
    public String getName() {
        return "principal and anonymous correlation";
    }

    private Object getIdentity(EndpointContext context) {
        Principal identity = context.getPeerIdentity();
        if (identity instanceof ExtensiblePrincipal && ((ExtensiblePrincipal)identity).isAnonymous()) {
            identity = null;
        }
        if (identity != null) {
            return identity;
        }
        Bytes id = context.get(DtlsEndpointContext.KEY_SESSION_ID);
        if (id != null && !id.isEmpty()) {
            return id;
        }
        return null;
    }

    @Override
    public Object getEndpointIdentity(EndpointContext context) {
        Object identity = this.getIdentity(context);
        if (identity == null) {
            throw new IllegalArgumentException("Principal identity and session id are missing in provided endpoint context!");
        }
        return identity;
    }

    @Override
    public boolean isResponseRelatedToRequest(EndpointContext requestContext, EndpointContext responseContext) {
        return this.internalMatch(requestContext, responseContext);
    }

    @Override
    public boolean isToBeSent(EndpointContext messageContext, EndpointContext connectorContext) {
        if (null == connectorContext) {
            return true;
        }
        return this.internalMatch(messageContext, connectorContext);
    }

    private final boolean internalMatch(EndpointContext requestedContext, EndpointContext availableContext) {
        Object identity = this.getIdentity(requestedContext);
        if (identity != null) {
            return identity.equals(this.getIdentity(availableContext));
        }
        String cipher = requestedContext.getString(DtlsEndpointContext.KEY_CIPHER);
        return cipher == null || cipher.equals(availableContext.getString(DtlsEndpointContext.KEY_CIPHER));
    }

    @Override
    public String toRelevantState(EndpointContext context) {
        if (context == null) {
            return "n.a.";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(this.getIdentity(context));
        String cipher = context.getString(DtlsEndpointContext.KEY_CIPHER);
        if (cipher != null) {
            builder.append(",").append(cipher);
        }
        builder.append("]");
        return builder.toString();
    }
}

