/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.serialization;

import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.network.serialization.DataSerializer;
import org.eclipse.californium.core.network.serialization.UdpDataParser;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpDataSerializer
extends DataSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpDataSerializer.class);

    @Override
    protected byte[] serializeEmpytMessage(Message message) {
        int mid = message.getMID();
        if (mid == -1) {
            IllegalArgumentException ex = new IllegalArgumentException("MID required for UDP serialization!");
            LOGGER.warn("UDP, {}:", (Object)message, (Object)ex);
            throw ex;
        }
        DatagramWriter writer = new DatagramWriter(4);
        writer.write(1, 2);
        writer.write(message.getType().value, 2);
        writer.write(0, 4);
        writer.write(0, 8);
        writer.write(message.getMID(), 16);
        return writer.toByteArray();
    }

    @Override
    protected byte[] serializeMessage(Message message) {
        int mid = message.getMID();
        if (mid == -1) {
            IllegalArgumentException ex = new IllegalArgumentException("MID required for UDP serialization!");
            LOGGER.warn("UDP, {}:", (Object)message, (Object)ex);
            throw ex;
        }
        DatagramWriter writer = new DatagramWriter(message.getPayloadSize() + 32);
        byte[] token = message.getTokenBytes();
        writer.write(1, 2);
        writer.write(message.getType().value, 2);
        writer.write(token.length, 4);
        writer.write(message.getRawCode(), 8);
        writer.write(message.getMID(), 16);
        writer.writeBytes(token);
        UdpDataSerializer.serializeOptionsAndPayload(writer, message.getOptions(), message.getPayload());
        return writer.toByteArray();
    }

    @Override
    protected void assertValidOptions(Message message) {
        super.assertValidOptions(message);
        UdpDataParser.assertValidUdpOptions(message);
    }
}

