/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap.option;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.option.OptionDefinition;
import org.eclipse.californium.core.coap.option.OptionRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapBasedOptionRegistry
implements OptionRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapBasedOptionRegistry.class);
    protected final Map<Integer, OptionDefinition> numberMap = new ConcurrentHashMap<Integer, OptionDefinition>();
    private final Map<String, OptionDefinition> nameMap = new ConcurrentHashMap<String, OptionDefinition>();

    public MapBasedOptionRegistry(OptionDefinition ... definitions) {
        try {
            for (OptionDefinition definition : definitions) {
                this.put(definition);
            }
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error("{}", (Object)ex.getMessage());
            throw ex;
        }
    }

    public MapBasedOptionRegistry(OptionRegistry registry, OptionDefinition ... definitions) {
        try {
            this.add(registry);
            for (OptionDefinition definition : definitions) {
                this.put(definition);
            }
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error("{}", (Object)ex.getMessage());
            throw ex;
        }
    }

    public MapBasedOptionRegistry(OptionRegistry registry, OptionRegistry ... registries) {
        try {
            this.add(registry);
            for (OptionRegistry reg : registries) {
                this.add(reg);
            }
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error("{}", (Object)ex.getMessage());
            throw ex;
        }
    }

    public MapBasedOptionRegistry(List<OptionRegistry> registries, List<OptionDefinition> definitions) {
        try {
            for (OptionRegistry reg : registries) {
                this.add(reg);
            }
            for (OptionDefinition definition : definitions) {
                this.put(definition);
            }
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error("{}", (Object)ex.getMessage());
            throw ex;
        }
    }

    protected void add(OptionRegistry registry) {
        for (OptionRegistry.Entry entry : registry) {
            this.putInternal(entry.getKey(), entry.getOptioneDefinition());
        }
    }

    protected void put(OptionDefinition definition) {
        this.putInternal(MapBasedOptionRegistry.getExtendedNumber(0, definition.getNumber()), definition);
    }

    protected void put(int code, OptionDefinition definition) {
        this.putInternal(MapBasedOptionRegistry.getExtendedNumber(code, definition.getNumber()), definition);
    }

    protected synchronized void putInternal(int key, OptionDefinition definition) {
        OptionDefinition current = this.numberMap.get(key);
        if (current != null) {
            throw new IllegalArgumentException("Number " + definition.getNumber() + " already in use for " + current.getName());
        }
        current = this.nameMap.get(definition.getName());
        if (current != null) {
            throw new IllegalArgumentException("Name " + definition.getName() + " already in use for " + current.getNumber());
        }
        this.numberMap.put(key, definition);
        this.nameMap.put(definition.getName(), definition);
    }

    @Override
    public OptionDefinition getDefinitionByNumber(int code, int optionNumber) {
        int key = MapBasedOptionRegistry.getExtendedNumber(code, optionNumber);
        return this.getInternal(key);
    }

    @Override
    public OptionDefinition getDefinitionByNumber(int optionNumber) {
        int key = MapBasedOptionRegistry.getExtendedNumber(0, optionNumber);
        return this.getInternal(key);
    }

    protected OptionDefinition getInternal(int key) {
        return this.numberMap.get(key);
    }

    @Override
    public OptionDefinition getDefinitionByName(String name) {
        return this.nameMap.get(name);
    }

    @Override
    public boolean contains(OptionDefinition definition) {
        if (this.numberMap.containsValue(definition)) {
            return true;
        }
        OptionDefinition contained = this.numberMap.get(definition.getNumber());
        if (contained != null) {
            LOGGER.debug("{}/{} => {}/{}: {}.", definition.getNumber(), definition.getName(), contained.getNumber(), contained.getName(), contained == definition);
            return definition.equals(contained);
        }
        return false;
    }

    @Override
    public Iterator<OptionRegistry.Entry> iterator() {
        return new Iterator<OptionRegistry.Entry>(){
            private final Iterator<Map.Entry<Integer, OptionDefinition>> cursor;
            {
                this.cursor = MapBasedOptionRegistry.this.numberMap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.cursor.hasNext();
            }

            @Override
            public OptionRegistry.Entry next() {
                return new DefinitionEntry(this.cursor.next());
            }

            @Override
            public void remove() {
                this.cursor.remove();
            }
        };
    }

    protected static int getExtendedNumber(int code, int optionNumber) {
        if (optionNumber > 65535 || optionNumber < 0) {
            throw new IllegalArgumentException(optionNumber + " invalid option number!");
        }
        if (CoAP.getCodeClass(code) == CoAP.CodeClass.SIGNAL.value) {
            return (optionNumber & 0xFFFF) + (code << 16);
        }
        return optionNumber;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<OptionRegistry> registries = new ArrayList<OptionRegistry>();
        private final List<OptionDefinition> definitions = new ArrayList<OptionDefinition>();

        public Builder add(OptionRegistry registry) {
            this.registries.add(registry);
            return this;
        }

        public Builder add(OptionDefinition ... definitions) {
            for (OptionDefinition def : definitions) {
                this.definitions.add(def);
            }
            return this;
        }

        public OptionRegistry build() {
            return new MapBasedOptionRegistry(this.registries, this.definitions);
        }
    }

    private static class DefinitionEntry
    implements OptionRegistry.Entry {
        private final Map.Entry<Integer, OptionDefinition> entry;

        private DefinitionEntry(Map.Entry<Integer, OptionDefinition> entry) {
            this.entry = entry;
        }

        @Override
        public int getKey() {
            return this.entry.getKey();
        }

        @Override
        public OptionDefinition getOptioneDefinition() {
            return this.entry.getValue();
        }
    }
}

