/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.EncryptedStreamUtil;
import org.eclipse.californium.elements.util.PersistentComponentUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedPersistentComponentUtil
extends PersistentComponentUtil {
    @Deprecated
    public static final String DEFAULT_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    @Deprecated
    public static final int DEFAULT_KEY_SIZE_BITS = 128;
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptedPersistentComponentUtil.class);
    private final EncryptedStreamUtil encryptionUtility = new EncryptedStreamUtil();

    public EncryptedPersistentComponentUtil() {
        this(DEFAULT_CIPHER_ALGORITHM, 128);
    }

    public EncryptedPersistentComponentUtil(String cipherAlgorithm, int keySizeBits) {
        this.setCipher(cipherAlgorithm, keySizeBits);
    }

    public void setCipher(String cipherAlgorithm, int keySizeBits) {
        this.encryptionUtility.setCipher(cipherAlgorithm, keySizeBits);
    }

    public InputStream prepare(InputStream in, SecretKey password) {
        return this.encryptionUtility.prepare(in, password);
    }

    public int loadComponents(InputStream in, SecretKey password) {
        return super.loadComponents(this.prepare(in, password));
    }

    public OutputStream prepare(OutputStream out, SecretKey password) throws IOException {
        return this.encryptionUtility.prepare(out, password);
    }

    public void saveComponents(OutputStream out, SecretKey password, long staleThresholdInSeconds) throws IOException {
        OutputStream serversOut = this.prepare(out, password);
        this.saveComponents(serversOut, staleThresholdInSeconds);
        if (serversOut != out) {
            serversOut.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAndRegisterShutdown(String file, char[] password64, final long staleThresholdInSeconds, final Runnable hook) {
        SecretKeySpec tempKey = null;
        if (password64 != null) {
            byte[] secret = StringUtil.base64ToByteArray(password64);
            tempKey = new SecretKeySpec(secret, "PW");
            Bytes.clear(secret);
        }
        final SecretKeySpec key = tempKey;
        final File store = new File(file);
        if (store.exists()) {
            try {
                try (FileInputStream in = new FileInputStream(store);){
                    this.loadComponents(in, key);
                }
                LOGGER.info("Server state read.");
                store.delete();
            }
            catch (IOException ex) {
                LOGGER.warn("Reading server state failed!", ex);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.warn("Reading server state failed!", ex);
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread("SHUTDOWN"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LOGGER.info("Shutdown ...");
                if (hook != null) {
                    hook.run();
                }
                store.delete();
                try (FileOutputStream out = new FileOutputStream(store);){
                    EncryptedPersistentComponentUtil.this.saveComponents(out, key, staleThresholdInSeconds);
                }
                catch (IOException ex) {
                    LOGGER.warn("Saving server state failed!", ex);
                    store.delete();
                }
                LOGGER.info("Shutdown.");
            }
        });
    }
}

