/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.AbstractLayer;
import org.eclipse.californium.core.network.stack.ReliabilityLayerParameters;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.EndpointContextUtil;
import org.eclipse.californium.elements.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReliabilityLayer
extends AbstractLayer {
    @Deprecated
    protected static final Logger LOGGER = LoggerFactory.getLogger(ReliabilityLayer.class);
    protected final ReliabilityLayerParameters defaultReliabilityLayerParameters;
    private final Random rand = new Random();
    private final AtomicInteger counter = new AtomicInteger();
    private final int maxLeisureMillis;

    public ReliabilityLayer(Configuration config) {
        this.defaultReliabilityLayerParameters = ReliabilityLayerParameters.builder().applyConfig(config).build();
        this.maxLeisureMillis = config.getTimeAsInt(CoapConfig.LEISURE, TimeUnit.MILLISECONDS);
        LOGGER.trace("Max. leisure for multicast server={}ms", (Object)this.maxLeisureMillis);
        LOGGER.trace("ReliabilityLayer uses ACK_TIMEOUT={}ms, MAX_ACK_TIMEOUT={}ms, ACK_RANDOM_FACTOR={}, and ACK_TIMEOUT_SCALE={} as default", this.defaultReliabilityLayerParameters.getAckTimeout(), this.defaultReliabilityLayerParameters.getMaxAckTimeout(), Float.valueOf(this.defaultReliabilityLayerParameters.getAckRandomFactor()), Float.valueOf(this.defaultReliabilityLayerParameters.getAckTimeoutScale()));
    }

    @Override
    public void sendRequest(Exchange exchange, Request request) {
        LOGGER.debug("{} send request", (Object)exchange);
        this.prepareRequest(exchange, request);
        this.lower().sendRequest(exchange, request);
    }

    protected void prepareRequest(Exchange exchange, Request request) {
        if (request.getType() == null) {
            request.setType(CoAP.Type.CON);
        }
        if (request.getType() == CoAP.Type.CON) {
            LOGGER.debug("{} prepare retransmission for {}", (Object)exchange, (Object)request);
            this.prepareRetransmission(exchange, new RetransmissionTask(exchange, request){

                @Override
                public void retransmit() {
                    Request request = (Request)this.message;
                    if (request.getEffectiveDestinationContext() != request.getDestinationContext()) {
                        this.exchange.resetEndpointContext();
                    }
                    LOGGER.debug("{} send request, failed transmissions: {}", (Object)this.exchange, (Object)this.exchange.getFailedTransmissionCount());
                    ReliabilityLayer.this.updateRetransmissionTimeout(this.exchange, this.getReliabilityLayerParameters());
                    ReliabilityLayer.this.lower().sendRequest(this.exchange, request);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(Exchange exchange, Response response) {
        LOGGER.debug("{} send response {}", (Object)exchange, (Object)response);
        this.prepareResponse(exchange, response);
        if (exchange.getCurrentRequest().isMulticast() && response.getType() == CoAP.Type.NON) {
            int leisure;
            Random random = this.rand;
            synchronized (random) {
                leisure = this.rand.nextInt(this.maxLeisureMillis);
            }
            DelayedResponseTask task = new DelayedResponseTask(exchange, response);
            ScheduledFuture<?> f = this.executor.schedule(task, (long)leisure, TimeUnit.MILLISECONDS);
            exchange.setRetransmissionHandle(f);
        } else {
            this.lower().sendResponse(exchange, response);
        }
    }

    protected void prepareResponse(Exchange exchange, Response response) {
        Request currentRequest = exchange.getCurrentRequest();
        CoAP.Type respType = response.getType();
        if (respType == null) {
            CoAP.Type reqType = currentRequest.getType();
            if (currentRequest.acknowledge()) {
                response.setType(CoAP.Type.ACK);
            } else {
                response.setType(reqType);
            }
            respType = response.getType();
            LOGGER.trace("{} set response type to {} (request was {})", new Object[]{exchange, respType, reqType});
        } else if (respType == CoAP.Type.RST) {
            currentRequest.setRejected(true);
        } else if (respType == CoAP.Type.ACK) {
            currentRequest.acknowledge();
        } else {
            currentRequest.setAcknowledged(true);
        }
        if (respType == CoAP.Type.ACK || respType == CoAP.Type.RST) {
            response.setMID(currentRequest.getMID());
        }
        if (respType == CoAP.Type.CON) {
            LOGGER.debug("{} prepare retransmission for {}", (Object)exchange, (Object)response);
            this.prepareRetransmission(exchange, new RetransmissionTask(exchange, response){

                @Override
                public void retransmit() {
                    Response response = (Response)this.message;
                    LOGGER.debug("{} send response {}, failed transmissions: {}", this.exchange, response, this.exchange.getFailedTransmissionCount());
                    ReliabilityLayer.this.updateRetransmissionTimeout(this.exchange, this.getReliabilityLayerParameters());
                    ReliabilityLayer.this.lower().sendResponse(this.exchange, response);
                }
            });
        }
    }

    private void prepareRetransmission(Exchange exchange, RetransmissionTask task) {
        if (this.executor.isShutdown()) {
            LOGGER.info("Endpoint is being destroyed: skipping retransmission");
            return;
        }
        exchange.setRetransmissionHandle(null);
        this.updateRetransmissionTimeout(exchange, task.getReliabilityLayerParameters());
        task.message.addMessageObserver(task);
    }

    @Override
    public void receiveRequest(Exchange exchange, Request request) {
        if (request.isDuplicate()) {
            long send = exchange.getSendNanoTimestamp();
            if (send == 0L || send - request.getNanoTimestamp() > 0L) {
                int count = this.counter.incrementAndGet();
                LOGGER.debug("{}: {} duplicate request {}, server sent response delayed, ignore request", count, exchange, request);
                return;
            }
            exchange.retransmitResponse();
            Request previousRequest = exchange.getCurrentRequest();
            Response previousResponse = exchange.getCurrentResponse();
            if (previousResponse != null) {
                CoAP.Type type = previousResponse.getType();
                if (type == CoAP.Type.NON || type == CoAP.Type.CON) {
                    if (request.acknowledge()) {
                        EmptyMessage ack = EmptyMessage.newACK(request);
                        this.sendEmptyMessage(exchange, ack);
                    }
                    if (type == CoAP.Type.CON) {
                        if (previousResponse.isAcknowledged()) {
                            LOGGER.debug("{} request duplicate: ignore, response already acknowledged!", (Object)exchange);
                        } else {
                            int failedCount = exchange.incrementFailedTransmissionCount();
                            LOGGER.debug("{} request duplicate: retransmit response, failed: {}, response: {}", exchange, failedCount, previousResponse);
                            previousResponse.retransmitting();
                            this.sendResponse(exchange, previousResponse);
                        }
                        return;
                    }
                    if (previousResponse.isNotification()) {
                        exchange.incrementFailedTransmissionCount();
                    }
                }
                LOGGER.debug("{} respond with the current response to the duplicate request", (Object)exchange);
                this.lower().sendResponse(exchange, previousResponse);
            } else if (previousRequest.isAcknowledged()) {
                LOGGER.debug("{} duplicate request was acknowledged but no response computed yet. Retransmit ACK", (Object)exchange);
                EmptyMessage ack = EmptyMessage.newACK(request);
                this.sendEmptyMessage(exchange, ack);
            } else if (previousRequest.isRejected()) {
                LOGGER.debug("{} duplicate request was rejected. Reject again", (Object)exchange);
                EmptyMessage rst = EmptyMessage.newRST(request);
                this.sendEmptyMessage(exchange, rst);
            } else {
                LOGGER.debug("{} server has not yet decided what to do with the request. We ignore the duplicate.", (Object)exchange);
            }
        } else {
            exchange.setCurrentRequest(request);
            this.upper().receiveRequest(exchange, request);
        }
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        if (this.processResponse(exchange, response)) {
            this.upper().receiveResponse(exchange, response);
        }
    }

    protected boolean processResponse(Exchange exchange, Response response) {
        exchange.setRetransmissionHandle(null);
        if (response.getType() == CoAP.Type.CON) {
            EmptyMessage empty;
            boolean ack = true;
            if (response.isDuplicate()) {
                long send = exchange.getSendNanoTimestamp();
                if (send == 0L || send - response.getNanoTimestamp() > 0L) {
                    int count = this.counter.incrementAndGet();
                    LOGGER.debug("{}: {} duplicate response {}, server sent ACK delayed, ignore response", count, exchange, response);
                    return false;
                }
                if (response.isRejected()) {
                    ack = false;
                    LOGGER.debug("{} reject duplicate CON response, request canceled.", (Object)exchange);
                } else {
                    LOGGER.debug("{} acknowledging duplicate CON response", (Object)exchange);
                }
            } else if (exchange.getRequest().isCanceled()) {
                ack = false;
                LOGGER.debug("{} reject CON response, request canceled.", (Object)exchange);
            } else {
                LOGGER.debug("{} acknowledging CON response", (Object)exchange);
            }
            if (ack) {
                empty = EmptyMessage.newACK(response);
                response.setAcknowledged(true);
            } else {
                empty = EmptyMessage.newRST(response);
                response.setRejected(true);
            }
            this.sendEmptyMessage(exchange, empty);
        }
        if (response.isDuplicate()) {
            if (response.getType() != CoAP.Type.CON) {
                LOGGER.debug("{} ignoring duplicate response", (Object)exchange);
            }
            return false;
        }
        exchange.getCurrentRequest().setAcknowledged(true);
        exchange.setCurrentResponse(response);
        return true;
    }

    @Override
    public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        if (this.processEmptyMessage(exchange, message)) {
            this.upper().receiveEmptyMessage(exchange, message);
        }
    }

    protected boolean processEmptyMessage(Exchange exchange, EmptyMessage message) {
        Message currentMessage;
        String type;
        exchange.setRetransmissionHandle(null);
        if (exchange.isOfLocalOrigin()) {
            type = "request";
            currentMessage = exchange.getCurrentRequest();
        } else {
            type = "response";
            currentMessage = exchange.getCurrentResponse();
        }
        int observer = currentMessage.getMessageObservers().size();
        if (message.getType() == CoAP.Type.ACK) {
            LOGGER.debug("{} acknowledge {} for {} {} ({} msg observer)", exchange, message, type, currentMessage, observer);
            currentMessage.acknowledge();
        } else if (message.getType() == CoAP.Type.RST) {
            LOGGER.debug("{} reject {} for {} {} ({} msg observer)", exchange, message, type, currentMessage, observer);
            currentMessage.setRejected(true);
        } else {
            LOGGER.warn("{} received empty message that is neither ACK nor RST: {}", (Object)exchange, (Object)message);
            return false;
        }
        return true;
    }

    protected void updateRetransmissionTimeout(Exchange exchange, ReliabilityLayerParameters reliabilityLayerParameters) {
        int timeout;
        if (exchange.getFailedTransmissionCount() == 0) {
            exchange.setTimeoutScale(reliabilityLayerParameters.getAckTimeoutScale());
            timeout = this.getRandomTimeout(reliabilityLayerParameters.getAckTimeout(), reliabilityLayerParameters.getAckRandomFactor());
        } else {
            timeout = (int)(exchange.getTimeoutScale() * (float)exchange.getCurrentTimeout());
        }
        timeout = Math.min(reliabilityLayerParameters.getMaxAckTimeout(), timeout);
        exchange.setCurrentTimeout(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRandomTimeout(int ackTimeout, float randomFactor) {
        if ((double)randomFactor <= 1.0) {
            return ackTimeout;
        }
        int delta = (int)((float)ackTimeout * randomFactor) - ackTimeout + 1;
        Random random = this.rand;
        synchronized (random) {
            return ackTimeout + this.rand.nextInt(delta);
        }
    }

    protected abstract class RetransmissionTask
    extends MessageObserverAdapter
    implements Runnable {
        protected final Exchange exchange;
        protected final Message message;

        private RetransmissionTask(Exchange exchange, Message message) {
            super(true);
            this.exchange = exchange;
            this.message = message;
        }

        public ReliabilityLayerParameters getReliabilityLayerParameters() {
            ReliabilityLayerParameters parameters = this.message.getReliabilityLayerParameters();
            if (parameters == null) {
                parameters = ReliabilityLayer.this.defaultReliabilityLayerParameters;
            }
            return parameters;
        }

        private boolean isInTransit() {
            if (this.message.isAcknowledged() || this.exchange.isComplete()) {
                return false;
            }
            Message current = this.exchange.isOfLocalOrigin() ? this.exchange.getCurrentRequest() : this.exchange.getCurrentResponse();
            return this.message == current;
        }

        @Override
        public void onSent(boolean retransmission) {
            if (this.isInTransit()) {
                this.exchange.execute(new Runnable(){

                    @Override
                    public void run() {
                        RetransmissionTask.this.startTimer();
                    }
                });
            }
        }

        public void startTimer() {
            if (this.isInTransit()) {
                int timeout = this.exchange.getCurrentTimeout();
                ScheduledFuture<?> f = ReliabilityLayer.this.executor.schedule(this, (long)timeout, TimeUnit.MILLISECONDS);
                this.exchange.setRetransmissionHandle(f);
            }
        }

        @Override
        public void run() {
            this.exchange.execute(new Runnable(){

                @Override
                public void run() {
                    RetransmissionTask.this.retry();
                }
            });
        }

        private void retry() {
            try {
                this.exchange.setRetransmissionHandle(null);
                if (this.exchange.isComplete()) {
                    LOGGER.debug("Timeout: for {}, {}", (Object)this.exchange, (Object)this.message);
                    return;
                }
                Message current = this.exchange.isOfLocalOrigin() ? this.exchange.getCurrentRequest() : this.exchange.getCurrentResponse();
                if (this.message != current) {
                    LOGGER.debug("Timeout: for {}, message has changed!", (Object)this.exchange);
                    return;
                }
                if (this.message.isAcknowledged()) {
                    LOGGER.trace("Timeout: for {} message already acknowledged, cancel retransmission of {}", (Object)this.exchange, (Object)this.message);
                    return;
                }
                if (this.message.isRejected()) {
                    LOGGER.trace("Timeout: for {} message already rejected, cancel retransmission of {}", (Object)this.exchange, (Object)this.message);
                    return;
                }
                if (this.message.isCanceled()) {
                    LOGGER.trace("Timeout: for {}, {} is canceled, do not retransmit", (Object)this.exchange, (Object)this.message);
                    return;
                }
                int failedCount = this.exchange.incrementFailedTransmissionCount();
                if (failedCount == 1) {
                    EndpointContext context = EndpointContextUtil.getFollowUpEndpointContext(this.message.getDestinationContext(), this.exchange.getEndpointContext());
                    this.message.setEffectiveDestinationContext(context);
                }
                LOGGER.debug("Timeout: for {} retry {} of {}", this.exchange, failedCount, this.message);
                int max = this.getReliabilityLayerParameters().getMaxRetransmit();
                if (failedCount <= max) {
                    LOGGER.debug("Timeout: for {} retransmit message, failed-count: {}, message: {}", this.exchange, failedCount, this.message);
                    this.message.retransmitting();
                    if (this.message.isCanceled()) {
                        LOGGER.trace("Timeout: for {}, {} got canceled, do not retransmit", (Object)this.exchange, (Object)this.message);
                        return;
                    }
                    if (this.exchange.isComplete()) {
                        LOGGER.debug("Timeout: for {}, {} got completed, do not retransmit", (Object)this.exchange, (Object)this.message);
                        return;
                    }
                    this.retransmit();
                } else {
                    LOGGER.debug("Timeout: for {} retransmission limit {} reached, exchange failed with timeout {} ms, message: {}", this.exchange, max, this.exchange.getCurrentTimeout(), this.message);
                    this.exchange.setTimedOut(this.message);
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception for {} in MessageObserver: {}", this.exchange, e.getMessage(), e);
            }
        }

        public abstract void retransmit();
    }

    private class DelayedResponseTask
    implements Runnable {
        protected final Exchange exchange;
        protected final Response response;

        private DelayedResponseTask(Exchange exchange, Response response) {
            this.exchange = exchange;
            this.response = response;
        }

        @Override
        public void run() {
            this.exchange.execute(new Runnable(){

                @Override
                public void run() {
                    ReliabilityLayer.this.lower().sendResponse(DelayedResponseTask.this.exchange, DelayedResponseTask.this.response);
                }
            });
        }
    }
}

