/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import org.eclipse.californium.core.coap.option.IntegerOptionDefinition;
import org.eclipse.californium.core.coap.option.OptionDefinition;
import org.eclipse.californium.core.coap.option.StandardOptionRegistry;

public final class OptionNumberRegistry {
    public static final int UNKNOWN = -1;
    public static final int RESERVED_0 = 0;
    public static final int IF_MATCH = 1;
    public static final int URI_HOST = 3;
    public static final int ETAG = 4;
    public static final int IF_NONE_MATCH = 5;
    public static final int URI_PORT = 7;
    public static final int LOCATION_PATH = 8;
    public static final int URI_PATH = 11;
    public static final int CONTENT_FORMAT = 12;
    public static final int MAX_AGE = 14;
    public static final int URI_QUERY = 15;
    public static final int ACCEPT = 17;
    public static final int LOCATION_QUERY = 20;
    public static final int PROXY_URI = 35;
    public static final int PROXY_SCHEME = 39;
    public static final int SIZE1 = 60;
    public static final int RESERVED_1 = 128;
    public static final int RESERVED_2 = 132;
    public static final int RESERVED_3 = 136;
    public static final int RESERVED_4 = 140;
    public static final int OBSERVE = 6;
    public static final int BLOCK2 = 23;
    public static final int BLOCK1 = 27;
    public static final int SIZE2 = 28;
    public static final int OSCORE = 9;
    public static final int NO_RESPONSE = 258;
    @Deprecated
    private static volatile CustomOptionNumberRegistry customRegistry;

    @Deprecated
    public static OptionFormat getFormatByNr(int optionNumber) {
        OptionDefinition definition = StandardOptionRegistry.getDefaultOptionRegistry().getDefinitionByNumber(optionNumber);
        if (definition != null) {
            return definition.getFormat();
        }
        return OptionFormat.UNKNOWN;
    }

    public static boolean isCritical(int optionNumber) {
        return (optionNumber & 1) != 0;
    }

    public static boolean isElective(int optionNumber) {
        return (optionNumber & 1) == 0;
    }

    public static boolean isUnsafe(int optionNumber) {
        return (optionNumber & 2) > 0;
    }

    public static boolean isSafe(int optionNumber) {
        return !OptionNumberRegistry.isUnsafe(optionNumber);
    }

    public static boolean isNoCacheKey(int optionNumber) {
        return (optionNumber & 0x1E) == 28;
    }

    public static boolean isCacheKey(int optionNumber) {
        return !OptionNumberRegistry.isNoCacheKey(optionNumber);
    }

    @Deprecated
    public static boolean isCustomOption(int optionNumber) {
        return StandardOptionRegistry.STANDARD_OPTIONS.getDefinitionByNumber(optionNumber) == null;
    }

    @Deprecated
    public static boolean isSingleValue(int optionNumber) {
        OptionDefinition definition = StandardOptionRegistry.getDefaultOptionRegistry().getDefinitionByNumber(optionNumber);
        if (definition != null) {
            return definition.isSingleValue();
        }
        return true;
    }

    @Deprecated
    public static void assertValue(int optionNumber, long value) {
        OptionDefinition definition = StandardOptionRegistry.getDefaultOptionRegistry().getDefinitionByNumber(optionNumber);
        if (definition != null) {
            try {
                definition.assertValue(IntegerOptionDefinition.setLongValue(value));
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException(ex.getMessage() + " Value " + value);
            }
        }
    }

    public static void assertValueLength(int optionNumber, int valueLength) {
        int min = 0;
        int max = 65804;
        int[] lengths = null;
        OptionDefinition definition = StandardOptionRegistry.getDefaultOptionRegistry().getDefinitionByNumber(optionNumber);
        if (definition != null) {
            lengths = definition.getValueLengths();
        }
        if (lengths != null) {
            if (lengths.length == 2) {
                min = lengths[0];
                max = lengths[1];
            } else if (lengths.length == 1) {
                min = lengths[0];
                max = lengths[0];
            }
        }
        if (valueLength < min || valueLength > max) {
            String name = OptionNumberRegistry.toString(optionNumber);
            if (min == max) {
                if (min == 0) {
                    throw new IllegalArgumentException("Option " + name + " value of " + valueLength + " bytes must be empty.");
                }
                throw new IllegalArgumentException("Option " + name + " value of " + valueLength + " bytes must be " + min + " bytes.");
            }
            throw new IllegalArgumentException("Option " + name + " value of " + valueLength + " bytes must be in range of [" + min + "-" + max + "] bytes.");
        }
    }

    public static boolean isUriOption(int optionNumber) {
        boolean result = optionNumber == 3 || optionNumber == 11 || optionNumber == 7 || optionNumber == 15;
        return result;
    }

    @Deprecated
    public static String toString(int optionNumber) {
        OptionDefinition definition = StandardOptionRegistry.getDefaultOptionRegistry().getDefinitionByNumber(optionNumber);
        if (definition != null) {
            return definition.getName();
        }
        return String.format("Unknown (%d)", optionNumber);
    }

    @Deprecated
    public static int toNumber(String name) {
        OptionDefinition definition = StandardOptionRegistry.getDefaultOptionRegistry().getDefinitionByName(name);
        if (definition != null) {
            return definition.getNumber();
        }
        return -1;
    }

    @Deprecated
    public static int[] getCriticalCustomOptions() {
        CustomOptionNumberRegistry custom = customRegistry;
        if (custom != null) {
            return custom.getCriticalCustomOptions();
        }
        return null;
    }

    @Deprecated
    public static CustomOptionNumberRegistry setCustomOptionNumberRegistry(CustomOptionNumberRegistry custom) {
        CustomOptionNumberRegistry previous = customRegistry;
        if (previous != custom) {
            customRegistry = custom;
            StandardOptionRegistry.setDefaultOptionRegistry(null);
        }
        return previous;
    }

    @Deprecated
    public static CustomOptionNumberRegistry getCustomOptionNumberRegistry() {
        return customRegistry;
    }

    private OptionNumberRegistry() {
    }

    @Deprecated
    public static interface CustomOptionNumberRegistry {
        public OptionFormat getFormatByNr(int var1);

        public boolean isSingleValue(int var1);

        public void assertValue(int var1, long var2);

        public int[] getValueLengths(int var1);

        public String toString(int var1);

        public int toNumber(String var1);

        public int[] getCriticalCustomOptions();
    }

    public static enum OptionFormat {
        INTEGER,
        STRING,
        OPAQUE,
        UNKNOWN,
        EMPTY;

    }

    public static class Defaults {
        public static final long MAX_AGE = 60L;
    }

    public static class Names {
        public static final String Reserved = "Reserved";
        public static final String If_Match = "If-Match";
        public static final String Uri_Host = "Uri-Host";
        public static final String ETag = "ETag";
        public static final String If_None_Match = "If-None-Match";
        public static final String Uri_Port = "Uri-Port";
        public static final String Location_Path = "Location-Path";
        public static final String Uri_Path = "Uri-Path";
        public static final String Content_Format = "Content-Format";
        public static final String Max_Age = "Max-Age";
        public static final String Uri_Query = "Uri-Query";
        public static final String Accept = "Accept";
        public static final String Location_Query = "Location-Query";
        public static final String Proxy_Uri = "Proxy-Uri";
        public static final String Proxy_Scheme = "Proxy-Scheme";
        public static final String Size1 = "Size1";
        public static final String Observe = "Observe";
        public static final String Block2 = "Block2";
        public static final String Block1 = "Block1";
        public static final String Size2 = "Size2";
        public static final String Object_Security = "Object-Security";
        public static final String No_Response = "No-Response";
    }
}

