/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.RawDataChannel;

public class UDPConnector
implements Connector {
    public static final Logger LOGGER = Logger.getLogger(UDPConnector.class.toString());
    public static final int UNDEFINED = 0;
    private boolean running;
    private DatagramSocket socket;
    private final InetSocketAddress localAddr;
    private List<Thread> receiverThreads;
    private List<Thread> senderThreads;
    private final BlockingQueue<RawData> outgoing;
    private RawDataChannel receiver;
    private int receiveBuffer = 0;
    private int sendBuffer = 0;
    private int senderCount = 1;
    private int receiverCount = 1;
    private int receiverPacketSize = 2048;
    private boolean logPackets = false;

    public UDPConnector() {
        this(new InetSocketAddress(0));
    }

    public UDPConnector(InetSocketAddress address) {
        this.localAddr = address;
        this.running = false;
        this.outgoing = new LinkedBlockingQueue<RawData>();
    }

    @Override
    public synchronized void start() throws IOException {
        int i;
        if (this.running) {
            return;
        }
        this.socket = new DatagramSocket(this.localAddr.getPort(), this.localAddr.getAddress());
        this.running = true;
        if (this.receiveBuffer != 0) {
            this.socket.setReceiveBufferSize(this.receiveBuffer);
        }
        this.receiveBuffer = this.socket.getReceiveBufferSize();
        if (this.sendBuffer != 0) {
            this.socket.setSendBufferSize(this.sendBuffer);
        }
        this.sendBuffer = this.socket.getSendBufferSize();
        LOGGER.config("UDP-connector starts " + this.senderCount + " sender threads and " + this.receiverCount + " receiver threads");
        this.receiverThreads = new LinkedList<Thread>();
        for (i = 0; i < this.receiverCount; ++i) {
            this.receiverThreads.add(new Receiver("UDP-Receiver " + this.localAddr + "[" + i + "]"));
        }
        this.senderThreads = new LinkedList<Thread>();
        for (i = 0; i < this.senderCount; ++i) {
            this.senderThreads.add(new Sender("UDP-Sender " + this.localAddr + "[" + i + "]"));
        }
        for (Thread t : this.receiverThreads) {
            t.start();
        }
        for (Thread t : this.senderThreads) {
            t.start();
        }
        LOGGER.config("UDP connector listening on " + this.socket.getLocalSocketAddress() + ", recv buf = " + this.receiveBuffer + ", send buf = " + this.sendBuffer + ", recv packet size = " + this.receiverPacketSize + ", log packets = " + this.logPackets);
    }

    @Override
    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (this.senderThreads != null) {
            for (Thread t : this.senderThreads) {
                t.interrupt();
            }
        }
        if (this.receiverThreads != null) {
            for (Thread t : this.receiverThreads) {
                t.interrupt();
            }
        }
        this.outgoing.clear();
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = null;
    }

    @Override
    public synchronized void destroy() {
        this.stop();
    }

    @Override
    public void send(RawData msg) {
        if (msg == null) {
            throw new NullPointerException();
        }
        this.outgoing.add(msg);
    }

    @Override
    public void setRawDataReceiver(RawDataChannel receiver) {
        this.receiver = receiver;
    }

    @Override
    public InetSocketAddress getAddress() {
        if (this.socket == null) {
            return this.localAddr;
        }
        return new InetSocketAddress(this.socket.getLocalAddress(), this.socket.getLocalPort());
    }

    public void setReceiveBufferSize(int size) {
        this.receiveBuffer = size;
    }

    public int getReceiveBufferSize() {
        return this.receiveBuffer;
    }

    public void setSendBufferSize(int size) {
        this.sendBuffer = size;
    }

    public int getSendBufferSize() {
        return this.sendBuffer;
    }

    public void setReceiverThreadCount(int count) {
        this.receiverCount = count;
    }

    public int getReceiverThreadCount() {
        return this.receiverCount;
    }

    public void setSenderThreadCount(int count) {
        this.senderCount = count;
    }

    public int getSenderThreadCount() {
        return this.senderCount;
    }

    public void setReceiverPacketSize(int size) {
        this.receiverPacketSize = size;
    }

    public int getReceiverPacketSize() {
        return this.receiverPacketSize;
    }

    public void setLogPackets(boolean b) {
        this.logPackets = b;
    }

    public boolean isLogPackets() {
        return this.logPackets;
    }

    private class Sender
    extends Worker {
        private DatagramPacket datagram;

        private Sender(String name) {
            super(name);
            this.datagram = new DatagramPacket(new byte[0], 0);
        }

        @Override
        protected void work() throws InterruptedException, IOException {
            RawData raw = (RawData)UDPConnector.this.outgoing.take();
            this.datagram.setData(raw.getBytes());
            this.datagram.setAddress(raw.getAddress());
            this.datagram.setPort(raw.getPort());
            if (UDPConnector.this.logPackets) {
                LOGGER.fine("Connector (" + UDPConnector.this.socket.getLocalSocketAddress() + ") sends " + this.datagram.getLength() + " bytes to " + this.datagram.getSocketAddress());
            }
            UDPConnector.this.socket.send(this.datagram);
        }
    }

    private class Receiver
    extends Worker {
        private DatagramPacket datagram;
        private int size;

        private Receiver(String name) {
            super(name);
            this.size = UDPConnector.this.receiverPacketSize;
            this.datagram = new DatagramPacket(new byte[this.size], this.size);
        }

        @Override
        protected void work() throws IOException {
            this.datagram.setLength(this.size);
            UDPConnector.this.socket.receive(this.datagram);
            if (UDPConnector.this.logPackets) {
                LOGGER.fine("Connector (" + UDPConnector.this.socket.getLocalSocketAddress() + ") received " + this.datagram.getLength() + " bytes from " + this.datagram.getAddress() + ":" + this.datagram.getPort());
            }
            byte[] bytes = Arrays.copyOfRange(this.datagram.getData(), this.datagram.getOffset(), this.datagram.getLength());
            RawData msg = new RawData(bytes);
            msg.setAddress(this.datagram.getAddress());
            msg.setPort(this.datagram.getPort());
            UDPConnector.this.receiver.receiveData(msg);
        }
    }

    private abstract class Worker
    extends Thread {
        private Worker(String name) {
            super(name);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            LOGGER.config("Start " + this.getName());
            while (UDPConnector.this.running) {
                try {
                    this.work();
                }
                catch (Throwable t) {
                    if (UDPConnector.this.running) {
                        LOGGER.log(Level.WARNING, "Exception \"" + t + "\" in thread " + this.getName() + ": running=" + UDPConnector.this.running, t);
                        continue;
                    }
                    LOGGER.info(this.getName() + " has successfully stopped");
                }
            }
        }

        protected abstract void work() throws Exception;
    }
}

