/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.observe;

import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.config.NetworkConfig;

public class ObserveNotificationOrderer {
    private AtomicInteger number = new AtomicInteger();
    private long timestamp;

    public int getNextObserveNumber() {
        int next = this.number.incrementAndGet();
        while (next >= 0x1000000) {
            this.number.compareAndSet(next, 0);
            next = this.number.incrementAndGet();
        }
        return next;
    }

    public int getCurrent() {
        return this.number.get();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public synchronized boolean isNew(Response response) {
        if (!response.getOptions().hasObserve()) {
            return true;
        }
        long T1 = this.getTimestamp();
        long T2 = System.currentTimeMillis();
        int V1 = this.getCurrent();
        int V2 = response.getOptions().getObserve();
        int notifMaxAge = NetworkConfig.getStandard().getInt("NOTIFICATION_MAX_AGE");
        if (V1 < V2 && V2 - V1 < 0x800000 || V1 > V2 && V1 - V2 > 0x800000 || T2 > T1 + (long)notifMaxAge) {
            this.setTimestamp(T2);
            this.number.set(V2);
            return true;
        }
        return false;
    }
}

