/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.tests;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.plugtests.TestClientAbstract;

public class CC22
extends TestClientAbstract {
    public static final String RESOURCE_URI = "/validate";
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE_PREAMBLE = CoAP.ResponseCode.CONTENT;
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE_A = CoAP.ResponseCode.CHANGED;
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE_B = CoAP.ResponseCode.PRECONDITION_FAILED;
    public byte[] etag1;
    public byte[] etag2;

    public CC22(String serverURI) {
        super(CC22.class.getSimpleName());
        Request request = new Request(CoAP.Code.GET, CoAP.Type.CON);
        this.executeRequest(request, serverURI, RESOURCE_URI);
    }

    @Override
    protected synchronized void executeRequest(Request request, String serverURI, String resourceUri) {
        if (!serverURI.endsWith("/") && !resourceUri.startsWith("/")) {
            resourceUri = "/" + resourceUri;
        }
        URI uri = null;
        try {
            uri = new URI(serverURI + resourceUri);
            this.setUseTcp(uri.getScheme());
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException("Invalid URI: " + use.getMessage());
        }
        CC22.addContextObserver(request);
        request.setURI(uri);
        if (this.verbose) {
            System.out.println("Request for test " + this.testName + " sent");
            Utils.prettyPrint(request);
        }
        try {
            Response response = null;
            boolean success = true;
            System.out.println();
            System.out.println("**** TEST: " + this.testName + " ****");
            System.out.println("**** BEGIN CHECK ****");
            request.send();
            response = request.waitForResponse(6000L);
            if (response != null) {
                if (this.verbose) {
                    System.out.println("Response received");
                    System.out.println("Time elapsed (ms): " + TimeUnit.NANOSECONDS.toMillis(response.getApplicationRttNanos()));
                    Utils.prettyPrint(response);
                }
                success &= this.checkCode(this.EXPECTED_RESPONSE_CODE_PREAMBLE, response.getCode());
                success &= this.hasEtag(response);
                success &= this.hasNonEmptyPayload(response);
                if (success &= this.hasContentType(response)) {
                    this.etag1 = response.getOptions().getResponseEtag();
                    request = new Request(CoAP.Code.PUT, CoAP.Type.CON);
                    request.getOptions().addIfMatch(this.etag1);
                    request.setPayload("TD_COAP_CORE_22 Part A");
                    request.getOptions().setContentFormat(0);
                    CC22.addContextObserver(request);
                    request.setURI(uri);
                    request.send();
                    response = request.waitForResponse(6000L);
                    if (response != null) {
                        if (this.verbose) {
                            System.out.println("Response received");
                            System.out.println("Time elapsed (ms): " + TimeUnit.NANOSECONDS.toMillis(response.getApplicationRttNanos()));
                            Utils.prettyPrint(response);
                        }
                        success &= this.checkCode(this.EXPECTED_RESPONSE_CODE_A, response.getCode());
                        success &= this.hasContentType(response);
                        request = new Request(CoAP.Code.GET, CoAP.Type.CON);
                        CC22.addContextObserver(request);
                        request.setURI(uri);
                        request.send();
                        response = request.waitForResponse(6000L);
                        if (response != null) {
                            this.etag2 = response.getOptions().getResponseEtag();
                            success &= this.checkCode(this.EXPECTED_RESPONSE_CODE_PREAMBLE, response.getCode());
                            success &= this.hasEtag(response);
                            success &= this.hasNonEmptyPayload(response);
                            success &= this.hasContentType(response);
                            if (success &= this.checkDifferentOption(this.etag1, this.etag2, "ETag")) {
                                request = new Request(CoAP.Code.PUT, CoAP.Type.CON);
                                CC22.addContextObserver(request);
                                request.setURI(uri);
                                request.setPayload("It should change " + Math.random());
                                request.getOptions().setContentFormat(0);
                                request.send();
                                Thread.sleep(1000L);
                                request = new Request(CoAP.Code.PUT, CoAP.Type.CON);
                                request.getOptions().addIfMatch(this.etag1);
                                request.setPayload("TD_COAP_CORE_22 Part B");
                                request.getOptions().setContentFormat(0);
                                CC22.addContextObserver(request);
                                request.setURI(uri);
                                request.send();
                                response = request.waitForResponse(6000L);
                                if (response != null) {
                                    if (this.verbose) {
                                        System.out.println("Response received");
                                        System.out.println("Time elapsed (ms): " + TimeUnit.NANOSECONDS.toMillis(response.getApplicationRttNanos()));
                                        Utils.prettyPrint(response);
                                    }
                                    success &= this.checkType(CoAP.Type.ACK, response.getType());
                                    success &= this.checkCode(this.EXPECTED_RESPONSE_CODE_B, response.getCode());
                                }
                            }
                        }
                    }
                }
            }
            if (success) {
                System.out.println("**** TEST PASSED ****");
                this.addSummaryEntry(this.testName + ": PASSED");
            } else {
                System.out.println("**** TEST FAILED ****");
                this.addSummaryEntry(this.testName + ": --FAILED--");
            }
            this.tickOffTest();
        }
        catch (InterruptedException e) {
            System.err.println("Interupted during receive: " + e.getMessage());
            System.exit(-1);
        }
    }

    @Override
    protected boolean checkResponse(Request request, Response response) {
        return false;
    }
}

