/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.tests;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.option.StandardOptionRegistry;
import org.eclipse.californium.plugtests.PlugtestChecker;
import org.eclipse.californium.plugtests.TestClientAbstract;

public class CB03
extends TestClientAbstract {
    String data = PlugtestChecker.getLargeRequestPayload();
    private CoAP.ResponseCode EXPECTED_RESPONSE_CODE = CoAP.ResponseCode.CHANGED;

    public CB03(String serverURI) {
        super(CB03.class.getSimpleName());
        Request request = Request.newPut();
        request.setPayload(this.data);
        request.getOptions().setContentFormat(0);
        this.executeRequest(request, serverURI, "/large-update");
    }

    @Override
    protected boolean checkResponse(Request request, Response response) {
        boolean success = response.getOptions().hasBlock1();
        if (!success) {
            System.out.println("FAIL: no Block1 option");
        } else {
            int maxNUM = response.getOptions().getBlock1().getNum();
            success &= this.checkType(CoAP.Type.ACK, response.getType());
            success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
            success &= this.checkOption(StandardOptionRegistry.BLOCK1.create(2, false, maxNUM), response.getOptions().getBlock1(), "Block1");
        }
        return success;
    }
}

