/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.WebLink;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EndpointContextTracer;
import org.eclipse.californium.core.coap.LinkFormat;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.coap.option.BlockOption;
import org.eclipse.californium.core.coap.option.OptionDefinition;
import org.eclipse.californium.core.coap.option.StandardOptionRegistry;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.EndpointManager;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.plugtests.PlugtestChecker;
import org.eclipse.californium.plugtests.Report;

public abstract class TestClientAbstract {
    private static final EndpointContextTracer ENDPOINT_CONTEXT_TRACER = new EndpointContextTracer(){

        @Override
        protected void onContextChanged(EndpointContext endpointContext) {
            System.out.println(Utils.prettyPrint(endpointContext));
        }
    };
    protected Report report = new Report();
    private Throwable sendError;
    protected Semaphore terminated = new Semaphore(0);
    protected String testName = null;
    protected boolean verbose = true;
    protected boolean sync = true;
    protected boolean useTcp = false;
    protected volatile Request observe;
    protected AtomicReference<Response> notification = new AtomicReference();
    protected TestNotificationListener listener;

    public TestClientAbstract(String testName, boolean verbose, boolean synchronous) {
        if (testName == null || testName.isEmpty()) {
            throw new IllegalArgumentException("testName == null || testName.isEmpty()");
        }
        this.testName = testName;
        this.verbose = verbose;
        this.sync = synchronous;
    }

    public TestClientAbstract(String testName) {
        this(testName, PlugtestChecker.verbose, true);
    }

    public void setUseTcp(String scheme) {
        this.useTcp = CoAP.isTcpScheme(scheme);
    }

    protected void startObserve(Request request) {
        this.stopObservation();
        TestClientAbstract.addContextObserver(request);
        Endpoint endpoint = EndpointManager.getEndpointManager().getDefaultEndpoint(request.getScheme());
        this.listener = new TestNotificationListener(endpoint);
        endpoint.addNotificationListener(this.listener);
        this.observe = request;
        request.send(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response waitForNotification(long timeout) throws IllegalStateException, InterruptedException {
        if (this.listener == null) {
            throw new IllegalStateException("missing startObserve");
        }
        Response notify = null;
        AtomicReference<Response> atomicReference = this.notification;
        synchronized (atomicReference) {
            notify = this.notification.get();
            if (notify == null) {
                this.notification.wait(timeout);
                notify = this.notification.get();
            }
            this.notification.set(null);
        }
        return notify;
    }

    protected void stopObservation() {
        if (this.listener != null) {
            this.listener.close();
            this.listener = null;
            this.observe = null;
        }
    }

    protected void executeRequest(Request request, String serverURI, String resourceUri) {
        if (!serverURI.endsWith("/") && !resourceUri.startsWith("/")) {
            resourceUri = "/" + resourceUri;
        }
        URI uri = null;
        try {
            uri = new URI(serverURI + resourceUri);
            this.useTcp = CoAP.isTcpScheme(uri.getScheme());
        }
        catch (URISyntaxException use) {
            System.err.println("Invalid URI: " + use.getMessage());
        }
        TestClientAbstract.addContextObserver(request);
        request.setURI(uri);
        request.addMessageObserver(new TestResponseHandler(request));
        if (this.verbose) {
            System.out.println("Request for test " + this.testName + " sent");
            Utils.prettyPrint(request);
        }
        try {
            request.send();
            if (this.sync) {
                request.waitForResponse(5000L);
            }
        }
        catch (InterruptedException e) {
            System.err.println("Interupted during receive: " + e.getMessage());
            System.exit(-1);
        }
    }

    protected static void addContextObserver(Request request) {
        EndpointContext context = ENDPOINT_CONTEXT_TRACER.getCurrentContext();
        if (context != null && request.getDestinationContext() == null) {
            request.setDestinationContext(context);
        }
        request.addMessageObserver(ENDPOINT_CONTEXT_TRACER);
    }

    public synchronized void addSummaryEntry(String entry) {
        this.report.addEntry(entry);
    }

    public Report getReport() {
        return this.report;
    }

    public void tickOffTest() {
        this.terminated.release();
    }

    public void waitForUntilTestHasTerminated() throws Throwable {
        try {
            this.terminated.acquire();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.sendError != null) {
            throw this.sendError;
        }
    }

    protected abstract boolean checkResponse(Request var1, Response var2);

    protected boolean checkInt(int expected, int actual, String fieldName) {
        boolean success;
        boolean bl = success = expected == actual;
        if (!success) {
            System.out.println("FAIL: Expected " + fieldName + ": " + expected + ", but was: " + actual);
        } else {
            System.out.println("PASS: Correct " + fieldName + String.format(" (%d)", actual));
        }
        return success;
    }

    protected boolean checkInts(int[] expected, int actual, String fieldName) {
        boolean success = false;
        for (int i : expected) {
            if (i != actual) continue;
            success = true;
            break;
        }
        if (!success) {
            System.out.println("FAIL: Expected " + fieldName + ": " + Arrays.toString(expected) + ", but was: " + actual);
        } else {
            System.out.println("PASS: Correct " + fieldName + String.format(" (%d)", actual));
        }
        return success;
    }

    protected boolean checkCode(CoAP.ResponseCode expected, CoAP.ResponseCode actual) {
        boolean success = expected.equals((Object)actual);
        if (!success) {
            System.out.println("FAIL: Expected code: " + (Object)((Object)expected) + ", but was: " + (Object)((Object)actual));
        } else {
            System.out.println("PASS: Correct code: " + (Object)((Object)actual));
        }
        return success;
    }

    protected boolean checkCodes(CoAP.ResponseCode[] expected, CoAP.ResponseCode actual) {
        boolean success = false;
        for (CoAP.ResponseCode code : expected) {
            if (!code.equals((Object)actual)) continue;
            success = true;
            break;
        }
        if (!success) {
            System.out.println("FAIL: Expected code: " + Arrays.toString((Object[])expected) + ", but was: " + (Object)((Object)actual));
        } else {
            System.out.println("PASS: Correct code: " + (Object)((Object)actual));
        }
        return success;
    }

    protected boolean checkString(String expected, String actual, String fieldName) {
        boolean success = expected.equals(actual);
        if (!success) {
            System.out.println("FAIL: Expected " + fieldName + ": \"" + expected + "\", but was: \"" + actual + "\"");
        } else {
            System.out.println("PASS: Correct " + fieldName + " \"" + actual + "\"");
        }
        return success;
    }

    protected boolean checkType(CoAP.Type expectedMessageType, CoAP.Type actualMessageType) {
        if (this.useTcp) {
            return true;
        }
        boolean success = expectedMessageType.equals((Object)actualMessageType);
        if (!success) {
            System.out.printf("FAIL: Expected type %s, but was %s\n", new Object[]{expectedMessageType, actualMessageType});
        } else {
            System.out.printf("PASS: Correct type (%s)\n", actualMessageType.toString());
        }
        return success;
    }

    protected boolean checkTypes(CoAP.Type[] expectedMessageTypes, CoAP.Type actualMessageType) {
        boolean success = false;
        for (CoAP.Type messageType : expectedMessageTypes) {
            if (!messageType.equals((Object)actualMessageType)) continue;
            success = true;
            break;
        }
        if (!success) {
            StringBuilder sb = new StringBuilder();
            for (CoAP.Type messageType : expectedMessageTypes) {
                sb.append(", ").append((Object)messageType);
            }
            sb.delete(0, 2);
            System.out.printf("FAIL: Expected type %s, but was %s\n", new Object[]{"[ " + sb.toString() + " ]", actualMessageType});
        } else {
            System.out.printf("PASS: Correct type (%s)\n", actualMessageType.toString());
        }
        return success;
    }

    protected boolean hasContentType(Response response) {
        boolean success;
        boolean bl = success = response.getOptions().hasContentFormat() || response.getPayloadSize() == 0 || !response.isSuccess();
        if (!success) {
            System.out.println("FAIL: Response without Content-Type");
        } else {
            System.out.printf("PASS: Content-Type (%s)\n", MediaTypeRegistry.toString(response.getOptions().getContentFormat()));
        }
        return success;
    }

    protected boolean hasLocation(Response response) {
        boolean success;
        boolean bl = success = response.getOptions().getLocationPathCount() > 0;
        if (!success) {
            System.out.println("FAIL: Response without Location");
        } else {
            System.out.printf("PASS: Location (%s)\n", response.getOptions().getLocationPathString());
        }
        return success;
    }

    protected boolean hasEtag(Response response) {
        byte[] etag = response.getOptions().getResponseEtag();
        if (etag == null) {
            System.out.println("FAIL: Response without Etag");
            return false;
        }
        System.out.printf("PASS: Etag (%s)\n", Utils.toHexString(etag));
        return true;
    }

    protected boolean hasNonEmptyPayload(Response response) {
        boolean success = response.getPayloadSize() > 0;
        boolean print = MediaTypeRegistry.isPrintable(response.getOptions().getContentFormat());
        if (!success) {
            System.out.println("FAIL: Response with empty payload");
        } else if (print) {
            String payload = response.getPayloadString();
            if (payload.length() < 50) {
                System.out.printf("PASS: Payload not empty \"%s\"%n", response.getPayloadString());
            } else {
                System.out.printf("PASS: Payload not empty%n%s%n", response.getPayloadString());
            }
        } else {
            System.out.printf("PASS: Payload not empty%n0x%s%n", StringUtil.byteArray2Hex(response.getPayload()));
        }
        return success;
    }

    protected boolean hasMaxAge(Response response) {
        boolean success = response.getOptions().hasMaxAge();
        if (!success) {
            System.out.println("FAIL: Response without Max-Age");
        } else {
            System.out.printf("PASS: Max-Age (%s)\n", response.getOptions().getMaxAge());
        }
        return success;
    }

    protected boolean hasLocationQuery(Response response) {
        boolean success;
        boolean bl = success = response.getOptions().getLocationQueryCount() > 0;
        if (!success) {
            System.out.println("FAIL: Response without Location-Query");
        } else {
            System.out.printf("PASS: Location-Query (%s)\n", response.getOptions().getLocationQueryString());
        }
        return success;
    }

    protected boolean hasToken(Response response) {
        boolean success;
        boolean bl = success = response.getToken() != null;
        if (!success) {
            System.out.println("FAIL: Response without Token");
        } else {
            System.out.printf("PASS: Token (%s)\n", response.getTokenString());
        }
        return success;
    }

    protected boolean hasNoToken(Response response) {
        boolean success = response.hasEmptyToken();
        if (!success) {
            System.out.println("FAIL: Expected no token but had " + response.getTokenString());
        } else {
            System.out.printf("PASS: No Token\n", new Object[0]);
        }
        return success;
    }

    protected boolean hasObserve(Response response) {
        return this.hasOption(response, StandardOptionRegistry.OBSERVE, false);
    }

    protected boolean hasNoObserve(Response response) {
        return this.hasOption(response, StandardOptionRegistry.OBSERVE, true);
    }

    protected boolean hasOption(Response response, OptionDefinition optionDefintion, boolean invert) {
        String name = optionDefintion.getName();
        List<Option> asSortedList = response.getOptions().asSortedList();
        Option match = null;
        for (Option option : asSortedList) {
            if (!optionDefintion.equals(option.getDefinition())) continue;
            match = option;
            break;
        }
        boolean success = match != null ^ invert;
        StringBuilder result = new StringBuilder();
        if (success) {
            result.append("PASS: Response ");
        } else {
            result.append("FAIL: Response ");
        }
        if (match != null) {
            result.append("with ");
            result.append(name);
        } else {
            result.append("without ").append(name);
        }
        System.out.println(result);
        return success;
    }

    protected boolean checkOption(Option expextedOption, Option actualOption) {
        boolean success;
        boolean bl = success = actualOption != null && expextedOption.getNumber() == actualOption.getNumber();
        if (!success) {
            System.out.printf("FAIL: Missing option nr %d\n", expextedOption.getNumber());
        } else if (!(success &= expextedOption.toString().equals(actualOption.toString()))) {
            System.out.printf("FAIL: Expected %s, but was %s\n", expextedOption.toString(), actualOption.toString());
        } else {
            System.out.printf("PASS: Correct option (%s)\n", actualOption.toString());
        }
        return success;
    }

    protected boolean checkOption(BlockOption expected, BlockOption actual, String optionName) {
        boolean success;
        boolean bl = expected == null ? actual == null : (success = expected.equals(actual));
        if (!success) {
            System.out.println("FAIL: option " + optionName + ": expected " + expected + " but was " + actual);
        } else {
            System.out.println("PASS: Correct option " + actual);
        }
        return success;
    }

    protected boolean checkOption(byte[] expectedOption, byte[] actualOption, String optionName) {
        boolean success = Arrays.equals(expectedOption, actualOption);
        if (!success) {
            System.out.println("FAIL: Option " + optionName + ": expected " + Utils.toHexString(expectedOption) + " but was " + Utils.toHexString(actualOption));
        } else {
            System.out.printf("PASS: Correct option %s\n", optionName);
        }
        return success;
    }

    protected boolean checkOption(List<String> expected, List<String> actual, String optionName) {
        boolean success = expected.equals(actual);
        if (!success) {
            System.out.println("FAIL: Option " + optionName + ": expected " + expected + " but was " + actual);
        } else {
            System.out.printf("PASS: Correct option %s\n", optionName);
        }
        return success;
    }

    protected boolean checkOption(Integer expected, Integer actual, String optionName) {
        boolean success;
        boolean bl = expected == null ? actual == null : (success = expected.equals(actual));
        if (!success) {
            System.out.println("FAIL: Option " + optionName + ": expected " + expected + " but was " + actual);
        } else {
            System.out.printf("PASS: Correct option %s\n", optionName);
        }
        return success;
    }

    protected boolean checkDifferentOption(Option expextedOption, Option actualOption) {
        boolean success;
        boolean bl = success = actualOption != null && expextedOption.getNumber() == actualOption.getNumber();
        if (!success) {
            System.out.printf("FAIL: Missing option nr %d\n", expextedOption.getNumber());
        } else if (!(success &= !expextedOption.toString().equals(actualOption.toString()))) {
            System.out.printf("FAIL: Expected difference, but was %s\n", actualOption.toString());
        } else {
            System.out.printf("PASS: Expected not %s and was %s\n", expextedOption.toString(), actualOption.toString());
        }
        return success;
    }

    protected boolean checkDifferentOption(byte[] expected, byte[] actual, String optionName) {
        boolean success;
        boolean bl = success = !Arrays.equals(expected, actual);
        if (!success) {
            System.out.println("FAIL: Option " + optionName + ": expected " + Utils.toHexString(expected) + " but was " + Utils.toHexString(actual));
        } else {
            System.out.println("PASS: Correct option " + optionName);
        }
        return success;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean checkToken(Token expectedToken, Token actualToken) {
        if (expectedToken == null) {
            expectedToken = Token.EMPTY;
        }
        if (actualToken == null) {
            actualToken = Token.EMPTY;
        }
        if (expectedToken.isEmpty()) {
            if (actualToken.isEmpty()) {
                System.out.println("PASS: Correct empty token");
                return true;
            }
            System.out.printf("FAIL: Expected empty token, but was %s\n", actualToken.getAsString());
            return false;
        }
        if (actualToken.length() < 1 || actualToken.length() > 8) {
            System.out.printf("FAIL: Expected token %s, but %s has illeagal length\n", expectedToken.getAsString(), actualToken.getAsString());
            return false;
        }
        if (expectedToken.equals(actualToken)) {
            System.out.printf("PASS: Correct token (%s)\n", actualToken.getAsString());
            return true;
        }
        System.out.printf("FAIL: Expected token %s, but was %s\n", expectedToken.getAsString(), actualToken.getAsString());
        return false;
    }

    protected boolean checkDiscovery(String expextedResource, String actualDiscovery) {
        return actualDiscovery.contains("<" + expextedResource + ">");
    }

    protected boolean checkDiscoveryAttributes(String expextedAttribute, String actualDiscovery) {
        if (actualDiscovery == "") {
            System.err.println("Empty Link Format, check manually");
            return false;
        }
        Set<WebLink> links = LinkFormat.parse(actualDiscovery);
        List<String> query = Arrays.asList(expextedAttribute);
        boolean success = true;
        for (WebLink link : links) {
            if (success &= LinkFormat.matches(link, query)) continue;
            System.out.printf("FAIL: Expected %s, but was %s\n", expextedAttribute, link);
        }
        if (success) {
            System.out.println("PASS: Correct Link Format filtering");
        }
        return success;
    }

    protected class TestNotificationListener
    implements BiConsumer<Request, Response> {
        private Endpoint endpoint;

        public TestNotificationListener(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Request request, Response response) {
            Request origin = TestClientAbstract.this.observe;
            if (origin != null && origin.getToken().equals(response.getToken())) {
                AtomicReference<Response> atomicReference = TestClientAbstract.this.notification;
                synchronized (atomicReference) {
                    TestClientAbstract.this.notification.set(response);
                    TestClientAbstract.this.notification.notify();
                }
            }
        }

        public void close() {
            Request origin = TestClientAbstract.this.observe;
            if (origin != null) {
                if (origin.isObserve()) {
                    Request cancel = Request.newGet();
                    cancel.setDestinationContext(origin.getDestinationContext());
                    cancel.setToken(origin.getToken());
                    cancel.setOptions(origin.getOptions());
                    cancel.setObserveCancel();
                    this.endpoint.sendRequest(cancel);
                    try {
                        cancel.waitForResponse(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.endpoint.cancelObservation(origin.getToken());
            }
            this.endpoint.removeNotificationListener(this);
        }
    }

    protected class TestResponseHandler
    extends MessageObserverAdapter {
        private Request request;
        private final AtomicInteger requestCounter = new AtomicInteger();

        public TestResponseHandler(Request request) {
            this.request = request;
        }

        @Override
        public void onRetransmission() {
            this.requestCounter.decrementAndGet();
        }

        @Override
        public void onSent(boolean retransmission) {
            this.requestCounter.incrementAndGet();
        }

        @Override
        public void onResponse(Response response) {
            System.out.println();
            System.out.println("**** TEST: " + TestClientAbstract.this.testName + " ****");
            if (response != null) {
                int requests = this.requestCounter.get();
                if (TestClientAbstract.this.verbose) {
                    System.out.println("Response received");
                    System.out.println("Time elapsed (ms): " + TimeUnit.NANOSECONDS.toMillis(response.getApplicationRttNanos()));
                    if (requests > 1) {
                        System.out.println(requests + " blocks");
                    }
                    Utils.prettyPrint(response);
                }
                if (response.getOptions().hasBlock1()) {
                    requests -= response.getOptions().getBlock1().getNum();
                }
                if (requests > 1 && !response.getOptions().hasBlock2()) {
                    int bit;
                    int size = response.getPayloadSize() / requests;
                    if (size - (bit = Integer.highestOneBit(size)) != 0) {
                        bit <<= 1;
                    }
                    response.getOptions().setBlock2(BlockOption.size2Szx(bit), false, requests - 1);
                }
                System.out.println("**** BEGIN CHECK ****");
                if (TestClientAbstract.this.checkResponse(this.request, response)) {
                    System.out.println("**** TEST PASSED ****");
                    TestClientAbstract.this.addSummaryEntry(TestClientAbstract.this.testName + ": PASSED");
                } else {
                    System.out.println("**** TEST FAILED ****");
                    TestClientAbstract.this.addSummaryEntry(TestClientAbstract.this.testName + ": --FAILED--");
                }
                TestClientAbstract.this.tickOffTest();
            }
        }

        @Override
        public void onSendError(Throwable error) {
            TestClientAbstract.this.sendError = error;
            TestClientAbstract.this.tickOffTest();
        }

        @Override
        protected void failed() {
            TestClientAbstract.this.tickOffTest();
        }
    }
}

