/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap.option;

import java.util.Arrays;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionNumberRegistry;
import org.eclipse.californium.core.coap.option.BaseOptionDefinition;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;

public class OpaqueOption
extends Option {
    private final byte[] value;

    public OpaqueOption(Definition definition, byte[] value) {
        super(definition);
        if (value == null) {
            throw new NullPointerException("Option " + definition.getName() + " value must not be null.");
        }
        this.value = value;
        definition.assertValueLength(value.length);
    }

    @Override
    public int getLength() {
        return this.value.length;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    public void writeTo(DatagramWriter writer) {
        writer.writeBytes(this.value);
    }

    @Override
    public String toValueString() {
        return "0x" + StringUtil.byteArray2Hex(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpaqueOption)) {
            return false;
        }
        OpaqueOption op = (OpaqueOption)o;
        return Arrays.equals(this.value, op.value) && this.getDefinition().equals(op.getDefinition());
    }

    @Override
    public int hashCode() {
        return 31 * this.getDefinition().hashCode() + Arrays.hashCode(this.value);
    }

    public static class Definition
    extends BaseOptionDefinition {
        public Definition(int number, String name) {
            this(number, name, true, null);
        }

        public Definition(int number, String name, boolean singleValue) {
            this(number, name, singleValue, null);
        }

        public Definition(int number, String name, boolean singleValue, int ... lengths) {
            super(number, name, singleValue, lengths);
        }

        @Override
        public OptionNumberRegistry.OptionFormat getFormat() {
            return OptionNumberRegistry.OptionFormat.OPAQUE;
        }

        @Override
        public OpaqueOption create(DatagramReader reader, int length) {
            if (reader == null) {
                throw new NullPointerException("Option " + this.getName() + " reader must not be null.");
            }
            return new OpaqueOption(this, reader.readBytes(length));
        }

        public OpaqueOption create(byte[] value) {
            if (value == null) {
                throw new NullPointerException("Option " + this.getName() + " value must not be null.");
            }
            return new OpaqueOption(this, value);
        }
    }
}

