/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORDataUtilities;
import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.JSONOptions;
import com.upokecenter.cbor.PropertyMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;

final class CBORJson2 {
    private final byte[] bytes;
    private final JSONOptions options;
    private int index;
    private int endPos;
    private static byte[] valueEmptyBytes = new byte[0];

    private int SkipWhitespaceJSON() {
        while (this.index < this.endPos) {
            byte c;
            if ((c = this.bytes[this.index++]) == 32 || c == 10 || c == 13 || c == 9) continue;
            return c;
        }
        return -1;
    }

    void RaiseError(String str) {
        throw new CBORException(str + " (approx. offset: " + Math.max(0, this.index - 1) + ")");
    }

    private byte[] NextJSONString() {
        int upper;
        int lower;
        int c;
        int startIndex;
        int batchIndex = startIndex = this.index;
        int batchEnd = startIndex;
        byte[] jbytes = this.bytes;
        while (true) {
            int c2;
            int c1;
            if (this.index >= this.endPos) {
                this.RaiseError("Unterminated String");
            }
            if ((c = jbytes[this.index++] & 0xFF) < 32) {
                this.RaiseError("Invalid character in String literal");
            }
            if (c == 92) break;
            if (c == 34) {
                int isize = this.index - startIndex - 1;
                if (isize == 0) {
                    return valueEmptyBytes;
                }
                byte[] buf = new byte[isize];
                System.arraycopy(jbytes, startIndex, buf, 0, isize);
                return buf;
            }
            if (c < 128) continue;
            if (c >= 194 && c <= 223) {
                int n = c1 = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
                if (c1 >= 128 && c1 <= 191) continue;
                this.RaiseError("Invalid encoding");
                continue;
            }
            if (c >= 224 && c <= 239) {
                int upper2;
                c1 = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
                c2 = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
                int lower2 = c == 224 ? 160 : 128;
                int n = upper2 = c == 237 ? 159 : 191;
                if (c1 >= lower2 && c1 <= upper2 && c2 >= 128 && c2 <= 191) continue;
                this.RaiseError("Invalid encoding");
                continue;
            }
            if (c >= 240 && c <= 244) {
                c1 = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
                c2 = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
                int c3 = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
                lower = c == 240 ? 144 : 128;
                int n = upper = c == 244 ? 143 : 191;
                if (c1 >= lower && c1 <= upper && c2 >= 128 && c2 <= 191 && c3 >= 128 && c3 <= 191) continue;
                this.RaiseError("Invalid encoding");
                continue;
            }
            this.RaiseError("Invalid encoding");
        }
        batchEnd = this.index - 1;
        ByteArrayOutputStream ms = null;
        try {
            ms = new ByteArrayOutputStream();
            if (batchEnd > batchIndex) {
                ms.write(jbytes, batchIndex, batchEnd - batchIndex);
                this.index = batchEnd;
                batchIndex = batchEnd;
            } else {
                this.index = startIndex;
                batchIndex = startIndex;
            }
            block22: while (true) {
                int c1;
                int c2;
                batchEnd = this.index;
                int n = c = this.index < this.endPos ? jbytes[this.index++] & 0xFF : -1;
                if (c == -1) {
                    this.RaiseError("Unterminated String");
                }
                if (c < 32) {
                    this.RaiseError("Invalid character in String literal");
                }
                switch (c) {
                    case 92: {
                        c = this.index < this.endPos ? jbytes[this.index++] & 0xFF : -1;
                        switch (c) {
                            case 34: 
                            case 47: 
                            case 92: {
                                if (batchEnd > batchIndex) {
                                    ms.write(jbytes, batchIndex, batchEnd - batchIndex);
                                }
                                batchIndex = this.index;
                                ms.write((byte)c);
                                continue block22;
                            }
                            case 98: {
                                if (batchEnd > batchIndex) {
                                    ms.write(jbytes, batchIndex, batchEnd - batchIndex);
                                }
                                batchIndex = this.index;
                                ms.write(8);
                                continue block22;
                            }
                            case 102: {
                                if (batchEnd > batchIndex) {
                                    ms.write(jbytes, batchIndex, batchEnd - batchIndex);
                                }
                                batchIndex = this.index;
                                ms.write(12);
                                continue block22;
                            }
                            case 110: {
                                if (batchEnd > batchIndex) {
                                    ms.write(jbytes, batchIndex, batchEnd - batchIndex);
                                }
                                batchIndex = this.index;
                                ms.write(10);
                                continue block22;
                            }
                            case 114: {
                                if (batchEnd > batchIndex) {
                                    ms.write(jbytes, batchIndex, batchEnd - batchIndex);
                                }
                                batchIndex = this.index;
                                ms.write(13);
                                continue block22;
                            }
                            case 116: {
                                if (batchEnd > batchIndex) {
                                    ms.write(jbytes, batchIndex, batchEnd - batchIndex);
                                }
                                batchIndex = this.index;
                                ms.write(9);
                                continue block22;
                            }
                            case 117: {
                                c = 0;
                                for (int i = 0; i < 4; ++i) {
                                    int ch;
                                    int n2 = ch = this.index < this.endPos ? jbytes[this.index++] : -1;
                                    if (ch >= 48 && ch <= 57) {
                                        c <<= 4;
                                        c |= ch - 48;
                                        continue;
                                    }
                                    if (ch >= 65 && ch <= 70) {
                                        c <<= 4;
                                        c |= ch + 10 - 65;
                                        continue;
                                    }
                                    if (ch >= 97 && ch <= 102) {
                                        c <<= 4;
                                        c |= ch + 10 - 97;
                                        continue;
                                    }
                                    this.RaiseError("Invalid Unicode escaped character");
                                }
                                if ((c & 0xF800) != 55296) {
                                    if (batchEnd > batchIndex) {
                                        ms.write(jbytes, batchIndex, batchEnd - batchIndex);
                                    }
                                    batchIndex = this.index;
                                    int ic = c;
                                    if (c >= 2048) {
                                        ms.write((byte)(0xE0 | ic >> 12 & 0xF));
                                        ms.write((byte)(0x80 | ic >> 6 & 0x3F));
                                        ms.write((byte)(0x80 | ic & 0x3F));
                                        continue block22;
                                    }
                                    if (c >= 128) {
                                        ms.write((byte)(0xC0 | ic >> 6 & 0x1F));
                                        ms.write((byte)(0x80 | ic & 0x3F));
                                        continue block22;
                                    }
                                    ms.write((byte)ic);
                                    continue block22;
                                }
                                if ((c & 0xFC00) == 55296) {
                                    if (this.index >= this.endPos - 1 || jbytes[this.index] != 92 || jbytes[this.index + 1] != 117) {
                                        this.RaiseError("Invalid escaped character");
                                    }
                                    this.index += 2;
                                    c2 = 0;
                                    for (int i = 0; i < 4; ++i) {
                                        int ch;
                                        int n3 = ch = this.index < this.endPos ? jbytes[this.index++] & 0xFF : -1;
                                        if (ch >= 48 && ch <= 57) {
                                            c2 <<= 4;
                                            c2 |= ch - 48;
                                            continue;
                                        }
                                        if (ch >= 65 && ch <= 70) {
                                            c2 <<= 4;
                                            c2 |= ch + 10 - 65;
                                            continue;
                                        }
                                        if (ch >= 97 && ch <= 102) {
                                            c2 <<= 4;
                                            c2 |= ch + 10 - 97;
                                            continue;
                                        }
                                        this.RaiseError("Invalid Unicode escaped character");
                                    }
                                    if ((c2 & 0xFC00) != 56320) {
                                        this.RaiseError("Unpaired surrogate code point");
                                        continue block22;
                                    }
                                    if (batchEnd > batchIndex) {
                                        ms.write(jbytes, batchIndex, batchEnd - batchIndex);
                                    }
                                    batchIndex = this.index;
                                    int ic = 65536 + ((c & 0x3FF) << 10) + (c2 & 0x3FF);
                                    ms.write((byte)(0xF0 | ic >> 18 & 7));
                                    ms.write((byte)(0x80 | ic >> 12 & 0x3F));
                                    ms.write((byte)(0x80 | ic >> 6 & 0x3F));
                                    ms.write((byte)(0x80 | ic & 0x3F));
                                    continue block22;
                                }
                                this.RaiseError("Unpaired surrogate code point");
                                continue block22;
                            }
                        }
                        this.RaiseError("Invalid escaped character");
                        continue block22;
                    }
                    case 34: {
                        if (batchEnd > batchIndex) {
                            ms.write(jbytes, batchIndex, batchEnd - batchIndex);
                        }
                        byte[] ch = ms.toByteArray();
                        return ch;
                    }
                }
                if (c <= 127) continue;
                if (c >= 194 && c <= 223) {
                    int n4 = c1 = this.index < this.endPos ? jbytes[this.index++] & 0xFF : -1;
                    if (c1 >= 128 && c1 <= 191) continue;
                    this.RaiseError("Invalid encoding");
                    continue;
                }
                if (c >= 224 && c <= 239) {
                    c1 = this.index < this.endPos ? jbytes[this.index++] & 0xFF : -1;
                    c2 = this.index < this.endPos ? jbytes[this.index++] & 0xFF : -1;
                    lower = c == 224 ? 160 : 128;
                    int n5 = upper = c == 237 ? 159 : 191;
                    if (c1 >= lower && c1 <= upper && c2 >= 128 && c2 <= 191) continue;
                    this.RaiseError("Invalid encoding");
                    continue;
                }
                if (c >= 240 && c <= 244) {
                    int upper3;
                    c1 = this.index < this.endPos ? jbytes[this.index++] & 0xFF : -1;
                    c2 = this.index < this.endPos ? jbytes[this.index++] & 0xFF : -1;
                    int c3 = this.index < this.endPos ? jbytes[this.index++] & 0xFF : -1;
                    int lower3 = c == 240 ? 144 : 128;
                    int n6 = upper3 = c == 244 ? 143 : 191;
                    if (c1 >= lower3 && c1 <= upper3 && c2 >= 128 && c2 <= 191 && c3 >= 128 && c3 <= 191) continue;
                    this.RaiseError("Invalid encoding");
                    continue;
                }
                this.RaiseError("Invalid encoding");
            }
        }
        finally {
            try {
                if (ms != null) {
                    ms.close();
                }
            }
            catch (IOException c2) {}
        }
    }

    private CBORObject NextJSONNegativeNumber(int[] nextChar) {
        CBORObject obj;
        int numberEndIndex;
        int c;
        int numberStartIndex = this.index - 1;
        int n = c = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
        if (c < 48 || c > 57) {
            this.RaiseError("JSON number can't be parsed.");
        }
        int cstart = c;
        while (c == 45 || c == 43 || c == 46 || c >= 48 && c <= 57 || c == 101 || c == 69) {
            c = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
        }
        if (c != 44 && c != 93 && c != 125 && c != -1 && c != 32 && c != 10 && c != 13 && c != 9) {
            this.RaiseError("Invalid character after JSON number");
        }
        int n2 = numberEndIndex = c < 0 ? this.endPos : this.index - 1;
        if (numberEndIndex - numberStartIndex == 2 && cstart != 48) {
            obj = CBORDataUtilities.ParseSmallNumberAsNegative(cstart - 48, this.options);
        } else {
            obj = CBORDataUtilities.ParseJSONNumber(this.bytes, numberStartIndex, numberEndIndex - numberStartIndex, this.options);
            if (obj == null) {
                String errstr = "";
                this.RaiseError("JSON number can't be parsed. " + errstr);
            }
        }
        nextChar[0] = c == -1 || c != 32 && c != 10 && c != 13 && c != 9 ? c : this.SkipWhitespaceJSON();
        return obj;
    }

    private CBORObject NextJSONNonnegativeNumber(int c, int[] nextChar) {
        CBORObject obj = null;
        int cval = c - 48;
        int cstart = c;
        int startIndex = this.index - 1;
        boolean needObj = true;
        int numberStartIndex = this.index - 1;
        int n = c = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
        if (c != 45 && c != 43 && c != 46 && (c < 48 || c > 57) && c != 101 && c != 69) {
            obj = CBORDataUtilities.ParseSmallNumber(cval, this.options);
            needObj = false;
        } else if (c >= 48 && c <= 57) {
            int csecond = c;
            if (cstart == 48) {
                this.RaiseError("JSON number can't be parsed.");
            }
            cval = cval * 10 + (c - 48);
            int n2 = c = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
            if (c >= 48 && c <= 57) {
                for (int digits = 2; digits < 9 && c >= 48 && c <= 57; ++digits) {
                    cval = cval * 10 + (c - 48);
                    c = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
                }
                if (c != 101 && c != 69 && c != 46 && (c < 48 || c > 57)) {
                    obj = CBORDataUtilities.ParseSmallNumber(cval, this.options);
                    needObj = false;
                }
            } else if (c != 45 && c != 43 && c != 46 && c != 101 && c != 69) {
                obj = CBORDataUtilities.ParseSmallNumber(cval, this.options);
                needObj = false;
            }
        }
        if (needObj) {
            int numberEndIndex;
            while (c == 45 || c == 43 || c == 46 || c >= 48 && c <= 57 || c == 101 || c == 69) {
                c = this.index < this.endPos ? this.bytes[this.index++] & 0xFF : -1;
            }
            if (c != 44 && c != 93 && c != 125 && c != -1 && c != 32 && c != 10 && c != 13 && c != 9) {
                this.RaiseError("Invalid character after JSON number");
            }
            if ((obj = CBORDataUtilities.ParseJSONNumber(this.bytes, numberStartIndex, (numberEndIndex = c < 0 ? this.endPos : this.index - 1) - numberStartIndex, this.options)) == null) {
                String errstr = "";
                this.RaiseError("JSON number can't be parsed. " + errstr);
            }
        } else if (c != 44 && c != 93 && c != 125 && c != -1 && c != 32 && c != 10 && c != 13 && c != 9) {
            this.RaiseError("Invalid character after JSON number");
        }
        nextChar[0] = c == -1 || c != 32 && c != 10 && c != 13 && c != 9 ? c : this.SkipWhitespaceJSON();
        return obj;
    }

    private CBORObject NextJSONValue(int firstChar, int[] nextChar, int depth) {
        int c = firstChar;
        CBORObject obj = null;
        if (c < 0) {
            this.RaiseError("Unexpected end of data");
        }
        switch (c) {
            case 34: {
                obj = CBORObject.FromRawUtf8(this.NextJSONString());
                nextChar[0] = this.SkipWhitespaceJSON();
                return obj;
            }
            case 123: {
                obj = this.ParseJSONObject(depth + 1);
                nextChar[0] = this.SkipWhitespaceJSON();
                return obj;
            }
            case 91: {
                obj = this.ParseJSONArray(depth + 1);
                nextChar[0] = this.SkipWhitespaceJSON();
                return obj;
            }
            case 116: {
                if (this.endPos - this.index <= 2 || this.bytes[this.index] != 114 || this.bytes[this.index + 1] != 117 || this.bytes[this.index + 2] != 101) {
                    this.RaiseError("Value can't be parsed.");
                }
                this.index += 3;
                nextChar[0] = this.SkipWhitespaceJSON();
                return CBORObject.True;
            }
            case 102: {
                if (this.endPos - this.index <= 3 || this.bytes[this.index] != 97 || this.bytes[this.index + 1] != 108 || this.bytes[this.index + 2] != 115 || this.bytes[this.index + 3] != 101) {
                    this.RaiseError("Value can't be parsed.");
                }
                this.index += 4;
                nextChar[0] = this.SkipWhitespaceJSON();
                return CBORObject.False;
            }
            case 110: {
                if (this.endPos - this.index <= 2 || this.bytes[this.index] != 117 || this.bytes[this.index + 1] != 108 || this.bytes[this.index + 2] != 108) {
                    this.RaiseError("Value can't be parsed.");
                }
                this.index += 3;
                nextChar[0] = this.SkipWhitespaceJSON();
                return CBORObject.Null;
            }
            case 45: {
                return this.NextJSONNegativeNumber(nextChar);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.NextJSONNonnegativeNumber(c, nextChar);
            }
        }
        this.RaiseError("Value can't be parsed.");
        return null;
    }

    public CBORJson2(byte[] bytes, int index, int endPos, JSONOptions options) {
        this.bytes = bytes;
        this.index = index;
        this.endPos = endPos;
        this.options = options;
    }

    public CBORObject ParseJSON(int[] nextchar) {
        int c = this.SkipWhitespaceJSON();
        if (c == 91) {
            CBORObject ret = this.ParseJSONArray(0);
            nextchar[0] = this.SkipWhitespaceJSON();
            return ret;
        }
        if (c == 123) {
            CBORObject ret = this.ParseJSONObject(0);
            nextchar[0] = this.SkipWhitespaceJSON();
            return ret;
        }
        return this.NextJSONValue(c, nextchar, 0);
    }

    static CBORObject ParseJSONValue(byte[] bytes, int index, int endPos, JSONOptions options) {
        int[] nextchar = new int[1];
        CBORJson2 cj = new CBORJson2(bytes, index, endPos, options);
        CBORObject obj = cj.ParseJSON(nextchar);
        if (nextchar[0] != -1) {
            cj.RaiseError("End of bytes not reached");
        }
        return obj;
    }

    static CBORObject ParseJSONValue(byte[] bytes, int index, int endPos, JSONOptions options, int[] nextchar) {
        CBORJson2 cj = new CBORJson2(bytes, index, endPos, options);
        return cj.ParseJSON(nextchar);
    }

    private CBORObject ParseJSONObject(int depth) {
        if (depth > 1000) {
            this.RaiseError("Too deeply nested");
        }
        CBORObject key = null;
        int[] nextchar = new int[1];
        boolean seenComma = false;
        TreeMap<CBORObject, CBORObject> myHashMap = this.options.getKeepKeyOrder() ? PropertyMap.NewOrderedDict() : new TreeMap<CBORObject, CBORObject>();
        block8: while (true) {
            int c = this.SkipWhitespaceJSON();
            switch (c) {
                case -1: {
                    this.RaiseError("A JSON Object must end with '}'");
                    break;
                }
                case 125: {
                    if (seenComma) {
                        this.RaiseError("Trailing comma");
                        return null;
                    }
                    return CBORObject.FromRaw(myHashMap);
                }
                default: {
                    CBORObject obj;
                    if (c < 0) {
                        this.RaiseError("Unexpected end of data");
                        return null;
                    }
                    if (c != 34) {
                        this.RaiseError("Expected a String as a key");
                        return null;
                    }
                    key = obj = CBORObject.FromRawUtf8(this.NextJSONString());
                }
            }
            if (this.SkipWhitespaceJSON() != 58) {
                this.RaiseError("Expected a ':' after a key");
            }
            int oldCount = myHashMap.size();
            myHashMap.put(key, this.NextJSONValue(this.SkipWhitespaceJSON(), nextchar, depth));
            int newCount = myHashMap.size();
            if (!this.options.getAllowDuplicateKeys() && oldCount == newCount) {
                this.RaiseError("Duplicate key already exists");
                return null;
            }
            switch (nextchar[0]) {
                case 44: {
                    seenComma = true;
                    continue block8;
                }
                case 125: {
                    return CBORObject.FromRaw(myHashMap);
                }
            }
            this.RaiseError("Expected a ',' or '}'");
        }
    }

    CBORObject ParseJSONArray(int depth) {
        if (depth > 1000) {
            this.RaiseError("Too deeply nested");
        }
        ArrayList<CBORObject> myArrayList = new ArrayList<CBORObject>();
        boolean seenComma = false;
        int[] nextchar = new int[1];
        block4: while (true) {
            int c;
            if ((c = this.SkipWhitespaceJSON()) == 93) {
                if (seenComma) {
                    this.RaiseError("Trailing comma");
                }
                return CBORObject.FromRaw(myArrayList);
            }
            if (c == 44) {
                this.RaiseError("Empty array element");
            }
            myArrayList.add(this.NextJSONValue(c, nextchar, depth));
            c = nextchar[0];
            switch (c) {
                case 44: {
                    seenComma = true;
                    continue block4;
                }
                case 93: {
                    return CBORObject.FromRaw(myArrayList);
                }
            }
            this.RaiseError("Expected a ',' or ']'");
        }
    }
}

