/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.tests;

import java.util.Arrays;
import java.util.List;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.plugtests.TestClientAbstract;

public class CC19
extends TestClientAbstract {
    public static final String RESOURCE_URI = "/location-query";
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE = CoAP.ResponseCode.CREATED;

    public CC19(String serverURI) {
        super(CC19.class.getSimpleName());
        Request request = new Request(CoAP.Code.POST, CoAP.Type.CON);
        request.setPayload("TD_COAP_CORE_19");
        request.getOptions().setContentFormat(0);
        this.executeRequest(request, serverURI, RESOURCE_URI);
    }

    @Override
    protected boolean checkResponse(Request request, Response response) {
        boolean success = true;
        success &= this.checkType(CoAP.Type.ACK, response.getType());
        success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
        success &= this.hasLocationQuery(response);
        List<String> query = response.getOptions().getLocationQuery();
        List<String> expec = Arrays.asList("first=1", "second=2");
        return success &= this.checkOption(expec, query, "Location Query");
    }
}

