/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

public final class OptionNumberRegistry {
    public static final int UNKNOWN = -1;
    public static final int RESERVED_0 = 0;
    public static final int IF_MATCH = 1;
    public static final int URI_HOST = 3;
    public static final int ETAG = 4;
    public static final int IF_NONE_MATCH = 5;
    public static final int URI_PORT = 7;
    public static final int LOCATION_PATH = 8;
    public static final int URI_PATH = 11;
    public static final int CONTENT_FORMAT = 12;
    public static final int MAX_AGE = 14;
    public static final int URI_QUERY = 15;
    public static final int ACCEPT = 17;
    public static final int LOCATION_QUERY = 20;
    public static final int PROXY_URI = 35;
    public static final int PROXY_SCHEME = 39;
    public static final int SIZE1 = 60;
    public static final int RESERVED_1 = 128;
    public static final int RESERVED_2 = 132;
    public static final int RESERVED_3 = 136;
    public static final int RESERVED_4 = 140;
    public static final int OBSERVE = 6;
    public static final int BLOCK2 = 23;
    public static final int BLOCK1 = 27;
    public static final int SIZE2 = 28;
    public static final int OSCORE = 9;
    public static final int NO_RESPONSE = 258;
    private static volatile CustomOptionNumberRegistry customRegistry;

    public static OptionFormat getFormatByNr(int optionNumber) {
        OptionFormat format;
        switch (optionNumber) {
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 17: 
            case 23: 
            case 27: 
            case 28: 
            case 60: 
            case 258: {
                return OptionFormat.INTEGER;
            }
            case 5: {
                return OptionFormat.EMPTY;
            }
            case 3: 
            case 8: 
            case 11: 
            case 15: 
            case 20: 
            case 35: 
            case 39: {
                return OptionFormat.STRING;
            }
            case 1: 
            case 4: 
            case 9: {
                return OptionFormat.OPAQUE;
            }
        }
        CustomOptionNumberRegistry custom = customRegistry;
        if (custom != null && (format = custom.getFormatByNr(optionNumber)) != null) {
            return format;
        }
        return OptionFormat.UNKNOWN;
    }

    public static boolean isCritical(int optionNumber) {
        return (optionNumber & 1) != 0;
    }

    public static boolean isElective(int optionNumber) {
        return (optionNumber & 1) == 0;
    }

    public static boolean isUnsafe(int optionNumber) {
        return (optionNumber & 2) > 0;
    }

    public static boolean isSafe(int optionNumber) {
        return !OptionNumberRegistry.isUnsafe(optionNumber);
    }

    public static boolean isNoCacheKey(int optionNumber) {
        return (optionNumber & 0x1E) == 28;
    }

    public static boolean isCacheKey(int optionNumber) {
        return !OptionNumberRegistry.isNoCacheKey(optionNumber);
    }

    public static boolean isCustomOption(int optionNumber) {
        switch (optionNumber) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 23: 
            case 27: 
            case 28: 
            case 35: 
            case 39: 
            case 60: 
            case 258: {
                return false;
            }
        }
        return true;
    }

    public static boolean isSingleValue(int optionNumber) {
        switch (optionNumber) {
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 23: 
            case 27: 
            case 28: 
            case 35: 
            case 39: 
            case 60: 
            case 258: {
                return true;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 15: 
            case 20: {
                return false;
            }
        }
        CustomOptionNumberRegistry custom = customRegistry;
        if (custom != null) {
            return custom.isSingleValue(optionNumber);
        }
        return true;
    }

    public static void assertValue(int optionNumber, long value) {
        CustomOptionNumberRegistry custom;
        if (OptionNumberRegistry.isCustomOption(optionNumber) && (custom = customRegistry) != null) {
            custom.assertValue(optionNumber, value);
        }
        try {
            int length = (64 - Long.numberOfLeadingZeros(value) + 7) / 8;
            OptionNumberRegistry.assertValueLength(optionNumber, length);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(ex.getMessage() + " Value " + value);
        }
    }

    public static void assertValueLength(int optionNumber, int valueLength) {
        int min = 0;
        int max = 65804;
        switch (optionNumber) {
            case 1: {
                max = 8;
                break;
            }
            case 3: 
            case 39: {
                min = 1;
                max = 255;
                break;
            }
            case 4: {
                min = 1;
                max = 8;
                break;
            }
            case 5: {
                max = 0;
                break;
            }
            case 7: 
            case 12: 
            case 17: {
                max = 2;
                break;
            }
            case 258: {
                max = 1;
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 20: {
                max = 255;
                break;
            }
            case 14: 
            case 28: 
            case 60: {
                max = 4;
                break;
            }
            case 35: {
                min = 1;
                max = 1034;
                break;
            }
            case 6: 
            case 23: 
            case 27: {
                max = 3;
                break;
            }
            default: {
                int[] lengths;
                CustomOptionNumberRegistry custom = customRegistry;
                if (custom == null || (lengths = custom.getValueLengths(optionNumber)) == null) break;
                if (lengths.length == 2) {
                    min = lengths[0];
                    max = lengths[1];
                    break;
                }
                if (lengths.length != 1) break;
                min = lengths[0];
                max = lengths[0];
            }
        }
        if (valueLength < min || valueLength > max) {
            String name = OptionNumberRegistry.toString(optionNumber);
            if (min == max) {
                if (min == 0) {
                    throw new IllegalArgumentException("Option " + name + " value of " + valueLength + " bytes must be empty.");
                }
                throw new IllegalArgumentException("Option " + name + " value of " + valueLength + " bytes must be " + min + " bytes.");
            }
            throw new IllegalArgumentException("Option " + name + " value of " + valueLength + " bytes must be in range of [" + min + "-" + max + "] bytes.");
        }
    }

    public static boolean isUriOption(int optionNumber) {
        boolean result = optionNumber == 3 || optionNumber == 11 || optionNumber == 7 || optionNumber == 15;
        return result;
    }

    public static String toString(int optionNumber) {
        String text;
        switch (optionNumber) {
            case 0: 
            case 128: 
            case 132: 
            case 136: 
            case 140: {
                return "Reserved";
            }
            case 1: {
                return "If-Match";
            }
            case 3: {
                return "Uri-Host";
            }
            case 4: {
                return "ETag";
            }
            case 5: {
                return "If-None-Match";
            }
            case 7: {
                return "Uri-Port";
            }
            case 8: {
                return "Location-Path";
            }
            case 11: {
                return "Uri-Path";
            }
            case 12: {
                return "Content-Format";
            }
            case 14: {
                return "Max-Age";
            }
            case 15: {
                return "Uri-Query";
            }
            case 17: {
                return "Accept";
            }
            case 20: {
                return "Location-Query";
            }
            case 35: {
                return "Proxy-Uri";
            }
            case 39: {
                return "Proxy-Scheme";
            }
            case 6: {
                return "Observe";
            }
            case 23: {
                return "Block2";
            }
            case 27: {
                return "Block1";
            }
            case 28: {
                return "Size2";
            }
            case 60: {
                return "Size1";
            }
            case 9: {
                return "Object-Security";
            }
            case 258: {
                return "No-Response";
            }
        }
        CustomOptionNumberRegistry custom = customRegistry;
        if (custom != null && (text = custom.toString(optionNumber)) != null) {
            return text;
        }
        return String.format("Unknown (%d)", optionNumber);
    }

    public static int toNumber(String name) {
        if ("If-Match".equals(name)) {
            return 1;
        }
        if ("Uri-Host".equals(name)) {
            return 3;
        }
        if ("ETag".equals(name)) {
            return 4;
        }
        if ("If-None-Match".equals(name)) {
            return 5;
        }
        if ("Uri-Port".equals(name)) {
            return 7;
        }
        if ("Location-Path".equals(name)) {
            return 8;
        }
        if ("Uri-Path".equals(name)) {
            return 11;
        }
        if ("Content-Format".equals(name)) {
            return 12;
        }
        if ("Max-Age".equals(name)) {
            return 14;
        }
        if ("Uri-Query".equals(name)) {
            return 15;
        }
        if ("Accept".equals(name)) {
            return 17;
        }
        if ("Location-Query".equals(name)) {
            return 20;
        }
        if ("Proxy-Uri".equals(name)) {
            return 35;
        }
        if ("Proxy-Scheme".equals(name)) {
            return 39;
        }
        if ("Observe".equals(name)) {
            return 6;
        }
        if ("Block2".equals(name)) {
            return 23;
        }
        if ("Block1".equals(name)) {
            return 27;
        }
        if ("Size2".equals(name)) {
            return 28;
        }
        if ("Size1".equals(name)) {
            return 60;
        }
        if ("Object-Security".equals(name)) {
            return 9;
        }
        if ("No-Response".equals(name)) {
            return 258;
        }
        CustomOptionNumberRegistry custom = customRegistry;
        if (custom != null) {
            return custom.toNumber(name);
        }
        return -1;
    }

    public static int[] getCriticalCustomOptions() {
        CustomOptionNumberRegistry custom = customRegistry;
        if (custom != null) {
            return custom.getCriticalCustomOptions();
        }
        return null;
    }

    public static CustomOptionNumberRegistry setCustomOptionNumberRegistry(CustomOptionNumberRegistry custom) {
        CustomOptionNumberRegistry previous = customRegistry;
        customRegistry = custom;
        return previous;
    }

    private OptionNumberRegistry() {
    }

    public static interface CustomOptionNumberRegistry {
        public OptionFormat getFormatByNr(int var1);

        public boolean isSingleValue(int var1);

        public void assertValue(int var1, long var2);

        public int[] getValueLengths(int var1);

        public String toString(int var1);

        public int toNumber(String var1);

        public int[] getCriticalCustomOptions();
    }

    public static enum OptionFormat {
        INTEGER,
        STRING,
        OPAQUE,
        UNKNOWN,
        EMPTY;

    }

    public static class Defaults {
        public static final long MAX_AGE = 60L;
    }

    public static class Names {
        public static final String Reserved = "Reserved";
        public static final String If_Match = "If-Match";
        public static final String Uri_Host = "Uri-Host";
        public static final String ETag = "ETag";
        public static final String If_None_Match = "If-None-Match";
        public static final String Uri_Port = "Uri-Port";
        public static final String Location_Path = "Location-Path";
        public static final String Uri_Path = "Uri-Path";
        public static final String Content_Format = "Content-Format";
        public static final String Max_Age = "Max-Age";
        public static final String Uri_Query = "Uri-Query";
        public static final String Accept = "Accept";
        public static final String Location_Query = "Location-Query";
        public static final String Proxy_Uri = "Proxy-Uri";
        public static final String Proxy_Scheme = "Proxy-Scheme";
        public static final String Size1 = "Size1";
        public static final String Observe = "Observe";
        public static final String Block2 = "Block2";
        public static final String Block1 = "Block1";
        public static final String Size2 = "Size2";
        public static final String Object_Security = "Object-Security";
        public static final String No_Response = "No-Response";
    }
}

