/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.observe.ObserveNotificationOrderer;
import org.eclipse.californium.elements.EndpointContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientObserveRelation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientObserveRelation.class);
    private final ScheduledThreadPoolExecutor scheduler;
    protected final Endpoint endpoint;
    private final long reregistrationBackoffMillis;
    private final AtomicBoolean requestPending = new AtomicBoolean(true);
    private final AtomicReference<ScheduledFuture<?>> reregistrationHandle = new AtomicReference();
    private volatile Request request;
    private volatile boolean canceled = false;
    private volatile boolean proactiveCancel = false;
    private volatile Response current = null;
    private volatile ObserveNotificationOrderer orderer;
    private final Runnable reregister = new Runnable(){

        @Override
        public void run() {
            ClientObserveRelation.this.reregister();
        }
    };
    private final MessageObserver pendingRequestObserver = new MessageObserverAdapter(){

        @Override
        public void onResponse(Response response) {
            this.next();
        }

        @Override
        public void onCancel() {
            this.next();
        }

        @Override
        protected void failed() {
            this.next();
        }

        private void next() {
            if (ClientObserveRelation.this.proactiveCancel) {
                ClientObserveRelation.this.sendCancelObserve();
            } else {
                ClientObserveRelation.this.requestPending.set(false);
            }
        }
    };

    public ClientObserveRelation(Request request, Endpoint endpoint, ScheduledThreadPoolExecutor executor) {
        this.request = request;
        this.endpoint = endpoint;
        this.orderer = new ObserveNotificationOrderer();
        this.reregistrationBackoffMillis = endpoint.getConfig().get(CoapConfig.NOTIFICATION_REREGISTRATION_BACKOFF, TimeUnit.MILLISECONDS);
        this.scheduler = executor;
        this.request.addMessageObserver(this.pendingRequestObserver);
        this.request.setProtectFromOffload();
    }

    public boolean reregister() {
        Request request = this.request;
        if (request.isCanceled()) {
            throw new IllegalStateException("observe request already canceled! token " + request.getTokenString());
        }
        Response response = this.current;
        if (response != null && !response.getOptions().hasObserve()) {
            throw new IllegalStateException("observe not supported by CoAP server!");
        }
        if (this.isCanceled()) {
            throw new IllegalStateException("observe already canceled!");
        }
        if (this.requestPending.compareAndSet(false, true)) {
            Request refresh = Request.newGet();
            EndpointContext destinationContext = response != null ? response.getSourceContext() : request.getDestinationContext();
            refresh.setDestinationContext(destinationContext);
            refresh.setToken(request.getToken());
            refresh.setOptions(request.getOptions());
            refresh.setMaxResourceBodySize(request.getMaxResourceBodySize());
            if (request.isUnintendedPayload()) {
                refresh.setUnintendedPayload();
                refresh.setPayload(request.getPayload());
            }
            for (MessageObserver observer : request.getMessageObservers()) {
                if (observer.isInternal()) continue;
                request.removeMessageObserver(observer);
                refresh.addMessageObserver(observer);
            }
            this.request = refresh;
            this.orderer = new ObserveNotificationOrderer();
            this.endpoint.sendRequest(refresh);
            return true;
        }
        return false;
    }

    private void sendCancelObserve() {
        this.proactiveCancel = false;
        Response response = this.current;
        Request request = this.request;
        EndpointContext destinationContext = response != null ? response.getSourceContext() : request.getDestinationContext();
        Request cancel = Request.newGet();
        cancel.setDestinationContext(destinationContext);
        cancel.setToken(request.getToken());
        cancel.setOptions(request.getOptions());
        cancel.setObserveCancel();
        cancel.setMaxResourceBodySize(request.getMaxResourceBodySize());
        if (request.isUnintendedPayload()) {
            cancel.setUnintendedPayload();
            cancel.setPayload(request.getPayload());
        }
        for (MessageObserver observer : request.getMessageObservers()) {
            if (observer.isInternal()) continue;
            request.removeMessageObserver(observer);
            cancel.addMessageObserver(observer);
        }
        this.request = cancel;
        this.endpoint.sendRequest(cancel);
    }

    private void cancel() {
        this.endpoint.cancelObservation(this.request.getToken());
        this.setCanceled(true);
    }

    public void proactiveCancel() {
        this.cancel();
        this.proactiveCancel = true;
        if (this.requestPending.compareAndSet(false, true)) {
            this.sendCancelObserve();
        }
    }

    public void reactiveCancel() {
        Request request = this.request;
        if (CoAP.isTcpScheme(request.getScheme())) {
            LOGGER.info("change to cancel the observe {} proactive over TCP.", (Object)request.getTokenString());
            this.proactiveCancel();
        } else {
            request.cancel();
            this.cancel();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Response getCurrentResponse() {
        return this.current;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
        if (this.canceled) {
            this.setReregistrationHandle(null);
        }
    }

    public boolean onResponse(Response response) {
        boolean isNew = false;
        if (null != response) {
            Integer observe = response.getOptions().getObserve();
            boolean prepareNext = observe != null && !this.isCanceled();
            isNew = this.orderer.isNew(response);
            if (isNew) {
                this.current = response;
                LOGGER.debug("Updated with {}", (Object)response);
            } else if (prepareNext) {
                boolean bl = prepareNext = this.orderer.getCurrent() == observe.intValue();
            }
            if (prepareNext) {
                this.prepareReregistration(response);
            } else if (observe == null && !this.isCanceled()) {
                this.cancel();
            }
        }
        return isNew;
    }

    public boolean matchRequest(Request request) {
        return this.request.getToken().equals(request.getToken());
    }

    private void setReregistrationHandle(ScheduledFuture<?> reregistrationHandle) {
        ScheduledFuture<?> previousHandle = this.reregistrationHandle.getAndSet(reregistrationHandle);
        if (previousHandle != null) {
            if (previousHandle instanceof Runnable) {
                this.scheduler.remove((Runnable)((Object)previousHandle));
            } else {
                previousHandle.cancel(false);
            }
        }
    }

    private void prepareReregistration(Response response) {
        long timeout = TimeUnit.SECONDS.toMillis(response.getOptions().getMaxAge()) + this.reregistrationBackoffMillis;
        ScheduledFuture<?> f = this.scheduler.schedule(this.reregister, timeout, TimeUnit.MILLISECONDS);
        this.setReregistrationHandle(f);
        LOGGER.debug("Wait for {}ms fresh notifies.", (Object)timeout);
    }
}

