/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.californium.core.server.resources.ResourceAttributes;
import org.eclipse.californium.elements.util.StringUtil;

public class WebLink
implements Comparable<WebLink> {
    private String uri;
    private final ResourceAttributes attributes;

    public WebLink(String uri) {
        this.uri = uri;
        this.attributes = new ResourceAttributes();
    }

    public String getURI() {
        return this.uri;
    }

    public ResourceAttributes getAttributes() {
        return this.attributes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('<');
        builder.append(this.uri);
        builder.append('>');
        ArrayList<String> attributes = new ArrayList<String>(this.attributes.getAttributeKeySet());
        List<String> standard = Arrays.asList("rt", "if", "ct", "sz", "obs");
        if (this.attributes.containsAttribute("title")) {
            builder.append(' ').append(this.attributes.getTitle());
        }
        this.append(builder, standard);
        attributes.remove("title");
        attributes.removeAll(standard);
        Collections.sort(attributes);
        this.append(builder, attributes);
        return builder.toString();
    }

    private void append(StringBuilder builder, List<String> attributes) {
        for (String attribute : attributes) {
            this.append(builder, attribute);
        }
    }

    private void append(StringBuilder builder, String attributeName) {
        if (this.attributes.containsAttribute(attributeName)) {
            builder.append(StringUtil.lineSeparator()).append("\t").append(attributeName);
            List<String> values = this.attributes.getAttributeValues(attributeName);
            if (values.size() == 1) {
                builder.append(":\t").append(values.get(0));
            } else if (values.size() > 1) {
                builder.append(":\t").append(values);
            }
        }
    }

    @Override
    public int compareTo(WebLink other) {
        return this.uri.compareTo(other.getURI());
    }

    public static WebLink findByUri(Collection<WebLink> links, String uri) {
        for (WebLink link : links) {
            if (!link.getURI().equals(uri)) continue;
            return link;
        }
        return null;
    }
}

