/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.CleanupMessageObserver;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoPublicAPI
public class NoResponseCleanupMessageObserver
extends CleanupMessageObserver {
    static final Logger LOGGER = LoggerFactory.getLogger(NoResponseCleanupMessageObserver.class);
    private final ScheduledExecutorService scheduledExecutor;
    private final long lifetime;
    private volatile ScheduledFuture<?> cleanup;

    public NoResponseCleanupMessageObserver(Exchange exchange, ScheduledExecutorService scheduledExecutor, long lifetime) {
        super(exchange);
        this.scheduledExecutor = scheduledExecutor;
        this.lifetime = lifetime;
        LOGGER.debug("no-response observer");
    }

    @Override
    public void onSent(boolean retransmission) {
        LOGGER.debug("no-response sent");
        if (!retransmission) {
            this.cleanup = this.scheduledExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    NoResponseCleanupMessageObserver.this.exchange.execute(new Runnable(){

                        @Override
                        public void run() {
                            LOGGER.debug("no-response-timeout");
                            NoResponseCleanupMessageObserver.this.exchange.getRequest().setTimedOut(true);
                        }
                    });
                }
            }, this.lifetime, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected void complete(String action) {
        ScheduledFuture<?> cleanup = this.cleanup;
        if (cleanup != null) {
            cleanup.cancel(false);
        }
        super.complete(action);
    }
}

