/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.Definitions;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.BasicListDefinition;
import org.eclipse.californium.elements.config.DocumentedDefinition;
import org.eclipse.californium.elements.config.PropertiesUtility;
import org.eclipse.californium.elements.config.TimeDefinition;
import org.eclipse.californium.elements.config.ValueException;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Configuration {
    public static final String DEFAULT_FILE_NAME = "Californium3.properties";
    public static final File DEFAULT_FILE = new File("Californium3.properties");
    public static final String DEFAULT_HEADER = "Californium3 CoAP Properties file";
    private static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    private static final ConcurrentMap<String, DefinitionsProvider> DEFAULT_MODULES = new ConcurrentHashMap<String, DefinitionsProvider>();
    private static final Definitions<DocumentedDefinition<?>> DEFAULT_DEFINITIONS = new Definitions("Configuration");
    private static Configuration standard;
    private final ConcurrentMap<String, DefinitionsProvider> modules;
    private final Definitions<DocumentedDefinition<?>> definitions;
    private final Map<String, Object> values = new HashMap<String, Object>();
    private final Set<String> transientValues = new HashSet<String>();

    private static boolean addModule(ConcurrentMap<String, DefinitionsProvider> modules, ModuleDefinitionsProvider definitionsProvider) {
        if (modules == null) {
            throw new NullPointerException("Modules must not be null!");
        }
        if (definitionsProvider == null) {
            throw new NullPointerException("DefinitionsProvider must not be null!");
        }
        String module = definitionsProvider.getModule();
        if (module == null) {
            throw new IllegalArgumentException("DefinitionsProvider's module must not be null!");
        }
        if (module.isEmpty()) {
            throw new IllegalArgumentException("DefinitionsProvider's module name must not be empty!");
        }
        DefinitionsProvider previous = modules.putIfAbsent(module, definitionsProvider);
        if (previous != null && previous != definitionsProvider) {
            throw new IllegalArgumentException("Module " + module + " already registered with different provider!");
        }
        return previous == null;
    }

    public static void addDefaultModule(ModuleDefinitionsProvider definitionsProvider) {
        if (Configuration.addModule(DEFAULT_MODULES, definitionsProvider)) {
            LOGGER.info("defaults added {}", (Object)definitionsProvider.getModule());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getStandard() {
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (standard == null) {
                Configuration.createStandardWithFile(DEFAULT_FILE);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return standard;
        }
    }

    public static void setStandard(Configuration standard) {
        Configuration.standard = standard;
    }

    public static Configuration createStandardWithoutFile() {
        LOGGER.info("Creating standard configuration properties without a file");
        standard = new Configuration();
        return standard;
    }

    public static Configuration createStandardFromStream(InputStream inStream) {
        standard = Configuration.createFromStream(inStream, null);
        return standard;
    }

    public static Configuration createFromStream(InputStream inStream, DefinitionsProvider customProvider) {
        LOGGER.info("Creating configuration properties from stream");
        Configuration configuration = new Configuration();
        configuration.apply(customProvider);
        try {
            configuration.load(inStream);
        }
        catch (IOException e) {
            LOGGER.warn("cannot load properties from stream: {}", (Object)e.getMessage());
        }
        return configuration;
    }

    public static Configuration createStandardWithFile(File file) {
        standard = Configuration.createWithFile(file, DEFAULT_HEADER, null);
        return standard;
    }

    public static Configuration createWithFile(File file, String header, DefinitionsProvider customProvider) {
        if (file == null) {
            throw new NullPointerException("file must not be null!");
        }
        Configuration configuration = new Configuration();
        configuration.apply(customProvider);
        if (file.exists()) {
            configuration.load(file);
        } else {
            configuration.store(file, header);
        }
        return configuration;
    }

    public Configuration() {
        this.definitions = DEFAULT_DEFINITIONS;
        this.modules = DEFAULT_MODULES;
        this.applyModules();
    }

    public Configuration(Configuration config) {
        this.definitions = DEFAULT_DEFINITIONS == config.definitions ? DEFAULT_DEFINITIONS : new Definitions(config.definitions);
        this.modules = DEFAULT_MODULES == config.modules ? DEFAULT_MODULES : new ConcurrentHashMap<String, DefinitionsProvider>(config.modules);
        this.transientValues.addAll(config.transientValues);
        this.values.putAll(config.values);
    }

    public Configuration(ModuleDefinitionsProvider ... providers) {
        this.definitions = new Definitions("Configuration");
        this.modules = new ConcurrentHashMap<String, DefinitionsProvider>();
        for (ModuleDefinitionsProvider provider : providers) {
            if (!Configuration.addModule(this.modules, provider)) continue;
            LOGGER.trace("added {}", (Object)provider.getModule());
        }
        this.applyModules();
    }

    private void applyModules() {
        for (DefinitionsProvider handler : this.modules.values()) {
            handler.applyDefinitions(this);
        }
    }

    private void apply(DefinitionsProvider customProvider) {
        if (customProvider != null) {
            HashSet before = new HashSet(this.modules.keySet());
            customProvider.applyDefinitions(this);
            if (before.size() < this.modules.size()) {
                Set set = this.modules.keySet();
                set.removeAll(before);
                for (String newModule : set) {
                    LOGGER.warn("Add missing module {}", (Object)newModule);
                    ((DefinitionsProvider)this.modules.get(newModule)).applyDefinitions(this);
                }
                customProvider.applyDefinitions(this);
            }
        }
    }

    public void load(File file) {
        if (file == null) {
            throw new NullPointerException("file must not be null");
        }
        LOGGER.info("loading properties from file {}", (Object)file.getAbsolutePath());
        try (FileInputStream inStream = new FileInputStream(file);){
            this.load(inStream);
        }
        catch (IOException e) {
            LOGGER.warn("cannot load properties from file {}: {}", (Object)file.getAbsolutePath(), (Object)e.getMessage());
        }
    }

    public void load(InputStream inStream) throws IOException {
        if (inStream == null) {
            throw new NullPointerException("input stream must not be null");
        }
        Properties properties = new Properties();
        properties.load(inStream);
        this.add(properties);
    }

    public void add(Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties must not be null!");
        }
        for (Object k : properties.keySet()) {
            if (!(k instanceof String)) continue;
            String key = (String)k;
            DocumentedDefinition<?> definition = this.definitions.get(key);
            if (definition == null) {
                LOGGER.warn("Ignore {}, no configuration definition available!", (Object)key);
                continue;
            }
            if (this.transientValues.contains(key)) {
                LOGGER.info("Ignore {}, definition set transient!", (Object)key);
                continue;
            }
            String text = properties.getProperty(key);
            Object value = this.loadValue(definition, text);
            this.values.put(key, value);
        }
    }

    public void add(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            throw new NullPointerException("dictionary must not be null!");
        }
        Enumeration<String> allKeys = dictionary.keys();
        while (allKeys.hasMoreElements()) {
            String key = allKeys.nextElement();
            Object value = dictionary.get(key);
            DocumentedDefinition<?> definition = this.definitions.get(key);
            if (definition == null) {
                LOGGER.warn("Ignore {}, no configuration definition available!", (Object)key);
                continue;
            }
            if (this.transientValues.contains(key)) {
                LOGGER.info("Ignore {}, definition set transient!", (Object)key);
                continue;
            }
            if (value instanceof String) {
                String text = (String)value;
                value = this.loadValue(definition, text);
            } else if (value != null) {
                if (!definition.isAssignableFrom(value)) {
                    LOGGER.warn("{} is not a {}!", (Object)value.getClass().getSimpleName(), (Object)definition.getTypeName());
                    value = null;
                }
                try {
                    value = definition.checkRawValue(value);
                }
                catch (ValueException e) {
                    value = null;
                }
            }
            this.values.put(key, value);
        }
    }

    private Object loadValue(DocumentedDefinition<?> definition, String text) {
        Object value = null;
        if (text != null && !(text = text.trim()).isEmpty()) {
            try {
                value = definition.readValue(text);
            }
            catch (RuntimeException ex) {
                LOGGER.warn("{}", (Object)ex.getMessage());
                value = null;
            }
        }
        return value;
    }

    public void store(File file) {
        this.store(file, DEFAULT_HEADER);
    }

    public void store(File file, String header) {
        if (file == null) {
            throw new NullPointerException("file must not be null");
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            this.store(out, header, file.getAbsolutePath());
        }
        catch (IOException e) {
            LOGGER.warn("cannot write properties to {}: {}", (Object)file.getAbsolutePath(), (Object)e.getMessage());
        }
    }

    public void store(OutputStream out, String header, String resourceName) {
        if (out == null) {
            throw new NullPointerException("output stream must not be null!");
        }
        if (header == null) {
            throw new NullPointerException("header must not be null!");
        }
        if (resourceName != null) {
            LOGGER.info("writing properties to {}", (Object)resourceName);
        }
        try {
            Set modules = this.modules.keySet();
            ArrayList<String> generalKeys = new ArrayList<String>();
            ArrayList<String> moduleKeys = new ArrayList<String>();
            for (String key : this.values.keySet()) {
                if (this.transientValues.contains(key)) continue;
                boolean add = true;
                for (String head : modules) {
                    if (!key.startsWith(head)) continue;
                    moduleKeys.add(key);
                    add = false;
                    break;
                }
                if (!add) continue;
                generalKeys.add(key);
            }
            Collections.sort(generalKeys);
            Collections.sort(moduleKeys);
            try (OutputStreamWriter fileWriter = new OutputStreamWriter(out);){
                String line = PropertiesUtility.normalizeComments(header);
                fileWriter.write(line);
                fileWriter.write(StringUtil.lineSeparator());
                line = PropertiesUtility.normalizeComments(new Date().toString());
                fileWriter.write(line);
                fileWriter.write(StringUtil.lineSeparator());
                fileWriter.write("#");
                fileWriter.write(StringUtil.lineSeparator());
                for (String key : generalKeys) {
                    this.writeProperty(key, fileWriter);
                }
                for (String key : moduleKeys) {
                    this.writeProperty(key, fileWriter);
                }
            }
        }
        catch (IOException e) {
            if (resourceName != null) {
                LOGGER.warn("cannot write properties to {}: {}", (Object)resourceName, (Object)e.getMessage());
            }
            LOGGER.warn("cannot write properties: {}", (Object)e.getMessage());
        }
    }

    private void writeProperty(String key, Writer writer) throws IOException {
        String defaultText;
        Object defaultValue;
        DocumentedDefinition<?> definition = this.definitions.get(key);
        if (definition == null) {
            throw new IllegalArgumentException("Definition for " + key + " not found!");
        }
        StringBuilder documentation = new StringBuilder();
        String docu = definition.getDocumentation();
        if (docu != null) {
            documentation.append(docu);
        }
        if ((defaultValue = definition.getDefaultValue()) != null && (defaultText = definition.write(defaultValue)) != null) {
            if (documentation.length() > 0) {
                documentation.append('\n');
            }
            documentation.append("Default: ").append(defaultText);
        }
        if (documentation.length() > 0) {
            String line = PropertiesUtility.normalizeComments(documentation.toString());
            writer.write(line);
            writer.write(StringUtil.lineSeparator());
        }
        String encoded = PropertiesUtility.normalize(key, true);
        writer.write(encoded);
        writer.write(61);
        Object value = this.values.get(key);
        if (value != null) {
            encoded = PropertiesUtility.normalize(definition.write(value), false);
            writer.write(encoded);
        }
        writer.write(StringUtil.lineSeparator());
    }

    public <T> Configuration setTransient(DocumentedDefinition<T> definition) {
        if (definition == null) {
            throw new NullPointerException("Definition must not be null!");
        }
        this.transientValues.add(definition.getKey());
        return this;
    }

    public <T> Configuration setFromText(DocumentedDefinition<T> definition, String value) {
        this.setInternal(definition, null, value);
        return this;
    }

    public <T> String getAsText(DocumentedDefinition<T> definition) {
        T value = this.getInternal(definition);
        return definition.writeValue(value);
    }

    public <T> Configuration set(BasicDefinition<T> definition, T value) {
        this.setInternal(definition, value, null);
        return this;
    }

    public <T> Configuration setAsList(BasicListDefinition<T> definition, T ... values) {
        if (values == null) {
            throw new NullPointerException("Values must not be null!");
        }
        this.setInternal(definition, Arrays.asList(values), null);
        return this;
    }

    public <T> Configuration setAsListFromText(BasicListDefinition<T> definition, String ... values) {
        if (values == null) {
            throw new NullPointerException("Values must not be null!");
        }
        if (values.length > 0) {
            StringBuffer all = new StringBuffer();
            for (String value : values) {
                all.append(value).append(",");
            }
            int len = all.length();
            if (len > 0) {
                all.setLength(len - 1);
            }
            this.setInternal(definition, null, all.toString());
        } else {
            List empty = Collections.emptyList();
            this.setInternal(definition, empty, null);
        }
        return this;
    }

    public <T> T get(BasicDefinition<T> definition) {
        return this.getInternal(definition);
    }

    public Configuration set(TimeDefinition definition, Long value, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit must not be null");
        }
        if (value != null) {
            value = TimeUnit.NANOSECONDS.convert(value, unit);
        }
        this.setInternal(definition, value, null);
        return this;
    }

    public Configuration set(TimeDefinition definition, int value, TimeUnit unit) {
        return this.set(definition, Long.valueOf(value), unit);
    }

    public Long get(TimeDefinition definition, TimeUnit unit) {
        Long time = this.getInternal(definition);
        if (unit == null) {
            throw new NullPointerException("unit must not be null");
        }
        if (time != null) {
            time = unit.convert(time, TimeUnit.NANOSECONDS);
        }
        return time;
    }

    public int getTimeAsInt(TimeDefinition definition, TimeUnit unit) {
        Long time = this.get(definition, unit);
        if (time != null) {
            if (time > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(time + " doesn't fit to int (Max. " + Integer.MAX_VALUE + ")!");
            }
            if (time < Integer.MIN_VALUE) {
                throw new IllegalArgumentException(time + " doesn't fit to int (Min. " + Integer.MIN_VALUE + ")!");
            }
            return time.intValue();
        }
        return 0;
    }

    private <T> T getInternal(DocumentedDefinition<T> definition) {
        if (definition == null) {
            throw new NullPointerException("definition must not be null");
        }
        DocumentedDefinition<?> def = this.definitions.get(definition.getKey());
        if (def != null && def != definition) {
            throw new IllegalArgumentException("Definition " + definition + " doesn't match " + def);
        }
        Object value = this.values.get(definition.getKey());
        if (value == null) {
            return definition.getDefaultValue();
        }
        return (T)value;
    }

    private <T> void setInternal(DocumentedDefinition<T> definition, T value, String text) {
        if (definition == null) {
            throw new NullPointerException("definition must not be null");
        }
        DocumentedDefinition<T> def = this.definitions.addIfAbsent(definition);
        if (def != null && def != definition) {
            throw new IllegalArgumentException("Definition " + definition + " doesn't match " + def);
        }
        if (value == null && text != null) {
            value = definition.readValue(text);
        } else {
            if (value != null && !definition.isAssignableFrom(value)) {
                throw new IllegalArgumentException(value.getClass().getSimpleName() + " is not a " + definition.getTypeName());
            }
            try {
                value = definition.checkValue(value);
            }
            catch (ValueException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
        this.values.put(definition.getKey(), value);
    }

    public static interface ModuleDefinitionsProvider
    extends DefinitionsProvider {
        public String getModule();
    }

    public static interface DefinitionsProvider {
        public void applyDefinitions(Configuration var1);
    }
}

