/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import org.eclipse.californium.scandium.dtls.cipher.CCMBlockCipher;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;

public class AeadBlockCipher {
    public static final String AES_CCM = "AES/CCM";

    public static final boolean isSupported(String transformation, int keyLength) {
        block4: {
            try {
                int keyLengthBits = keyLength * 8;
                if (AES_CCM.equals(transformation)) {
                    if (CCMBlockCipher.isSupported()) {
                        return keyLengthBits <= CCMBlockCipher.getMaxAllowedKeyLength();
                    }
                    break block4;
                }
                Cipher cipher = Cipher.getInstance(transformation);
                return keyLengthBits <= Cipher.getMaxAllowedKeyLength(cipher.getAlgorithm());
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
        }
        return false;
    }

    public static final byte[] decrypt(CipherSuite cipherSuite, SecretKey key, byte[] nonce, byte[] additionalData, byte[] crypted, int cryptedOffset, int cryptedLength) throws GeneralSecurityException {
        if (AES_CCM.equals(cipherSuite.getTransformation())) {
            return CCMBlockCipher.decrypt(key, nonce, additionalData, crypted, cryptedOffset, cryptedLength, cipherSuite.getMacLength());
        }
        return AeadBlockCipher.jreDecrypt(cipherSuite, key, nonce, additionalData, crypted, cryptedOffset, cryptedLength);
    }

    public static final byte[] encrypt(CipherSuite cipherSuite, SecretKey key, byte[] nonce, byte[] additionalData, byte[] message) throws GeneralSecurityException {
        if (AES_CCM.equals(cipherSuite.getTransformation())) {
            return CCMBlockCipher.encrypt(cipherSuite.getRecordIvLength(), key, nonce, additionalData, message, cipherSuite.getMacLength());
        }
        return AeadBlockCipher.jreEncrypt(cipherSuite.getRecordIvLength(), cipherSuite, key, nonce, additionalData, message);
    }

    private static final byte[] jreDecrypt(CipherSuite suite, SecretKey key, byte[] nonce, byte[] additionalData, byte[] crypted, int cryptedOffset, int cryptedLength) throws GeneralSecurityException {
        Cipher cipher = suite.getThreadLocalCipher();
        GCMParameterSpec parameterSpec = new GCMParameterSpec(suite.getMacLength() * 8, nonce);
        cipher.init(2, (Key)key, parameterSpec);
        cipher.updateAAD(additionalData);
        return cipher.doFinal(crypted, cryptedOffset, cryptedLength);
    }

    private static final byte[] jreEncrypt(int outputOffset, CipherSuite suite, SecretKey key, byte[] nonce, byte[] additionalData, byte[] message) throws GeneralSecurityException {
        Cipher cipher = suite.getThreadLocalCipher();
        GCMParameterSpec parameterSpec = new GCMParameterSpec(suite.getMacLength() * 8, nonce);
        cipher.init(1, (Key)key, parameterSpec);
        cipher.updateAAD(additionalData);
        int length = cipher.getOutputSize(message.length);
        byte[] result = new byte[length + outputOffset];
        cipher.doFinal(message, 0, message.length, result, outputOffset);
        return result;
    }
}

