/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HelloExtension;

public final class HelloExtensions {
    public static final int OVERALL_LENGTH_BITS = 16;
    private final List<HelloExtension> extensions = new ArrayList<HelloExtension>();

    boolean isEmpty() {
        return this.extensions.isEmpty();
    }

    public int getLength() {
        if (this.extensions.isEmpty()) {
            return 0;
        }
        return this.getExtensionsLength() + 2;
    }

    public int getExtensionsLength() {
        int length = 0;
        for (HelloExtension extension : this.extensions) {
            length += extension.getLength();
        }
        return length;
    }

    public void addExtension(HelloExtension extension) {
        if (extension != null) {
            if (this.getExtension(extension.getType()) == null) {
                this.extensions.add(extension);
            } else {
                throw new IllegalArgumentException("Hello Extension of type " + (Object)((Object)extension.getType()) + " already added!");
            }
        }
    }

    public <T extends HelloExtension> T getExtension(HelloExtension.ExtensionType type) {
        if (type == null) {
            throw new NullPointerException("Extension type must not be null!");
        }
        HelloExtension replacement = null;
        for (HelloExtension ext : this.extensions) {
            if (type.equals((Object)ext.getType())) {
                return (T)ext;
            }
            if (!type.equals((Object)ext.getType().getReplacementType())) continue;
            replacement = ext;
        }
        return (T)replacement;
    }

    public List<HelloExtension> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        String indentation = StringUtil.indentation(indent);
        sb.append(indentation).append("Extensions Length: ").append(this.getExtensionsLength()).append(" bytes").append(StringUtil.lineSeparator());
        for (HelloExtension ext : this.extensions) {
            sb.append(ext.toString(indent + 1));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    public void writeTo(DatagramWriter writer) {
        if (!this.extensions.isEmpty()) {
            writer.write(this.getExtensionsLength(), 16);
            for (HelloExtension extension : this.extensions) {
                extension.writeTo(writer);
            }
        }
    }

    public void readFrom(DatagramReader reader) throws HandshakeException {
        if (reader.bytesAvailable()) {
            try {
                int length = reader.read(16);
                DatagramReader rangeReader = reader.createRangeReader(length);
                while (rangeReader.bytesAvailable()) {
                    HelloExtension extension = HelloExtension.readFrom(rangeReader);
                    if (extension == null) continue;
                    if (this.getExtension(extension.getType()) == null) {
                        this.addExtension(extension);
                        continue;
                    }
                    throw new HandshakeException("Hello message contains extension " + (Object)((Object)extension.getType()) + " more than once!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.DECODE_ERROR));
                }
            }
            catch (IllegalArgumentException ex) {
                throw new HandshakeException("Hello message contained malformed extensions, " + ex.getMessage(), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.DECODE_ERROR));
            }
        }
    }

    public static HelloExtensions fromReader(DatagramReader reader) throws HandshakeException {
        HelloExtensions extensions = new HelloExtensions();
        extensions.readFrom(reader);
        return extensions;
    }
}

