/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.security.auth.Destroyable;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.JceProviderUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.cipher.RandomManager;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalKeyAgreement;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalKeyFactory;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalKeyPairGenerator;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XECDHECryptography
implements Destroyable {
    @Deprecated
    protected static final Logger LOGGER = LoggerFactory.getLogger(XECDHECryptography.class);
    private static final String EC_KEYPAIR_GENERATOR_ALGORITHM = "EC";
    private static final ThreadLocalKeyPairGenerator EC_KEYPAIR_GENERATOR;
    private static final String XDH_KEYPAIR_GENERATOR_ALGORITHM = "XDH";
    private static final ThreadLocalKeyPairGenerator XDH_KEYPAIR_GENERATOR;
    private static final String EC_KEY_FACTORY_ALGORITHM = "EC";
    private static final ThreadLocalKeyFactory EC_KEY_FACTORY;
    private static final String XDH_KEY_FACTORY_ALGORITHM = "XDH";
    public static final ThreadLocalKeyFactory XDH_KEY_FACTORY;
    private static final String ECDH_KEY_AGREEMENT_ALGORITHM = "ECDH";
    private static final ThreadLocalKeyAgreement ECDH_KEY_AGREEMENT;
    private static final String XDH_KEY_AGREEMENT_ALGORITHM = "XDH";
    private static final ThreadLocalKeyAgreement XDH_KEY_AGREEMENT;
    private static volatile XDHPublicKeyApi xDHPublicKeyApi;
    private static final Map<Integer, SupportedGroup> EC_CURVE_MAP_BY_ID;
    private static final Map<EllipticCurve, SupportedGroup> EC_CURVE_MAP_BY_CURVE;
    private final SupportedGroup supportedGroup;
    private PrivateKey privateKey;
    private final PublicKey publicKey;
    private final byte[] encodedPoint;

    public XECDHECryptography(SupportedGroup supportedGroup) throws GeneralSecurityException {
        KeyPair keyPair;
        if (supportedGroup.getAlgorithmName().equals("EC")) {
            KeyPairGenerator keyPairGenerator = (KeyPairGenerator)EC_KEYPAIR_GENERATOR.currentWithCause();
            ECGenParameterSpec params = new ECGenParameterSpec(supportedGroup.name());
            keyPairGenerator.initialize(params, RandomManager.currentSecureRandom());
            keyPair = keyPairGenerator.generateKeyPair();
        } else if (supportedGroup.getAlgorithmName().equals("XDH")) {
            KeyPairGenerator keyPairGenerator = (KeyPairGenerator)XDH_KEYPAIR_GENERATOR.currentWithCause();
            ECGenParameterSpec params = new ECGenParameterSpec(supportedGroup.name());
            keyPairGenerator.initialize(params, RandomManager.currentSecureRandom());
            keyPair = keyPairGenerator.generateKeyPair();
        } else {
            throw new GeneralSecurityException(supportedGroup.name() + " not supported by KeyPairGenerator!");
        }
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
        this.supportedGroup = supportedGroup;
        this.encodedPoint = supportedGroup.encodedPoint(this.publicKey);
        this.check("OUT: ", this.publicKey, this.encodedPoint);
    }

    PublicKey getPublicKey() {
        return this.publicKey;
    }

    public SupportedGroup getSupportedGroup() {
        return this.supportedGroup;
    }

    public byte[] getEncodedPoint() {
        return this.encodedPoint;
    }

    public SecretKey generateSecret(byte[] encodedPoint) throws GeneralSecurityException {
        if (this.privateKey == null) {
            throw new IllegalStateException("private key must not be destroyed");
        }
        PublicKey peersPublicKey = this.supportedGroup.decodedPoint(encodedPoint);
        KeyAgreement keyAgreement = null;
        if (this.supportedGroup.getAlgorithmName().equals("EC")) {
            keyAgreement = (KeyAgreement)ECDH_KEY_AGREEMENT.currentWithCause();
        } else if (xDHPublicKeyApi != null && this.supportedGroup.getAlgorithmName().equals("XDH")) {
            keyAgreement = (KeyAgreement)XDH_KEY_AGREEMENT.currentWithCause();
        } else {
            throw new GeneralSecurityException(this.supportedGroup.name() + " not supported by JCE!");
        }
        this.check("IN: ", peersPublicKey, encodedPoint);
        try {
            keyAgreement.init(this.privateKey);
            keyAgreement.doPhase(peersPublicKey, true);
            byte[] secret = keyAgreement.generateSecret();
            SecretKey secretKey = SecretUtil.create(secret, "TlsPremasterSecret");
            Bytes.clear(secret);
            return secretKey;
        }
        catch (InvalidKeyException ex) {
            LOGGER.warn("Fail: {} {}", (Object)this.supportedGroup.name(), (Object)ex.getMessage());
            throw ex;
        }
    }

    @Override
    public void destroy() {
        this.privateKey = null;
    }

    @Override
    public boolean isDestroyed() {
        return this.privateKey == null;
    }

    private void check(String tag, PublicKey publicKey, byte[] point) throws GeneralSecurityException {
        if (LOGGER.isDebugEnabled()) {
            byte[] asn1 = publicKey.getEncoded();
            String s1 = StringUtil.byteArray2Hex(asn1);
            String s2 = StringUtil.byteArray2Hex(point);
            if (s2.length() < s1.length()) {
                s2 = String.format("%" + s1.length() + "s", s2);
            }
            LOGGER.debug("{}ASN1 encoded '{}'", (Object)tag, (Object)s1);
            LOGGER.debug("{}DHE  encoded '{}'", (Object)tag, (Object)s2);
            for (int index = 0; index < point.length; ++index) {
                if (point[point.length - index - 1] == asn1[asn1.length - index - 1]) continue;
                throw new GeneralSecurityException("DHE: failed to encoded point! " + this.supportedGroup.name() + ", position: " + index);
            }
        }
    }

    public static void setXDHPublicKeyApi(XDHPublicKeyApi api) {
        xDHPublicKeyApi = api;
    }

    static {
        JceProviderUtil.init();
        EC_KEYPAIR_GENERATOR = new ThreadLocalKeyPairGenerator("EC");
        XDH_KEYPAIR_GENERATOR = new ThreadLocalKeyPairGenerator("XDH");
        EC_KEY_FACTORY = new ThreadLocalKeyFactory("EC");
        XDH_KEY_FACTORY = new ThreadLocalKeyFactory("XDH");
        ECDH_KEY_AGREEMENT = new ThreadLocalKeyAgreement(ECDH_KEY_AGREEMENT_ALGORITHM);
        XDH_KEY_AGREEMENT = new ThreadLocalKeyAgreement("XDH");
        xDHPublicKeyApi = XDHPublicKeyReflection.init();
        EC_CURVE_MAP_BY_ID = new HashMap<Integer, SupportedGroup>();
        EC_CURVE_MAP_BY_CURVE = new HashMap<EllipticCurve, SupportedGroup>();
    }

    public static interface XDHPublicKeyApi {
        public boolean isSupporting(PublicKey var1);

        public String getCurveName(PublicKey var1) throws GeneralSecurityException;
    }

    public static enum SupportedGroup {
        sect163k1(1, false),
        sect163r1(2, false),
        sect163r2(3, false),
        sect193r1(4, false),
        sect193r2(5, false),
        sect233k1(6, false),
        sect233r1(7, false),
        sect239k1(8, false),
        sect283k1(9, false),
        sect283r1(10, false),
        sect409k1(11, false),
        sect409r1(12, false),
        sect571k1(13, false),
        sect571r1(14, false),
        secp160k1(15, false),
        secp160r1(16, false),
        secp160r2(17, false),
        secp192k1(18, false),
        secp192r1(19, false),
        secp224k1(20, false),
        secp224r1(21, false),
        secp256k1(22, false),
        secp256r1(23, true),
        secp384r1(24, true),
        secp521r1(25, false),
        brainpoolP256r1(26, false),
        brainpoolP384r1(27, false),
        brainpoolP512r1(28, false),
        X25519(29, 32, "XDH", true),
        X448(30, 56, "XDH", true),
        ffdhe2048(256, false),
        ffdhe3072(257, false),
        ffdhe4096(258, false),
        ffdhe6144(259, false),
        ffdhe8192(260, false),
        arbitrary_explicit_prime_curves(65281, false),
        arbitrary_explicit_char2_curves(65282, false);

        private final int id;
        private final String algorithmName;
        private final int keySizeInBytes;
        private final int encodedPointSizeInBytes;
        private final boolean usable;
        private final boolean recommended;
        private final byte[] asn1header;
        private final ThreadLocalKeyFactory keyFactory;

        private SupportedGroup(int code, boolean recommended) {
            this.id = code;
            this.algorithmName = "EC";
            this.recommended = recommended;
            EllipticCurve curve = null;
            int keySize = 0;
            int publicKeySize = 0;
            byte[] header = null;
            try {
                KeyPairGenerator keyPairGenerator = (KeyPairGenerator)EC_KEYPAIR_GENERATOR.currentWithCause();
                ECGenParameterSpec genParams = new ECGenParameterSpec(this.name());
                keyPairGenerator.initialize(genParams, RandomManager.currentSecureRandom());
                ECPublicKey publicKey = (ECPublicKey)keyPairGenerator.generateKeyPair().getPublic();
                curve = publicKey.getParams().getCurve();
                keySize = (curve.getField().getFieldSize() + 8 - 1) / 8;
                publicKeySize = keySize * 2 + 1;
                EC_CURVE_MAP_BY_CURVE.put(curve, this);
                header = publicKey.getEncoded();
                header = Arrays.copyOf(header, header.length - publicKeySize);
            }
            catch (Throwable e) {
                LOGGER.trace("Group [{}] is not supported by JCE! {}", (Object)this.name(), (Object)e.getMessage());
                curve = null;
            }
            this.keySizeInBytes = keySize;
            this.encodedPointSizeInBytes = publicKeySize;
            this.asn1header = header;
            this.usable = curve != null;
            this.keyFactory = EC_KEY_FACTORY;
            EC_CURVE_MAP_BY_ID.put(code, this);
        }

        private SupportedGroup(int code, int keySizeInBytes, String algorithmName, boolean recommended) {
            this.id = code;
            this.algorithmName = algorithmName;
            this.keySizeInBytes = keySizeInBytes;
            this.encodedPointSizeInBytes = keySizeInBytes;
            this.recommended = recommended;
            byte[] header = null;
            boolean usable = false;
            try {
                KeyPairGenerator keyPairGenerator = (KeyPairGenerator)XDH_KEYPAIR_GENERATOR.currentWithCause();
                ECGenParameterSpec params = new ECGenParameterSpec(this.name());
                keyPairGenerator.initialize(params, RandomManager.currentSecureRandom());
                PublicKey publicKey = keyPairGenerator.generateKeyPair().getPublic();
                header = publicKey.getEncoded();
                header = Arrays.copyOf(header, header.length - keySizeInBytes);
                usable = true;
            }
            catch (Throwable e) {
                LOGGER.trace("Group [{}] is not supported by JCE! {}", (Object)this.name(), (Object)e.getMessage());
            }
            this.usable = usable;
            this.asn1header = header;
            this.keyFactory = XDH_KEY_FACTORY;
            EC_CURVE_MAP_BY_ID.put(code, this);
        }

        public int getId() {
            return this.id;
        }

        public String getAlgorithmName() {
            return this.algorithmName;
        }

        public byte[] encodedPoint(PublicKey publicKey) throws GeneralSecurityException {
            if (publicKey == null) {
                throw new NullPointerException("public key must not be null!");
            }
            byte[] result = publicKey.getEncoded();
            if (result == null) {
                throw new GeneralSecurityException(this.name() + " not supported!");
            }
            return Arrays.copyOfRange(result, this.asn1header.length, result.length);
        }

        public PublicKey decodedPoint(byte[] encodedPoint) throws GeneralSecurityException {
            if (encodedPoint == null) {
                throw new NullPointerException("encoded point must not be null!");
            }
            if (this.encodedPointSizeInBytes != encodedPoint.length) {
                throw new IllegalArgumentException("encoded point must have " + this.encodedPointSizeInBytes + " bytes, not " + encodedPoint.length + "!");
            }
            byte[] encodedKey = Bytes.concatenate(this.asn1header, encodedPoint);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
            KeyFactory factory = (KeyFactory)this.keyFactory.currentWithCause();
            return factory.generatePublic(keySpec);
        }

        public static SupportedGroup fromId(int id) {
            return (SupportedGroup)((Object)EC_CURVE_MAP_BY_ID.get(id));
        }

        public static SupportedGroup fromPublicKey(PublicKey publicKey) {
            if (publicKey != null) {
                if (publicKey instanceof ECPublicKey) {
                    ECParameterSpec params = ((ECPublicKey)publicKey).getParams();
                    return (SupportedGroup)((Object)EC_CURVE_MAP_BY_CURVE.get(params.getCurve()));
                }
                if (xDHPublicKeyApi != null && xDHPublicKeyApi.isSupporting(publicKey)) {
                    try {
                        String name = xDHPublicKeyApi.getCurveName(publicKey);
                        return SupportedGroup.valueOf(name);
                    }
                    catch (GeneralSecurityException name) {}
                } else {
                    String algorithm = publicKey.getAlgorithm();
                    String oid = JceProviderUtil.getEdDsaStandardAlgorithmName(algorithm, null);
                    if ("OID.1.3.101.112".equals(oid) || "EdDSA".equalsIgnoreCase(oid)) {
                        return X25519;
                    }
                    if ("OID.1.3.101.113".equals(oid)) {
                        return X448;
                    }
                    LOGGER.warn("No supported curve {}/{}", (Object)publicKey.getAlgorithm(), (Object)oid);
                }
            }
            return null;
        }

        public static boolean isEcPublicKey(PublicKey publicKey) {
            if (publicKey instanceof ECPublicKey) {
                return true;
            }
            return xDHPublicKeyApi != null && xDHPublicKeyApi.isSupporting(publicKey);
        }

        public static boolean isSupported(List<SupportedGroup> list, List<X509Certificate> certificateChain) {
            for (X509Certificate certificate : certificateChain) {
                SupportedGroup group;
                PublicKey publicKey = certificate.getPublicKey();
                if (!SupportedGroup.isEcPublicKey(publicKey) || (group = SupportedGroup.fromPublicKey(publicKey)) != null && group.isUsable() && list.contains((Object)group)) continue;
                return false;
            }
            return true;
        }

        public int getKeySizeInBytes() {
            return this.keySizeInBytes;
        }

        public int getEncodedPointSizeInBytes() {
            return this.encodedPointSizeInBytes;
        }

        public boolean isUsable() {
            return this.usable;
        }

        public boolean isRecommended() {
            return this.recommended;
        }

        public static List<SupportedGroup> getUsableGroups() {
            return Initialize.USABLE_GROUPS;
        }

        public static SupportedGroup[] getUsableGroupsArray() {
            return Initialize.USABLE_GROUPS.toArray(new SupportedGroup[Initialize.USABLE_GROUPS.size()]);
        }

        public static List<SupportedGroup> getPreferredGroups() {
            return Initialize.PREFERRED_GROUPS;
        }
    }

    private static class XDHPublicKeyReflection
    implements XDHPublicKeyApi {
        private final Class<?> XECPublicKeyClass;
        private final Method XECPublicKeyGetParams;
        private final Method NamedParameterSpecGetName;

        private XDHPublicKeyReflection(Class<?> XECPublicKeyClass) {
            if (XECPublicKeyClass == null) {
                throw new NullPointerException("XECPublicKeyClass must not be null!");
            }
            this.XECPublicKeyClass = XECPublicKeyClass;
            this.XECPublicKeyGetParams = null;
            this.NamedParameterSpecGetName = null;
        }

        private XDHPublicKeyReflection(Class<?> XECPublicKeyClass, Method XECPublicKeyGetParams, Method NamedParameterSpecGetName) {
            if (XECPublicKeyClass == null) {
                throw new NullPointerException("XECPublicKeyClass must not be null!");
            }
            if (XECPublicKeyGetParams == null) {
                throw new NullPointerException("XECPublicKeyGetParams must not be null!");
            }
            if (NamedParameterSpecGetName == null) {
                throw new NullPointerException("NamedParameterSpecGetName must not be null!");
            }
            this.XECPublicKeyClass = XECPublicKeyClass;
            this.XECPublicKeyGetParams = XECPublicKeyGetParams;
            this.NamedParameterSpecGetName = NamedParameterSpecGetName;
        }

        @Override
        public boolean isSupporting(PublicKey publicKey) {
            return this.XECPublicKeyClass.isInstance(publicKey);
        }

        @Override
        public String getCurveName(PublicKey publicKey) throws GeneralSecurityException {
            if (this.XECPublicKeyClass.isInstance(publicKey)) {
                if (this.XECPublicKeyGetParams != null && this.NamedParameterSpecGetName != null) {
                    try {
                        Object params = this.XECPublicKeyGetParams.invoke((Object)publicKey, new Object[0]);
                        return (String)this.NamedParameterSpecGetName.invoke(params, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new GeneralSecurityException("X25519/X448 not supported by JRE!", e);
                    }
                }
                return publicKey.getAlgorithm();
            }
            throw new GeneralSecurityException(publicKey.getAlgorithm() + " not supported!");
        }

        private static XDHPublicKeyApi init() {
            try {
                if (JceProviderUtil.usesBouncyCastle()) {
                    Class<?> cls = Class.forName("org.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPublicKey");
                    return new XDHPublicKeyReflection(cls);
                }
                Class<?> cls = Class.forName("java.security.spec.NamedParameterSpec");
                Method getName = cls.getMethod("getName", new Class[0]);
                cls = Class.forName("java.security.interfaces.XECPublicKey");
                Method getParams = cls.getMethod("getParams", new Class[0]);
                return new XDHPublicKeyReflection(cls, getParams, getName);
            }
            catch (Throwable t) {
                LOGGER.info("X25519/X448 not supported!");
                return null;
            }
        }
    }

    private static class Initialize {
        private static final SupportedGroup[] PREFERRED = new SupportedGroup[]{SupportedGroup.secp256r1, SupportedGroup.X25519, SupportedGroup.X448, SupportedGroup.secp384r1};
        private static final List<SupportedGroup> USABLE_GROUPS;
        private static final List<SupportedGroup> PREFERRED_GROUPS;

        private Initialize() {
        }

        static {
            ArrayList<SupportedGroup> usableGroups = new ArrayList<SupportedGroup>();
            ArrayList<SupportedGroup> preferredGroups = new ArrayList<SupportedGroup>();
            for (SupportedGroup group : SupportedGroup.values()) {
                if (!group.isUsable()) continue;
                usableGroups.add(group);
            }
            for (SupportedGroup group : PREFERRED) {
                if (!group.isUsable()) continue;
                preferredGroups.add(group);
            }
            if (preferredGroups.isEmpty() && !usableGroups.isEmpty()) {
                preferredGroups.add((SupportedGroup)((Object)usableGroups.get(0)));
            }
            USABLE_GROUPS = Collections.unmodifiableList(usableGroups);
            PREFERRED_GROUPS = Collections.unmodifiableList(preferredGroups);
        }
    }
}

