/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.util;

import java.io.IOException;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.cloud.util.ApplicationAnonymous;
import org.eclipse.californium.cloud.util.DeviceGredentialsProvider;
import org.eclipse.californium.cloud.util.DeviceParser;
import org.eclipse.californium.cloud.util.DeviceProvisioningConsumer;
import org.eclipse.californium.cloud.util.PrincipalInfo;
import org.eclipse.californium.cloud.util.PrincipalInfoProvider;
import org.eclipse.californium.cloud.util.ResourceChangedHandler;
import org.eclipse.californium.cloud.util.ResourceStore;
import org.eclipse.californium.cloud.util.ResultConsumer;
import org.eclipse.californium.elements.auth.AdditionalInfo;
import org.eclipse.californium.elements.auth.ApplicationPrincipal;
import org.eclipse.californium.elements.auth.ExtensiblePrincipal;
import org.eclipse.californium.elements.util.CertPathUtil;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.SystemResourceMonitors;
import org.eclipse.californium.scandium.auth.ApplicationLevelInfoSupplier;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateIdentityResult;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateVerificationResult;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.CertificateVerifier;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceManager
implements DeviceGredentialsProvider,
DeviceProvisioningConsumer,
PrincipalInfoProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceManager.class);
    private final ResourceStore<DeviceParser> devices;
    protected final SslContextUtil.Credentials credentials;
    protected final long addTimeoutMillis;
    protected PskStore pskStore;
    protected CertificateVerifier certificateVerifier;
    protected CertificateProvider certificateProvider;
    protected ApplicationLevelInfoSupplier infoSupplier;

    public DeviceManager(ResourceStore<DeviceParser> devices, SslContextUtil.Credentials credentials, long addTimeoutMillis) {
        this.devices = devices;
        this.credentials = credentials != null && credentials.getPrivateKey() != null && credentials.getPublicKey() != null ? credentials : null;
        this.addTimeoutMillis = addTimeoutMillis;
    }

    protected ApplicationLevelInfoSupplier createInfoSupplier() {
        return new ApplicationLevelInfoSupplier(){

            @Override
            public AdditionalInfo getInfo(Principal clientIdentity, Object customArgument) {
                if (customArgument instanceof AdditionalInfo) {
                    return (AdditionalInfo)customArgument;
                }
                return DeviceManager.this.createAdditionalInfo(clientIdentity);
            }
        };
    }

    @Override
    public void add(PrincipalInfo info, long time, String data, ResultConsumer response) {
        this.add(this.devices, info, time, data, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(ResourceStore<DeviceParser> devices, PrincipalInfo info, long time, String data, final ResultConsumer response) {
        block20: {
            if (devices == null) {
                response.results(ResultConsumer.ResultCode.SERVER_ERROR, "no credentials available.");
                return;
            }
            SystemResourceMonitors.SystemResourceMonitor monitor = devices.getMonitor();
            if (!(monitor instanceof ResourceChangedHandler)) {
                response.results(ResultConsumer.ResultCode.SERVER_ERROR, "no ResourceChangedHandler.");
                return;
            }
            final Semaphore semaphore = devices.getSemaphore();
            try {
                if (semaphore.tryAcquire(this.addTimeoutMillis, TimeUnit.MILLISECONDS)) {
                    boolean release = true;
                    try (StringReader reader = new StringReader(data);){
                        int result = devices.getResource().load(reader);
                        if (result > 0) {
                            ((ResourceChangedHandler)((Object)monitor)).changed(new ResultConsumer(){

                                @Override
                                public void results(ResultConsumer.ResultCode code, String message) {
                                    try {
                                        response.results(code, message);
                                    }
                                    finally {
                                        semaphore.release();
                                    }
                                }
                            });
                            release = false;
                        } else {
                            LOGGER.info("no credentials added!");
                            response.results(ResultConsumer.ResultCode.PROVISIONING_ERROR, "no credentials added.");
                        }
                        break block20;
                    }
                    catch (IllegalArgumentException e) {
                        response.results(ResultConsumer.ResultCode.PROVISIONING_ERROR, e.getMessage());
                        break block20;
                    }
                    catch (IOException e) {
                        response.results(ResultConsumer.ResultCode.SERVER_ERROR, "failed to read new credentials. " + e.getMessage());
                        break block20;
                    }
                    finally {
                        if (release) {
                            semaphore.release();
                        }
                    }
                }
                response.results(ResultConsumer.ResultCode.TOO_MANY_REQUESTS, "Too busy.");
            }
            catch (InterruptedException e) {
                response.results(ResultConsumer.ResultCode.SERVER_ERROR, "Shutdown.");
            }
        }
    }

    @Override
    public PskStore getPskStore() {
        if (this.devices == null) {
            return null;
        }
        if (this.pskStore == null) {
            this.pskStore = new DevicePskStore();
        }
        return this.pskStore;
    }

    @Override
    public CertificateVerifier getCertificateVerifier() {
        if (this.devices == null || this.credentials == null) {
            return null;
        }
        if (this.certificateVerifier == null) {
            this.certificateVerifier = new DeviceCertificateVerifier(this.createCertificateTypesList(this.credentials.hasCertificateChain()));
        }
        return this.certificateVerifier;
    }

    @Override
    public CertificateProvider getCertificateProvider() {
        if (this.devices == null || this.credentials == null) {
            return null;
        }
        if (this.certificateProvider == null) {
            this.certificateProvider = new ServerCertificateProvider(this.createCertificateTypesList(this.credentials.hasCertificateChain()));
        }
        return this.certificateProvider;
    }

    @Override
    public ApplicationLevelInfoSupplier getInfoSupplier() {
        if (this.infoSupplier == null) {
            this.infoSupplier = new ApplicationLevelInfoSupplier(){

                @Override
                public AdditionalInfo getInfo(Principal clientIdentity, Object customArgument) {
                    if (customArgument instanceof AdditionalInfo) {
                        return (AdditionalInfo)customArgument;
                    }
                    return DeviceManager.this.createAdditionalInfo(clientIdentity);
                }
            };
        }
        return this.infoSupplier;
    }

    public AdditionalInfo createAdditionalInfo(Principal clientIdentity) {
        if (this.devices == null) {
            return null;
        }
        if (ApplicationPrincipal.ANONYMOUS.equals(clientIdentity)) {
            return ApplicationAnonymous.APPL_AUTH_PRINCIPAL.getExtendedInfo();
        }
        return this.createAdditionalInfo(this.devices.getResource().getByPrincipal(clientIdentity));
    }

    public AdditionalInfo createAdditionalInfo(DeviceParser.Device device) {
        if (device != null) {
            if (device.ban) {
                return AdditionalInfo.empty();
            }
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("name", device.name);
            info.put("provider", this);
            return AdditionalInfo.from(info);
        }
        return null;
    }

    @Override
    public PrincipalInfo getPrincipalInfo(Principal principal) {
        if (principal instanceof ExtensiblePrincipal) {
            ExtensiblePrincipal extensiblePrincipal = (ExtensiblePrincipal)principal;
            DeviceParser.Device device = null;
            if (extensiblePrincipal.getExtendedInfo().isEmpty()) {
                device = this.devices.getResource().getByPrincipal(principal);
            } else {
                String name = extensiblePrincipal.getExtendedInfo().get("name", String.class);
                DeviceManager manager = extensiblePrincipal.getExtendedInfo().get("provider", DeviceManager.class);
                if (manager == this && name != null && !name.contains("/")) {
                    device = this.devices.getResource().get(name);
                }
            }
            if (device != null && !device.ban) {
                return new PrincipalInfo(device.group, device.name, device.type);
            }
        }
        return null;
    }

    public List<CertificateType> createCertificateTypesList(boolean x509) {
        ArrayList<CertificateType> types = new ArrayList<CertificateType>(2);
        types.add(CertificateType.RAW_PUBLIC_KEY);
        if (x509) {
            types.add(CertificateType.X_509);
        }
        return types;
    }

    private class DevicePskStore
    implements PskStore {
        private final PskPublicInformation dummy = new PskPublicInformation("dummy");

        private DevicePskStore() {
        }

        @Override
        public boolean hasEcdhePskSupported() {
            return true;
        }

        @Override
        public PskSecretResult requestPskSecretResult(ConnectionId cid, ServerNames serverName, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
            DeviceParser.Device device = ((DeviceParser)DeviceManager.this.devices.getResource()).getByPreSharedKeyIdentity(identity.getPublicInfoAsString());
            AdditionalInfo additionalInfo = DeviceManager.this.createAdditionalInfo(device);
            if (additionalInfo != null && !additionalInfo.isEmpty()) {
                return new PskSecretResult(cid, identity, device.pskSecret, additionalInfo, false, false);
            }
            return new PskSecretResult(cid, identity);
        }

        @Override
        public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
            return this.dummy;
        }

        @Override
        public void setResultHandler(HandshakeResultHandler resultHandler) {
        }
    }

    protected class DeviceCertificateVerifier
    implements CertificateVerifier {
        private final List<CertificateType> supportedCertificateTypes;

        protected DeviceCertificateVerifier(List<CertificateType> supportedCertificateTypes) {
            this.supportedCertificateTypes = Collections.unmodifiableList(supportedCertificateTypes);
        }

        @Override
        public List<CertificateType> getSupportedCertificateTypes() {
            return this.supportedCertificateTypes;
        }

        @Override
        public CertificateVerificationResult verifyCertificate(ConnectionId cid, ServerNames serverName, InetSocketAddress remotePeer, boolean clientUsage, boolean verifySubject, boolean truncateCertificatePath, CertificateMessage message) {
            CertPath certChain = message.getCertificateChain();
            if (certChain == null) {
                PublicKey publicKey = message.getPublicKey();
                AdditionalInfo info = this.getByRawPublicKey(publicKey);
                if (info == null) {
                    LOGGER.info("Certificate validation failed: Raw public key is not trusted");
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
                    return new CertificateVerificationResult(cid, new HandshakeException("Raw public key is not trusted!", alert));
                }
                if (info.isEmpty()) {
                    LOGGER.info("Certificate validation failed: Raw public key is banned");
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
                    return new CertificateVerificationResult(cid, new HandshakeException("Raw public key is banned!", alert));
                }
                return new CertificateVerificationResult(cid, publicKey, (Object)info);
            }
            try {
                List<? extends Certificate> path;
                Certificate certificate;
                if (!message.isEmpty() && (certificate = (path = certChain.getCertificates()).get(0)) instanceof X509Certificate) {
                    AlertMessage alert;
                    AdditionalInfo caInfo;
                    X509Certificate deviceCertificate = (X509Certificate)certificate;
                    if (!CertPathUtil.canBeUsedForAuthentication(deviceCertificate, clientUsage)) {
                        LOGGER.debug("Certificate validation failed: key usage doesn't match");
                        AlertMessage alert2 = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
                        return new CertificateVerificationResult(cid, new HandshakeException("Key Usage doesn't match!", alert2));
                    }
                    X509Certificate[] trustedCertificates = this.getTrustedCertificates();
                    if (trustedCertificates == null || trustedCertificates.length == 0) {
                        LOGGER.info("Certificate validation failed: no trusted CA");
                        trustedCertificates = null;
                    } else {
                        LOGGER.debug("{} CA x509 certificates.", (Object)trustedCertificates.length);
                    }
                    certChain = CertPathUtil.validateCertificatePathWithIssuer(truncateCertificatePath, certChain, trustedCertificates);
                    String role = "";
                    AdditionalInfo info = this.getByX509(deviceCertificate);
                    if (!(info != null && info.isEmpty() || (path = certChain.getCertificates()).size() <= 1 || !((certificate = path.get(path.size() - 1)) instanceof X509Certificate) || (caInfo = this.getByX509((X509Certificate)certificate)) == null || info != null && !caInfo.isEmpty())) {
                        role = "CA ";
                        info = caInfo;
                    }
                    if (info == null) {
                        LOGGER.info("Certificate validation failed: x509 certificate is not trusted");
                        alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
                        return new CertificateVerificationResult(cid, new HandshakeException("x509 certificate is not trusted!", alert));
                    }
                    if (info.isEmpty()) {
                        LOGGER.info("{}Certificate validation failed: x509 certificate is banned", (Object)role);
                        alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
                        return new CertificateVerificationResult(cid, new HandshakeException(role + "x509 certificate is banned!", alert));
                    }
                    return new CertificateVerificationResult(cid, certChain, (Object)info);
                }
                return new CertificateVerificationResult(cid, certChain, null);
            }
            catch (CertPathValidatorException e) {
                Throwable cause = e.getCause();
                if (cause instanceof CertificateExpiredException) {
                    LOGGER.debug("Certificate expired: {}", (Object)cause.getMessage());
                    AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.CERTIFICATE_EXPIRED);
                    return new CertificateVerificationResult(cid, new HandshakeException("Certificate expired", alert));
                }
                if (cause != null) {
                    LOGGER.debug("Certificate validation failed: {}/{}", (Object)e.getMessage(), (Object)cause.getMessage());
                } else {
                    LOGGER.debug("Certificate validation failed: {}", (Object)e.getMessage());
                }
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
                return new CertificateVerificationResult(cid, new HandshakeException("Certificate chain could not be validated", alert, e));
            }
            catch (GeneralSecurityException e) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Certificate validation failed", e);
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Certificate validation failed due to {}", (Object)e.getMessage());
                }
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.DECRYPT_ERROR);
                return new CertificateVerificationResult(cid, new HandshakeException("Certificate chain could not be validated", alert, e));
            }
        }

        @Override
        public List<X500Principal> getAcceptedIssuers() {
            return Collections.emptyList();
        }

        @Override
        public void setResultHandler(HandshakeResultHandler resultHandler) {
        }

        protected AdditionalInfo getByRawPublicKey(PublicKey publicKey) {
            DeviceParser.Device device = ((DeviceParser)DeviceManager.this.devices.getResource()).getByRawPublicKey(publicKey);
            return DeviceManager.this.createAdditionalInfo(device);
        }

        protected AdditionalInfo getByX509(X509Certificate certificate) {
            DeviceParser.Device device = ((DeviceParser)DeviceManager.this.devices.getResource()).getByX509(certificate);
            if (LOGGER.isDebugEnabled()) {
                String cn = CertPathUtil.getSubjectsCn(certificate);
                LOGGER.debug("{}x509 certificate for {}", (Object)(device == null ? "No " : ""), (Object)cn);
            }
            return DeviceManager.this.createAdditionalInfo(device);
        }

        protected X509Certificate[] getTrustedCertificates() {
            return ((DeviceParser)DeviceManager.this.devices.getResource()).getTrustedCertificates();
        }
    }

    protected class ServerCertificateProvider
    implements CertificateProvider {
        private List<CertificateType> supportedCertificateTypes;
        private List<CipherSuite.CertificateKeyAlgorithm> supportedCertificateKeyAlgorithms;

        public ServerCertificateProvider(List<CertificateType> supportedCertificateTypes) {
            this.supportedCertificateKeyAlgorithms = Collections.unmodifiableList(Arrays.asList(CipherSuite.CertificateKeyAlgorithm.getAlgorithm(DeviceManager.this.credentials.getPublicKey())));
            this.supportedCertificateTypes = Collections.unmodifiableList(supportedCertificateTypes);
        }

        @Override
        public List<CipherSuite.CertificateKeyAlgorithm> getSupportedCertificateKeyAlgorithms() {
            return this.supportedCertificateKeyAlgorithms;
        }

        @Override
        public List<CertificateType> getSupportedCertificateTypes() {
            return this.supportedCertificateTypes;
        }

        @Override
        public CertificateIdentityResult requestCertificateIdentity(ConnectionId cid, boolean client, List<X500Principal> issuers, ServerNames serverNames, List<CipherSuite.CertificateKeyAlgorithm> certificateKeyAlgorithms, List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms, List<XECDHECryptography.SupportedGroup> curves) {
            if (DeviceManager.this.credentials.hasCertificateChain()) {
                return new CertificateIdentityResult(cid, DeviceManager.this.credentials.getPrivateKey(), DeviceManager.this.credentials.getCertificateChainAsList());
            }
            return new CertificateIdentityResult(cid, DeviceManager.this.credentials.getPrivateKey(), DeviceManager.this.credentials.getPublicKey());
        }

        @Override
        public void setResultHandler(HandshakeResultHandler resultHandler) {
        }
    }
}

