/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.option;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.option.IntegerOption;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.DatagramReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeOption
extends IntegerOption {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeOption.class);
    public static final int COAP_OPTION_TIME = 65000;
    public static final long MAX_MILLISECONDS_DELTA = 5000L;
    public static final Definition DEFINITION = new Definition(65000, "Time");
    private boolean adjustTime;
    private static final int DEPRECATED_COAP_OPTION_TIME = 65340;
    public static final Definition DEPRECATED_DEFINITION = new Definition(65340, "_Time");

    @Override
    public Definition getDefinition() {
        return (Definition)super.getDefinition();
    }

    @Override
    public String toValueString() {
        long time = this.getLongValue();
        if (time > 0L) {
            return new Date(time).toString();
        }
        return "0";
    }

    public TimeOption adjust() {
        if (this.adjustTime) {
            Definition definition = this.getDefinition();
            return definition.create();
        }
        return null;
    }

    public static TimeOption getMessageTime(Message message) {
        if (message == null) {
            throw new NullPointerException("Message must not be null!");
        }
        long delta = ClockUtil.delta(message.getNanoTimestamp(), TimeUnit.MILLISECONDS);
        long receiveTime = System.currentTimeMillis() - delta;
        Definition definition = null;
        TimeOption option = (TimeOption)message.getOptions().getOtherOption(DEFINITION);
        if (option != null) {
            definition = DEFINITION;
        } else {
            option = (TimeOption)message.getOptions().getOtherOption(DEPRECATED_DEFINITION);
            if (option != null) {
                definition = DEPRECATED_DEFINITION;
            }
        }
        if (option != null) {
            long value = option.getLongValue();
            if (value == 0L) {
                option = definition.create(receiveTime);
                option.adjustTime = true;
                LOGGER.info("Time: send initial time");
            } else {
                delta = value - receiveTime;
                if (Math.abs(delta) > 5000L) {
                    option.adjustTime = true;
                    LOGGER.info("Time: {}ms delta => send fix", (Object)delta);
                } else {
                    LOGGER.debug("Time: {}ms delta", (Object)delta);
                }
            }
            return option;
        }
        LOGGER.debug("Time: localtime");
        return DEFINITION.create(receiveTime);
    }

    public TimeOption(Definition definition) {
        super(definition, System.currentTimeMillis());
    }

    public TimeOption(Definition definition, long value) {
        super(definition, value);
    }

    public static class Definition
    extends IntegerOption.Definition {
        private Definition(int number, String name) {
            super(number, name, true);
        }

        @Override
        public TimeOption create(DatagramReader reader, int length) {
            if (reader == null) {
                throw new NullPointerException("Option " + this.getName() + " reader must not be null.");
            }
            return new TimeOption(this, Definition.getLongValue(reader, length));
        }

        @Override
        public TimeOption create(long value) {
            return new TimeOption(this, value);
        }

        public TimeOption create() {
            return new TimeOption(this);
        }
    }
}

