/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.option;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MessageFormatException;
import org.eclipse.californium.core.coap.option.IntegerOption;
import org.eclipse.californium.elements.util.DatagramReader;

public class ResponseCodeOption
extends IntegerOption {
    private final CoAP.ResponseCode code;

    public ResponseCodeOption(Definition definition, int code) {
        super(definition, code);
        try {
            this.code = CoAP.ResponseCode.valueOf(code);
        }
        catch (MessageFormatException ex) {
            throw new IllegalArgumentException(this.getDefinition().getName() + " " + ex.getMessage());
        }
    }

    public ResponseCodeOption(Definition definition, CoAP.ResponseCode code) {
        super(definition, code != null ? (long)code.value : 0L);
        if (code == null) {
            throw new NullPointerException("Option " + this.getDefinition().getName() + " code must not be null.");
        }
        this.code = code;
    }

    @Override
    public Definition getDefinition() {
        return (Definition)super.getDefinition();
    }

    @Override
    public String toValueString() {
        return this.code.text + "/" + this.code.name();
    }

    public CoAP.ResponseCode getResponseCode() {
        return this.code;
    }

    public static class Definition
    extends IntegerOption.Definition {
        public Definition(int number, String name) {
            super(number, name, true, 1, 1);
        }

        @Override
        public ResponseCodeOption create(DatagramReader reader, int length) {
            if (reader == null) {
                throw new NullPointerException("Option " + this.getName() + " reader must not be null.");
            }
            if (length != 1) {
                throw new IllegalArgumentException("Option " + this.getName() + " value must be 1 byte.");
            }
            return new ResponseCodeOption(this, reader.readNextByte() & 0xFF);
        }

        @Override
        public ResponseCodeOption create(long value) {
            return new ResponseCodeOption(this, (int)value);
        }

        public ResponseCodeOption create(CoAP.ResponseCode code) {
            if (code == null) {
                throw new NullPointerException("Option " + this.getName() + " code must not be null.");
            }
            return new ResponseCodeOption(this, code);
        }
    }
}

