/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.util;

import java.security.Principal;
import org.eclipse.californium.cloud.util.PrincipalInfoProvider;
import org.eclipse.californium.elements.auth.ExtensiblePrincipal;

public class PrincipalInfo {
    public static final String INFO_PROVIDER = "provider";
    public static final String INFO_NAME = "name";
    public final String name;
    public final String group;
    public final Type type;

    public PrincipalInfo(String group, String name, Type type) {
        this.name = name;
        this.group = group;
        this.type = type;
    }

    public String toString() {
        return this.name + " (" + this.group + "," + this.type.getShortName() + ")";
    }

    public static PrincipalInfo getPrincipalInfo(Principal principal) {
        ExtensiblePrincipal extensiblePrincipal;
        PrincipalInfoProvider provider;
        if (principal instanceof ExtensiblePrincipal && (provider = (extensiblePrincipal = (ExtensiblePrincipal)principal).getExtendedInfo().get(INFO_PROVIDER, PrincipalInfoProvider.class)) != null) {
            return provider.getPrincipalInfo(extensiblePrincipal);
        }
        return null;
    }

    public static String getName(Principal principal) {
        if (principal instanceof ExtensiblePrincipal) {
            ExtensiblePrincipal extensiblePrincipal = (ExtensiblePrincipal)principal;
            return extensiblePrincipal.getExtendedInfo().get(INFO_NAME, String.class);
        }
        return null;
    }

    public static enum Type {
        DEVICE("dev"),
        PROVISIONING("prov"),
        CA("ca"),
        WEB("web");

        private final String shortName;

        private Type(String shortName) {
            this.shortName = shortName;
        }

        public String getShortName() {
            return this.shortName;
        }

        public static Type valueOfShortName(String shortName) {
            for (Type type : Type.values()) {
                if (!shortName.equalsIgnoreCase(type.getShortName())) continue;
                return type;
            }
            return null;
        }
    }
}

