/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.security.auth.DestroyFailedException;
import org.eclipse.californium.cloud.util.AppendingResourceParser;
import org.eclipse.californium.cloud.util.DeviceIdentifier;
import org.eclipse.californium.cloud.util.PrincipalInfo;
import org.eclipse.californium.cloud.util.SignedMessage;
import org.eclipse.californium.elements.auth.PreSharedKeyIdentity;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.auth.X509CertPath;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.JceProviderUtil;
import org.eclipse.californium.elements.util.PemReader;
import org.eclipse.californium.elements.util.PemUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.cipher.RandomManager;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalCertificateFactory;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceParser
implements AppendingResourceParser<DeviceParser> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceParser.class);
    private static final String CERTIFICATE_TYPE_X509 = "X.509";
    private static final ThreadLocalCertificateFactory CERTIFICATE_FACTORY = new ThreadLocalCertificateFactory("X.509");
    private static final byte[] ECC_SECP256R1_HEADER;
    public static final String GROUP_POSTFIX = ".group";
    public static final String LABEL_POSTFIX = ".label";
    public static final String PSK_POSTFIX = ".psk";
    public static final String RPK_POSTFIX = ".rpk";
    public static final String SIG_POSTFIX = ".sig";
    public static final String X509_POSTFIX = ".x509";
    @Deprecated
    public static final String PROV_POSTFIX = ".prov";
    public static final String TYPE_POSTFIX = ".type";
    public static final String BAN_POSTFIX = ".ban";
    private static final List<String> POSTFIXES;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ConcurrentMap<String, Device> map = new ConcurrentHashMap<String, Device>();
    private final ConcurrentMap<String, Device> newDevices = new ConcurrentHashMap<String, Device>();
    private final ConcurrentMap<String, Device> psk = new ConcurrentHashMap<String, Device>();
    private final ConcurrentMap<PublicKey, Device> rpk = new ConcurrentHashMap<PublicKey, Device>();
    private final ConcurrentMap<X509Certificate, Device> x509 = new ConcurrentHashMap<X509Certificate, Device>();
    private final ConcurrentMap<X509Certificate, Device> x509Ca = new ConcurrentHashMap<X509Certificate, Device>();
    private final ConcurrentMap<String, Set<DeviceIdentifier>> groups = new ConcurrentHashMap<String, Set<DeviceIdentifier>>();
    private final boolean caseSensitiveNames;
    private final boolean replace;
    private final List<String> customFields;
    private volatile boolean destroyed;
    private volatile X509Certificate[] trusts;

    public DeviceParser(boolean caseSensitiveNames, boolean replace, List<String> customFields) {
        if (customFields != null) {
            for (String name : customFields) {
                if (name.startsWith(".")) continue;
                throw new IllegalArgumentException("Custom field '" + name + "' doesn't start with '.'!");
            }
        }
        this.caseSensitiveNames = caseSensitiveNames;
        this.replace = replace;
        this.customFields = customFields;
    }

    private String getKey(String name) {
        String key;
        String string = key = name == null ? "" : name;
        if (!this.caseSensitiveNames && key != null) {
            key = key.toLowerCase();
        }
        return key;
    }

    private boolean match(String name1, String name2) {
        if (this.caseSensitiveNames) {
            return name1.equals(name2);
        }
        return name1.equalsIgnoreCase(name2);
    }

    private String prefix(String id, String postfix) {
        return StringUtil.truncateTail(!this.caseSensitiveNames, id, postfix);
    }

    private boolean endsWith(String id, String postfix) {
        int length = postfix.length();
        int offset = id.length() - length;
        if (offset >= 0) {
            return id.regionMatches(!this.caseSensitiveNames, offset, postfix, 0, length);
        }
        return false;
    }

    private boolean isName(String id) {
        if (this.endsWith(id, GROUP_POSTFIX)) {
            return true;
        }
        for (String postfix : POSTFIXES) {
            if (!this.endsWith(id, postfix)) continue;
            return false;
        }
        if (this.isCustomField(id) != null) {
            return false;
        }
        return !id.startsWith(".");
    }

    private String isCustomField(String id) {
        if (this.customFields != null) {
            for (String postfix : this.customFields) {
                if (!this.endsWith(id, postfix)) continue;
                return postfix;
            }
        }
        return null;
    }

    private boolean match(Device.Builder builder, String name) {
        if (builder.name == null) {
            return false;
        }
        if (name.isEmpty()) {
            return !builder.name.isEmpty();
        }
        return this.match(builder.name, name);
    }

    public boolean add(Device.Builder builder) {
        return this.add(builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Device device) {
        String key = this.getKey(device.name);
        this.lock.writeLock().lock();
        try {
            Device replaced = this.map.putIfAbsent(key, device);
            if (replaced != null) {
                if (this.replace && replaced.type == PrincipalInfo.Type.DEVICE && !replaced.ban) {
                    if (device.label == null && replaced.label != null) {
                        device = new Device(device, replaced.label, replaced.customFields);
                    }
                    this.remove(replaced);
                    this.map.putIfAbsent(key, device);
                } else {
                    boolean bl = false;
                    return bl;
                }
            }
            Device previous = null;
            if (device.pskIdentity != null && (previous = this.psk.putIfAbsent(device.pskIdentity, device)) != null) {
                LOGGER.info("psk {} {} ambiguous {}", device.pskIdentity, device.name, previous.name);
                this.map.remove(key, device);
                if (replaced != null) {
                    this.add(replaced);
                }
                boolean bl = false;
                return bl;
            }
            if (device.publicKey != null && (previous = this.rpk.putIfAbsent(device.publicKey, device)) != null) {
                LOGGER.info("rpk {} ambiguous {}", (Object)device.name, (Object)previous.name);
                this.remove(device);
                if (replaced != null) {
                    this.add(replaced);
                }
                boolean bl = false;
                return bl;
            }
            if (device.x509 != null) {
                previous = this.x509.putIfAbsent(device.x509, device);
                if (previous != null) {
                    LOGGER.info("x509 {} ambiguous {}", (Object)device.name, (Object)previous.name);
                    this.remove(device);
                    if (replaced != null) {
                        this.add(replaced);
                    }
                    boolean bl = false;
                    return bl;
                }
                if (device.type == PrincipalInfo.Type.CA) {
                    previous = this.x509Ca.putIfAbsent(device.x509, device);
                    if (previous != null) {
                        LOGGER.info("x509 {} ambiguous CA {}", (Object)device.name, (Object)previous.name);
                        this.remove(device);
                        if (replaced != null) {
                            this.add(replaced);
                        }
                        boolean bl = false;
                        return bl;
                    }
                    ConcurrentMap<X509Certificate, Device> concurrentMap = this.x509Ca;
                    synchronized (concurrentMap) {
                        this.trusts = null;
                    }
                }
            }
            LOGGER.info("added {}{}{}{}{} {}{}", device.name, device.pskIdentity != null ? " psk" : "", device.publicKey != null ? " rpk" : "", device.sign != null ? " (sign)" : "", device.x509 != null ? " x509" : "", device.type.getShortName(), device.ban ? " (banned)" : "");
            Set<Device> group = new HashSet<Device>();
            Set prev = this.groups.putIfAbsent(device.group, group);
            if (prev != null) {
                group = prev;
            }
            group.add(device);
            this.newDevices.put(key, device);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Set<DeviceIdentifier> getGroup(String group) {
        Set<DeviceIdentifier> devices = (Set<DeviceIdentifier>)this.groups.get(group);
        if (devices == null) {
            devices = Collections.emptySet();
        }
        return devices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Certificate[] getTrustedCertificates() {
        X509Certificate[] trusts = this.trusts;
        if (trusts == null) {
            ConcurrentMap<X509Certificate, Device> concurrentMap = this.x509Ca;
            synchronized (concurrentMap) {
                trusts = this.trusts;
                if (trusts == null) {
                    int index = 0;
                    LOGGER.debug("{} CA x509 certificates", (Object)this.x509Ca.size());
                    trusts = new X509Certificate[this.x509Ca.size()];
                    for (X509Certificate certificate : this.x509Ca.keySet()) {
                        trusts[index++] = certificate;
                    }
                    this.trusts = trusts;
                }
            }
        }
        return trusts;
    }

    public Device get(String name) {
        return (Device)this.map.get(this.getKey(name));
    }

    public Device getByPreSharedKeyIdentity(String identity) {
        return (Device)this.psk.get(identity);
    }

    public Device getByRawPublicKey(PublicKey publicKey) {
        return (Device)this.rpk.get(publicKey);
    }

    public Device getByX509(X509Certificate x509Certificate) {
        return (Device)this.x509.get(x509Certificate);
    }

    public Device getByPrincipal(Principal principal) {
        if (principal instanceof PreSharedKeyIdentity) {
            PreSharedKeyIdentity pskIdentity = (PreSharedKeyIdentity)principal;
            return this.getByPreSharedKeyIdentity(pskIdentity.getIdentity());
        }
        if (principal instanceof RawPublicKeyIdentity) {
            RawPublicKeyIdentity rpkIdentity = (RawPublicKeyIdentity)principal;
            return this.getByRawPublicKey(rpkIdentity.getKey());
        }
        if (principal instanceof X509CertPath) {
            X509CertPath x509Identity = (X509CertPath)principal;
            return this.getByX509(x509Identity.getTarget());
        }
        return null;
    }

    public boolean remove(String name) {
        return this.remove(this.get(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Device device) {
        this.lock.writeLock().lock();
        try {
            String key = this.getKey(device.name);
            boolean removed = this.map.remove(key, device);
            if (removed) {
                Set group;
                if (device.pskIdentity != null) {
                    this.psk.remove(device.pskIdentity, device);
                }
                if (device.publicKey != null) {
                    this.rpk.remove(device.publicKey, device);
                }
                if (device.x509 != null) {
                    this.x509.remove(device.x509, device);
                    if (device.type == PrincipalInfo.Type.CA && this.x509Ca.remove(device.x509, device)) {
                        ConcurrentMap<X509Certificate, Device> concurrentMap = this.x509Ca;
                        synchronized (concurrentMap) {
                            this.trusts = null;
                        }
                    }
                }
                if ((group = (Set)this.groups.get(device.group)) != null) {
                    group.remove(device);
                }
                this.newDevices.remove(key, device);
                boolean bl = true;
                return bl;
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int size() {
        return this.map.size();
    }

    @Override
    public int sizeNewEntries() {
        return this.newDevices.size();
    }

    @Override
    public void clearNewEntries() {
        this.lock.writeLock().lock();
        try {
            this.newDevices.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void saveNewEntries(Writer writer) throws IOException {
        this.lock.readLock().lock();
        try {
            this.save(this.newDevices, writer);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void save(Writer writer) throws IOException {
        this.lock.readLock().lock();
        try {
            this.save(this.map, writer);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void save(ConcurrentMap<String, Device> map, Writer writer) throws IOException {
        ArrayList names = new ArrayList(map.keySet());
        Collections.sort(names);
        for (String name : names) {
            Device credentials = (Device)map.get(name);
            if (credentials == null) continue;
            if (credentials.comment != null) {
                writer.write(StringUtil.lineSeparator());
                writer.write("# ");
                writer.write(credentials.comment);
                writer.write(StringUtil.lineSeparator());
            }
            writer.write(credentials.name);
            writer.write(61);
            writer.write(credentials.group);
            writer.write(StringUtil.lineSeparator());
            if (credentials.label != null) {
                writer.write(LABEL_POSTFIX);
                writer.write(61);
                writer.write(credentials.label);
                writer.write(StringUtil.lineSeparator());
            }
            if (credentials.pskIdentity != null && credentials.pskSecret != null) {
                writer.write(PSK_POSTFIX);
                writer.write(61);
                writer.write(credentials.pskIdentity);
                writer.write(44);
                writer.write(DeviceParser.encode64(credentials.pskSecret));
                writer.write(StringUtil.lineSeparator());
            }
            if (credentials.publicKey != null) {
                writer.write(RPK_POSTFIX);
                writer.write(61);
                writer.write(DeviceParser.encode64(credentials.publicKey.getEncoded()));
                writer.write(StringUtil.lineSeparator());
                if (credentials.sign != null) {
                    writer.write(SIG_POSTFIX);
                    writer.write(61);
                    writer.write(DeviceParser.encode64(credentials.sign));
                    writer.write(StringUtil.lineSeparator());
                }
            }
            if (credentials.x509 != null) {
                try {
                    byte[] data = credentials.x509.getEncoded();
                    writer.write(X509_POSTFIX);
                    writer.write(61);
                    writer.write(StringUtil.lineSeparator());
                    PemUtil.write(credentials.x509PemTag, data, writer);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    // empty catch block
                }
            }
            if (credentials.type != PrincipalInfo.Type.DEVICE) {
                writer.write(TYPE_POSTFIX);
                writer.write("=");
                writer.write(credentials.type.getShortName());
                writer.write(StringUtil.lineSeparator());
            }
            if (credentials.ban) {
                writer.write(BAN_POSTFIX);
                writer.write("=1");
                writer.write(StringUtil.lineSeparator());
            }
            if (credentials.customFields == null) continue;
            for (Map.Entry<String, String> entry : credentials.customFields.entrySet()) {
                writer.write(entry.getKey());
                writer.write("=");
                writer.write(entry.getValue());
                writer.write(StringUtil.lineSeparator());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int load(Reader reader) throws IOException {
        String errorMessage;
        int entries;
        int entriesBefore;
        block55: {
            entriesBefore = this.size();
            entries = 0;
            BufferedReader lineReader = new BufferedReader(reader);
            PemReader pemReader = new PemReader(lineReader);
            errorMessage = null;
            this.lock.writeLock().lock();
            try {
                String line;
                int lineNumber = 0;
                int errors = 0;
                int comments = 0;
                Device.Builder builder = Device.builder();
                while ((line = lineReader.readLine()) != null) {
                    ++lineNumber;
                    try {
                        if (line.isEmpty()) {
                            if (builder.name != null) continue;
                            builder.comment = null;
                            continue;
                        }
                        if (line.startsWith("#")) {
                            String comment;
                            ++comments;
                            if (builder.name != null || (comment = line.substring(1).trim()).isEmpty()) continue;
                            builder.comment = comment;
                            continue;
                        }
                        String[] entry = line.split("=", 2);
                        if (entry.length == 2) {
                            String name = entry[0];
                            String[] values = entry[1].split(",");
                            String prefix = this.prefix(name, RPK_POSTFIX);
                            if (prefix != name) {
                                if (this.parseRPK(builder, prefix, values)) continue;
                                ++errors;
                                LOGGER.warn("{}: '{}' invalid line!", (Object)lineNumber, (Object)line);
                                continue;
                            }
                            prefix = this.prefix(name, SIG_POSTFIX);
                            if (prefix != name) {
                                if (this.parseSignature(builder, prefix, values)) continue;
                                ++errors;
                                LOGGER.warn("{}: '{}' invalid line!", (Object)lineNumber, (Object)line);
                                continue;
                            }
                            prefix = this.prefix(name, X509_POSTFIX);
                            if (prefix != name) {
                                byte[] data;
                                if (values.length != 1 || !this.match(builder, prefix)) {
                                    ++errors;
                                    LOGGER.warn("{}: '{}' invalid line!", (Object)lineNumber, (Object)line);
                                    continue;
                                }
                                String tag = pemReader.readNextBegin();
                                if (!this.parseX509(builder, tag, data = pemReader.readToEnd())) {
                                    ++errors;
                                    LOGGER.warn("{}: {} invalid {}!", lineNumber, line, tag);
                                }
                                lineNumber += pemReader.lines();
                                continue;
                            }
                            prefix = this.prefix(name, PSK_POSTFIX);
                            if (prefix != name) {
                                if (this.parsePSK(builder, prefix, values)) continue;
                                ++errors;
                                LOGGER.warn("{}: '{}' invalid line!", (Object)lineNumber, (Object)line);
                                continue;
                            }
                            prefix = this.prefix(name, TYPE_POSTFIX);
                            if (prefix != name) {
                                if (values.length != 1 || !this.match(builder, prefix)) {
                                    ++errors;
                                    LOGGER.warn("{}: '{}' invalid line!", (Object)lineNumber, (Object)line);
                                    continue;
                                }
                                PrincipalInfo.Type type = PrincipalInfo.Type.valueOfShortName(values[0]);
                                if (type == null) {
                                    ++errors;
                                    LOGGER.warn("{}: '{}' value not supported!", (Object)lineNumber, (Object)line);
                                    continue;
                                }
                                if (type == PrincipalInfo.Type.WEB) {
                                    ++errors;
                                    LOGGER.warn("{}: '{}', 'web' not supported!", (Object)lineNumber, (Object)line);
                                    continue;
                                }
                                if (builder.type != null) {
                                    ++errors;
                                    LOGGER.warn("{}: '{}' invalid line, type already provided!", (Object)lineNumber, (Object)line);
                                    continue;
                                }
                                builder.type = type;
                                continue;
                            }
                            prefix = this.prefix(name, PROV_POSTFIX);
                            if (prefix != name) {
                                if (values.length != 1 || !this.match(builder, prefix)) {
                                    ++errors;
                                    LOGGER.warn("{}: '{}' invalid line!", (Object)lineNumber, (Object)line);
                                    continue;
                                }
                                if (builder.type != null) {
                                    ++errors;
                                    LOGGER.warn("{}: '{}' invalid line, type already provided!", (Object)lineNumber, (Object)line);
                                    continue;
                                }
                                builder.type = PrincipalInfo.Type.PROVISIONING;
                                continue;
                            }
                            prefix = this.prefix(name, BAN_POSTFIX);
                            if (prefix != name) {
                                if (values.length != 1 || !this.match(builder, prefix)) {
                                    ++errors;
                                    LOGGER.warn("{}: '{}' invalid line!", (Object)lineNumber, (Object)line);
                                    continue;
                                }
                                builder.ban = true;
                                continue;
                            }
                            prefix = this.prefix(name, LABEL_POSTFIX);
                            if (prefix != name) {
                                if (values.length != 1 || !this.match(builder, prefix)) {
                                    ++errors;
                                    LOGGER.warn("{}: '{}' invalid line!", (Object)lineNumber, (Object)line);
                                    continue;
                                }
                                builder.label = DeviceParser.decodeText(values[0]);
                                continue;
                            }
                            String customField = this.isCustomField(name);
                            if (customField != null) {
                                prefix = this.prefix(name, customField);
                                if (!this.match(builder, prefix)) {
                                    ++errors;
                                    LOGGER.warn("{}: '{}' invalid line!", (Object)lineNumber, (Object)line);
                                    continue;
                                }
                                builder.addCustomField(customField, entry[1]);
                                continue;
                            }
                            prefix = this.prefix(name, GROUP_POSTFIX);
                            if (prefix == name && !this.isName(name)) continue;
                            if (builder.name != null) {
                                builder.applyDefaults();
                                if (entriesBefore > 0 && builder.type != PrincipalInfo.Type.DEVICE) {
                                    ++errors;
                                    LOGGER.warn("{}: non-device entry is not allowed to be appended!", (Object)lineNumber);
                                    errorMessage = "non-device entry is not allowed to be appended!";
                                } else if (this.add(builder)) {
                                    ++entries;
                                }
                                builder = Device.builder();
                            }
                            if (values.length != 1) {
                                ++errors;
                                LOGGER.warn("{}: '{}' invalid line!", (Object)lineNumber, (Object)line);
                                continue;
                            }
                            builder.name = prefix == null ? name : prefix;
                            builder.group = DeviceParser.decodeText(values[0]);
                            continue;
                        }
                        ++errors;
                        LOGGER.warn("{}: '{}' invalid line!", (Object)lineNumber, (Object)line);
                    }
                    catch (IllegalArgumentException ex) {
                        ++errors;
                        LOGGER.warn("{}: '{}' invalid line!", lineNumber, line, ex);
                    }
                }
                if (builder.name != null) {
                    builder.applyDefaults();
                    if (entriesBefore > 0 && builder.type != PrincipalInfo.Type.DEVICE) {
                        ++errors;
                        LOGGER.warn("{}: non-device entry is not allowed to be appended!", (Object)lineNumber);
                        errorMessage = "non-device entry is not allowed to be appended!";
                    } else if (this.add(builder)) {
                        ++entries;
                    }
                }
                if (this.size() == 0 && errors > 0 && lineNumber == comments + errors) {
                    LOGGER.warn("read store, only errors, wrong password?");
                    SecretUtil.destroy(this);
                }
            }
            catch (RuntimeException e) {
                LOGGER.warn("read store, unexpected error occurred!", e);
            }
            catch (IOException e) {
                if (e.getCause() instanceof GeneralSecurityException) {
                    LOGGER.warn("read store, wrong password?", e);
                    SecretUtil.destroy(this);
                    break block55;
                }
                throw e;
            }
            finally {
                this.lock.writeLock().unlock();
                try {
                    lineReader.close();
                }
                catch (IOException e) {}
            }
        }
        if (entriesBefore == 0) {
            LOGGER.info("read {} device credentials.", (Object)this.size());
        } else {
            LOGGER.info("read {} new device credentials (total {}).", (Object)entries, (Object)this.size());
        }
        if (errorMessage != null) {
            throw new IllegalArgumentException(errorMessage);
        }
        return entries;
    }

    private boolean parsePSK(Device.Builder builder, String name, String[] values) {
        if (values.length != 2 || !this.match(builder, name)) {
            return false;
        }
        builder.pskIdentity = DeviceParser.decodeText(values[0]);
        builder.pskSecret = DeviceParser.binDecodeTextOr64(values[1]);
        return !builder.pskIdentity.isEmpty() && builder.pskSecret.length > 0;
    }

    private boolean parseRPK(Device.Builder builder, String name, String[] values) {
        if (values.length != 1 || !this.match(builder, name)) {
            return false;
        }
        byte[] publicKey = DeviceParser.binDecodeTextOr64(values[0]);
        Exception error = null;
        try {
            builder.publicKey = Asn1DerDecoder.readSubjectPublicKey(publicKey);
            return true;
        }
        catch (GeneralSecurityException e) {
            error = e;
        }
        catch (IllegalArgumentException e) {
            error = e;
        }
        if (error != null) {
            if (publicKey.length == 64) {
                publicKey = Bytes.concatenate(ECC_SECP256R1_HEADER, publicKey);
                try {
                    builder.publicKey = Asn1DerDecoder.readSubjectPublicKey(publicKey);
                    return true;
                }
                catch (GeneralSecurityException generalSecurityException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            LOGGER.warn("RPK:", error);
        }
        return false;
    }

    private boolean parseSignature(Device.Builder builder, String name, String[] values) {
        if (values.length != 1 || !this.match(builder, name)) {
            return false;
        }
        builder.sign = DeviceParser.binDecodeTextOr64(values[0]);
        return true;
    }

    private boolean parseX509(Device.Builder builder, String tag, byte[] value) {
        if (value == null) {
            LOGGER.warn("X509: {} missing certificate data", (Object)tag);
        }
        try {
            CertificateFactory factory = (CertificateFactory)CERTIFICATE_FACTORY.currentWithCause();
            Certificate certificate = factory.generateCertificate(new ByteArrayInputStream(value));
            if (certificate instanceof X509Certificate) {
                builder.x509 = (X509Certificate)certificate;
                builder.x509PemTag = tag;
                return true;
            }
            LOGGER.warn("X509: {} is no X509 certificate", (Object)certificate.getType());
        }
        catch (GeneralSecurityException e) {
            LOGGER.warn("X509:", e);
        }
        return false;
    }

    @Override
    public void destroy() throws DestroyFailedException {
        this.map.clear();
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    private static String encode64(byte[] value) {
        return StringUtil.byteArrayToBase64(value);
    }

    private static byte[] binDecodeTextOr64(String value) {
        if (value.isEmpty()) {
            return Bytes.EMPTY;
        }
        char c = value.charAt(0);
        if (c == '\'' || c == '\"') {
            int end;
            char e;
            if (value.length() > 2 && (e = value.charAt(end = value.length() - 1)) == c) {
                value = value.substring(1, end);
                return value.getBytes(StandardCharsets.UTF_8);
            }
        } else if (c == ':' && value.startsWith(":0x")) {
            return StringUtil.hex2ByteArray(value.substring(3));
        }
        return StringUtil.base64ToByteArray(value);
    }

    private static String decodeText(String value) {
        if (!value.isEmpty()) {
            int end;
            char e;
            char c = value.charAt(0);
            if (value.length() > 2 && (c == '\'' || c == '\"') && (e = value.charAt(end = value.length() - 1)) == c) {
                value = value.substring(1, end);
            }
        }
        return value;
    }

    @Override
    public DeviceParser create() {
        return new DeviceParser(this.caseSensitiveNames, this.replace, this.customFields);
    }

    static {
        byte[] header = null;
        try {
            String oid = JceProviderUtil.getEdDsaStandardAlgorithmName("EC", "EC");
            KeyPairGenerator generator = KeyPairGenerator.getInstance(oid);
            generator.initialize(new ECGenParameterSpec("secp256r1"), RandomManager.currentSecureRandom());
            KeyPair keyPair = generator.generateKeyPair();
            byte[] encoded = keyPair.getPublic().getEncoded();
            header = Arrays.copyOf(encoded, encoded.length - 64);
        }
        catch (GeneralSecurityException ex) {
            header = null;
            LOGGER.error("EC failed!", ex);
        }
        ECC_SECP256R1_HEADER = header;
        POSTFIXES = Arrays.asList(LABEL_POSTFIX, PSK_POSTFIX, RPK_POSTFIX, SIG_POSTFIX, X509_POSTFIX, PROV_POSTFIX, TYPE_POSTFIX, BAN_POSTFIX);
    }

    public static class Device
    implements DeviceIdentifier {
        public final String comment;
        public final String name;
        public final String label;
        public final String group;
        public final String pskIdentity;
        public final byte[] pskSecret;
        public final PublicKey publicKey;
        public final byte[] sign;
        public final X509Certificate x509;
        public final String x509PemTag;
        public final PrincipalInfo.Type type;
        public final boolean ban;
        public final Map<String, String> customFields;

        public Device(String name, String label, String comment, String group, String pskIdentity, byte[] pskSecret, PublicKey publicKey, byte[] sign, String x509PemTag, X509Certificate x509, PrincipalInfo.Type type, boolean ban, Map<String, String> customFields) {
            if (name == null) {
                throw new NullPointerException("name must not be null!");
            }
            if (group == null) {
                throw new NullPointerException("group must not be null!");
            }
            if (pskIdentity == null && publicKey == null && x509 == null) {
                throw new IllegalArgumentException("either pskIdentity, publicKey or x509 must not be null!");
            }
            if (pskIdentity != null && pskSecret == null) {
                throw new IllegalArgumentException("pskSecret must not be null, if pskIdentity is provided!");
            }
            if (pskIdentity == null && pskSecret != null) {
                throw new IllegalArgumentException("pskIdentity must not be null, if pskSecret is provided!");
            }
            if (x509 != null && x509PemTag == null) {
                throw new IllegalArgumentException("x509PemTag must not be null, if x509 is provided!");
            }
            if (x509 == null && x509PemTag != null) {
                throw new IllegalArgumentException("x509 must not be null, if x509PemTag is provided!");
            }
            if (sign != null) {
                if (publicKey == null) {
                    throw new IllegalArgumentException("sign must only be provided, if a public key is provided!");
                }
                DatagramReader reader = new DatagramReader(sign);
                try {
                    SignedMessage signed = SignedMessage.fromReader(reader);
                    byte[] data0 = new byte[]{0};
                    signed.verifySignature(publicKey, data0, publicKey.getEncoded());
                    LOGGER.debug("{} Signature verified!", (Object)name);
                }
                catch (GeneralSecurityException e) {
                    throw new IllegalArgumentException("Signature not verified!");
                }
            }
            this.comment = comment;
            this.name = name;
            this.label = label;
            this.group = group;
            this.pskIdentity = pskIdentity;
            this.pskSecret = pskSecret;
            this.publicKey = publicKey;
            this.x509 = x509;
            this.x509PemTag = x509PemTag;
            this.sign = sign;
            this.type = type;
            this.ban = ban;
            this.customFields = customFields;
        }

        public Device(Device device, String label, Map<String, String> customFields) {
            this.comment = device.comment;
            this.name = device.name;
            this.label = Device.applyDefault(device.label, label);
            this.group = device.group;
            this.pskIdentity = device.pskIdentity;
            this.pskSecret = device.pskSecret;
            this.publicKey = device.publicKey;
            this.sign = device.sign;
            this.x509 = device.x509;
            this.x509PemTag = device.x509PemTag;
            this.type = device.type;
            this.ban = device.ban;
            if (customFields != null) {
                if (device.customFields != null) {
                    for (Map.Entry<String, String> entry : customFields.entrySet()) {
                        device.customFields.putIfAbsent(entry.getKey(), entry.getValue());
                    }
                }
            } else {
                customFields = device.customFields;
            }
            this.customFields = customFields;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Device other = (Device)obj;
            return this.name.equals(other.name);
        }

        private static <T> T applyDefault(T value, T def) {
            return value != null ? value : def;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            public String comment;
            public String name;
            public String label;
            public String group;
            public String pskIdentity;
            public byte[] pskSecret;
            public PublicKey publicKey;
            public byte[] sign;
            public X509Certificate x509;
            public String x509PemTag;
            public PrincipalInfo.Type type;
            public boolean ban;
            public Map<String, String> customFields;

            private Builder() {
            }

            public boolean addCustomField(String name, String value) {
                if (this.customFields == null) {
                    this.customFields = new HashMap<String, String>();
                }
                return this.customFields.putIfAbsent(name, value) == null;
            }

            public void applyDefaults() {
                this.type = (PrincipalInfo.Type)((Object)Device.applyDefault((Object)this.type, (Object)PrincipalInfo.Type.DEVICE));
            }

            public Device build() {
                this.applyDefaults();
                return new Device(this.name, this.label, this.comment, this.group, this.pskIdentity, this.pskSecret, this.publicKey, this.sign, this.x509PemTag, this.x509, this.type, this.ban, this.customFields);
            }
        }
    }
}

