/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.config.NetworkConfigDefaultHandler;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class ConnectorConfig
implements Cloneable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ConnectorConfig.class);
    public static final int MAX_WIDTH = 60;
    public static final String PSK_IDENTITY_PREFIX = "cali.";
    public static final SecretKey PSK_SECRET = SecretUtil.create((byte[])".fornium".getBytes(), (String)"PSK");
    public String defaultEcCredentials = ConnectorConfig.createDescriptor("certs/keyStore.jks", "endPass".toCharArray(), "endPass".toCharArray(), "client");
    public String defaultEcTrusts = ConnectorConfig.createDescriptor("certs/trustStore.jks", "rootPass".toCharArray(), null, null);
    public String networkConfigHeader = "Californium CoAP Properties file";
    public NetworkConfigDefaultHandler networkConfigDefaultHandler;
    public NetworkConfig networkConfig;
    @CommandLine.Option(names={"-N", "--netconfig"}, paramLabel="FILE", description={"network config file. Default ${DEFAULT-VALUE}."})
    public File networkConfigFile;
    @CommandLine.Option(names={"--tag"}, description={"use logging tag."})
    public String tag;
    @CommandLine.Option(names={"--record-size"}, description={"record size limit."})
    public Integer recordSizeLimit;
    @CommandLine.Option(names={"--mtu"}, description={"MTU."})
    public Integer mtu;
    @CommandLine.Option(names={"--cid-length"}, description={"Use cid with length. 0 to support cid only without using it."})
    public Integer cidLength;
    @CommandLine.ArgGroup(exclusive=true)
    public Authentication authentication;
    @CommandLine.ArgGroup(exclusive=true)
    public Trust trust;
    @CommandLine.Option(names={"--psk-index"}, description={"Index of identity in PSK store. Starts at 0."})
    public Integer pskIndex;
    @CommandLine.Option(names={"--psk-store"}, description={"PSK store. Lines format: identity=secretkey (in base64)."})
    public PskCredentialStore pskStore;
    @CommandLine.Option(names={"--cipher"}, split=":", description={"use ciphersuites. '--help-cipher' to list available cipher suites."})
    public List<CipherSuite> cipherSuites;
    @CommandLine.Option(names={"-a", "--auth"}, split=":", description={"use authentikation modes. '--help-auth' to list available authentication modes."})
    public List<AuthenticationMode> authenticationModes;
    @CommandLine.Option(names={"-i", "--identity"}, description={"PSK identity"})
    public String identity;
    @CommandLine.ArgGroup(exclusive=true)
    public Secret secret;
    @CommandLine.Option(names={"-v", "--verbose"}, negatable=true, description={"verbose"})
    public boolean verbose;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"display a help message"})
    public boolean helpRequested;
    @CommandLine.Option(names={"--help-cipher"}, description={"display a help message for cipher suites"})
    public boolean cipherHelpRequested;
    @CommandLine.Option(names={"--help-auth"}, description={"display a help message for authentication modes"})
    public boolean authHelpRequested;
    @CommandLine.Option(names={"-V", "--version"}, versionHelp=true, description={"display version info"})
    boolean versionInfoRequested;
    public byte[] secretKey;
    protected CommandLine.IDefaultValueProvider defaultValueProvider = new CommandLine.IDefaultValueProvider(){

        public String defaultValue(CommandLine.Model.ArgSpec argSpec) throws Exception {
            CommandLine.Model.OptionSpec optionSpec;
            if (argSpec instanceof CommandLine.Model.OptionSpec && "--netconfig".equals((optionSpec = (CommandLine.Model.OptionSpec)argSpec).longestName())) {
                if (ConnectorConfig.this.networkConfigFile != null) {
                    return ConnectorConfig.this.networkConfigFile.getPath();
                }
                return "Californium.properties";
            }
            return null;
        }
    };
    private static CommandLine.ITypeConverter<Certificate[]> trustsReader = new CommandLine.ITypeConverter<Certificate[]>(){

        public Certificate[] convert(String value) throws Exception {
            return SslContextUtil.loadTrustedCertificates((String)value);
        }
    };
    private static CommandLine.ITypeConverter<SslContextUtil.Credentials> credentialsReader = new CommandLine.ITypeConverter<SslContextUtil.Credentials>(){

        public SslContextUtil.Credentials convert(String value) throws Exception {
            try {
                return SslContextUtil.loadCredentials((String)value);
            }
            catch (SslContextUtil.IncompleteCredentialsException ex) {
                return ex.getIncompleteCredentials();
            }
        }
    };
    private static CommandLine.ITypeConverter<PskCredentialStore> pskCredentialsStoreReader = new CommandLine.ITypeConverter<PskCredentialStore>(){

        public PskCredentialStore convert(String value) throws Exception {
            return ConnectorConfig.loadPskCredentials(value);
        }
    };

    public void register(CommandLine cmd) {
        cmd.registerConverter(SslContextUtil.Credentials.class, credentialsReader);
        cmd.registerConverter(Certificate[].class, trustsReader);
        cmd.registerConverter(PskCredentialStore.class, pskCredentialsStoreReader);
        cmd.setDefaultValueProvider(this.defaultValueProvider);
    }

    public void defaults() {
        if (this.pskStore != null) {
            if (this.identity != null || this.secret != null) {
                System.err.println("Use either '--psk-store' or single psk credentials!");
                this.helpRequested = true;
            }
            if (this.pskIndex != null) {
                this.secret = new Secret();
                this.secret.hex = StringUtil.byteArray2Hex((byte[])this.pskStore.getSecrets(this.pskIndex));
                this.identity = this.pskStore.getIdentity(this.pskIndex);
            }
        }
        if (this.secret != null && this.secretKey == null) {
            if (this.secret.text != null) {
                this.secretKey = this.secret.text.getBytes();
            } else if (this.secret.hex != null) {
                this.secretKey = StringUtil.hex2ByteArray((String)this.secret.hex);
            } else if (this.secret.base64 != null) {
                this.secretKey = StringUtil.base64ToByteArray((String)this.secret.base64);
            }
        }
        if (this.authenticationModes == null) {
            this.authenticationModes = new ArrayList<AuthenticationMode>();
        }
        if (this.authenticationModes.isEmpty()) {
            this.defaultAuthenticationModes();
        }
        if (this.authenticationModes.contains((Object)AuthenticationMode.X509) || this.authenticationModes.contains((Object)AuthenticationMode.RPK)) {
            if (this.trust == null) {
                this.trust = new Trust();
            }
            if (this.trust.trusts == null) {
                if (this.trust.trustall) {
                    this.trust.trusts = new Certificate[0];
                } else {
                    try {
                        this.trust.trusts = SslContextUtil.loadTrustedCertificates((String)this.defaultEcTrusts);
                    }
                    catch (GeneralSecurityException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.authentication == null) {
                this.authentication = new Authentication();
            }
            if (!this.authentication.anonymous && this.authentication.identity == null) {
                try {
                    this.authentication.identity = new Identity();
                    this.authentication.identity.certificate = SslContextUtil.loadCredentials((String)this.defaultEcCredentials);
                    LOGGER.info("x509 default identity.");
                }
                catch (GeneralSecurityException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.authentication.defaults();
        }
        if (this.cipherHelpRequested || this.authHelpRequested) {
            this.helpRequested = true;
        }
        this.networkConfig = NetworkConfig.createWithFile((File)this.networkConfigFile, (String)this.networkConfigHeader, (NetworkConfigDefaultHandler)this.networkConfigDefaultHandler);
        int extra = 59 - CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8.getMaxCiphertextExpansion();
        if (this.mtu != null && this.recordSizeLimit == null) {
            this.recordSizeLimit = this.mtu - extra;
        } else if (this.mtu == null && this.recordSizeLimit != null) {
            this.mtu = this.recordSizeLimit + extra;
        }
    }

    protected void defaultAuthenticationModes() {
        if (this.identity != null || this.secretKey != null || this.pskStore != null) {
            this.authenticationModes.add(AuthenticationMode.PSK);
        }
        if (this.authentication != null) {
            this.authenticationModes.add(AuthenticationMode.X509);
        }
    }

    public static String createDescriptor(String store, char[] storePass, char[] keyPass, String alias) {
        StringBuilder descriptor = new StringBuilder("classpath://");
        descriptor.append(store).append('#');
        if (storePass != null) {
            descriptor.append(StringUtil.charArray2hex((char[])storePass)).append('#');
        }
        if (keyPass != null) {
            descriptor.append(StringUtil.charArray2hex((char[])keyPass)).append('#');
        }
        if (alias != null) {
            descriptor.append(alias);
        }
        return descriptor.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PskCredentialStore loadPskCredentials(String file) {
        boolean error = false;
        BufferedReader lineReader = null;
        try (FileReader reader = new FileReader(file);){
            String line;
            PskCredentialStore pskCredentials = new PskCredentialStore();
            int lineNumber = 0;
            lineReader = new BufferedReader(reader);
            while ((line = lineReader.readLine()) != null) {
                ++lineNumber;
                String[] entry = line.split("=", 2);
                if (entry.length == 2) {
                    byte[] secretBytes = StringUtil.base64ToByteArray((String)entry[1]);
                    pskCredentials.add(entry[0], secretBytes);
                    continue;
                }
                error = true;
                LOGGER.error("{}: '{}' invalid psk-line!", (Object)lineNumber, (Object)line);
            }
            if (!error) {
                PskCredentialStore pskCredentialStore = pskCredentials;
                return pskCredentialStore;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (lineReader != null) {
                try {
                    lineReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static class PskCredentialStore {
        private List<String> identities = new ArrayList<String>();
        private List<byte[]> secrets = new ArrayList<byte[]>();

        private void add(String identity, byte[] secret) {
            this.identities.add(identity);
            this.secrets.add(secret);
        }

        public String getIdentity(int index) {
            return this.identities.get(index);
        }

        public byte[] getSecrets(int index) {
            return this.secrets.get(index);
        }

        public int size() {
            return this.secrets.size();
        }
    }

    public static class Secret {
        @CommandLine.Option(names={"-s", "--secret"}, description={"PSK secret, UTF-8"})
        public String text;
        @CommandLine.Option(names={"--secrethex"}, description={"PSK secret, hexadecimal"})
        public String hex;
        @CommandLine.Option(names={"--secret64"}, description={"PSK secret, base64"})
        public String base64;
    }

    public static class Trust {
        @CommandLine.Option(names={"-t", "--trusts"}, description={"trusted certificates. Format keystore#hexstorepwd#alias or truststore.pem"})
        public Certificate[] trusts;
        @CommandLine.Option(names={"--trust-all"}, description={"trust all valid certificates."})
        public boolean trustall;
    }

    public static class Identity {
        @CommandLine.Option(names={"-c", "--cert"}, description={"certificate store. Format keystore#hexstorepwd#hexkeypwd#alias or keystore.pem"})
        public SslContextUtil.Credentials certificate;
        @CommandLine.Option(names={"--private-key"}, description={"private key store. Format keystore#hexstorepwd#hexkeypwd#alias or keystore.pem"})
        public SslContextUtil.Credentials privateKey;
    }

    public static class Authentication {
        public SslContextUtil.Credentials credentials;
        @CommandLine.ArgGroup(exclusive=false)
        public Identity identity;
        @CommandLine.Option(names={"--anonymous"}, description={"anonymous, no certificate."})
        public boolean anonymous;

        public void defaults() {
            if (!this.anonymous) {
                if (this.identity.certificate == null) {
                    LOGGER.info("x509 identity from private key.");
                    this.credentials = this.identity.privateKey;
                } else if (this.identity.certificate.getPrivateKey() == null) {
                    LOGGER.info("x509 identity from certificate and private key.");
                    this.credentials = new SslContextUtil.Credentials(this.identity.privateKey.getPrivateKey(), this.identity.certificate.getPubicKey(), this.identity.certificate.getCertificateChain());
                } else {
                    LOGGER.info("x509 identity from certificate.");
                    this.credentials = this.identity.certificate;
                }
                if (this.credentials.getPrivateKey() == null) {
                    throw new IllegalArgumentException("Missing private key!");
                }
                if (this.credentials.getPubicKey() == null) {
                    throw new IllegalArgumentException("Missing public key or certificate!");
                }
            }
        }
    }

    public static enum AuthenticationMode {
        NONE,
        PSK,
        RPK,
        X509,
        ECDHE_PSK;

    }
}

