/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cli;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import org.eclipse.californium.cli.ConnectorConfig;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.StringUtil;
import picocli.CommandLine;

public class ClientBaseConfig
extends ConnectorConfig {
    public static final String LABELT_URI = "URI";
    public static final String DEFAULT_URI = "californium.eclipseprojects.io";
    public String defaultUri = "californium.eclipseprojects.io";
    private String defaultIdentity;
    private String defaultSecret;
    @CommandLine.Option(names={"--proxy"}, description={"use proxy. <address>:<port>[:<scheme>]. Default env-value of COAP_PROXY."})
    public ProxyConfiguration proxy;
    @CommandLine.Option(names={"--local-port"}, description={"local porty. Default ephemeral port."})
    public Integer localPort;
    @CommandLine.Parameters(index="0", paramLabel="URI", arity="0..1", description={"destination URI. Default ${DEFAULT-VALUE}"})
    public String uri;
    public boolean secure;
    public boolean tcp;
    private static CommandLine.ITypeConverter<ProxyConfiguration> proxyReader = new CommandLine.ITypeConverter<ProxyConfiguration>(){

        public ProxyConfiguration convert(String value) throws Exception {
            String host;
            int index;
            String config = value;
            if (config.startsWith("[")) {
                index = config.indexOf("]:");
                if (index < 0) {
                    throw new IllegalArgumentException(value + " invalid proxy configuration!");
                }
                host = config.substring(0, index + 1);
                config = config.substring(index + 2);
            } else {
                index = config.indexOf(":");
                if (index < 0) {
                    throw new IllegalArgumentException(value + " invalid proxy configuration!");
                }
                host = config.substring(0, index);
                config = config.substring(index + 1);
            }
            String scheme = null;
            index = config.indexOf(":");
            if (index > 0) {
                scheme = config.substring(index + 1);
                config = config.substring(0, index);
            }
            try {
                InetSocketAddress destination = new InetSocketAddress(host, Integer.parseInt(config));
                return new ProxyConfiguration(scheme, destination);
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException(value + " invalid proxy configuration!", ex);
            }
        }
    };

    @Override
    public void register(CommandLine cmd) {
        super.register(cmd);
        cmd.registerConverter(ProxyConfiguration.class, proxyReader);
        final CommandLine.IDefaultValueProvider defaultValueProvider = cmd.getDefaultValueProvider();
        CommandLine.IDefaultValueProvider newDefaultValueProvider = new CommandLine.IDefaultValueProvider(){

            public String defaultValue(CommandLine.Model.ArgSpec argSpec) throws Exception {
                CommandLine.Model.PositionalParamSpec spec;
                if (argSpec instanceof CommandLine.Model.PositionalParamSpec && ClientBaseConfig.LABELT_URI.contentEquals((spec = (CommandLine.Model.PositionalParamSpec)argSpec).paramLabel())) {
                    return ClientBaseConfig.this.defaultUri;
                }
                return defaultValueProvider != null ? defaultValueProvider.defaultValue(argSpec) : null;
            }
        };
        cmd.setDefaultValueProvider(newDefaultValueProvider);
    }

    @Override
    public void defaults() {
        String scheme;
        String proxySpec;
        super.defaults();
        if (this.proxy == null && (proxySpec = StringUtil.getConfiguration((String)"COAP_PROXY")) != null && !proxySpec.isEmpty()) {
            try {
                this.proxy = (ProxyConfiguration)proxyReader.convert(proxySpec);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((scheme = CoAP.getSchemeFromUri((String)this.uri)) == null) {
            if (this.authenticationModes != null && !this.authenticationModes.isEmpty()) {
                this.uri = "coaps://" + this.uri;
                this.secure = true;
            } else {
                this.uri = "coap://" + this.uri;
            }
        } else {
            this.secure = CoAP.isSecureScheme((String)scheme);
            this.tcp = CoAP.isTcpScheme((String)scheme);
        }
        if (this.uri.endsWith("/")) {
            this.uri = this.uri.substring(this.uri.length() - 1);
        }
        if (this.secure) {
            if (this.tcp) {
                if (this.trust == null) {
                    this.trust = new ConnectorConfig.Trust();
                }
                if (this.trust.trusts == null) {
                    if (this.trust.trustall) {
                        this.trust.trusts = new Certificate[0];
                    } else {
                        try {
                            this.trust.trusts = SslContextUtil.loadTrustedCertificates((String)this.defaultEcTrusts);
                        }
                        catch (GeneralSecurityException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (this.authentication == null) {
                    this.authentication = new ConnectorConfig.Authentication();
                }
                if (!this.authentication.anonymous && this.authentication.credentials == null) {
                    try {
                        this.authentication.credentials = SslContextUtil.loadCredentials((String)this.defaultEcCredentials);
                    }
                    catch (GeneralSecurityException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (this.authenticationModes.isEmpty()) {
                    this.authenticationModes.add(ConnectorConfig.AuthenticationMode.X509);
                }
            } else if ((this.authenticationModes.isEmpty() || this.authenticationModes.contains((Object)ConnectorConfig.AuthenticationMode.PSK) || this.authenticationModes.contains((Object)ConnectorConfig.AuthenticationMode.ECDHE_PSK)) && this.identity == null && this.secret == null) {
                this.identity = this.defaultIdentity;
                this.secret = new ConnectorConfig.Secret();
                this.secret.text = this.defaultSecret;
                if (this.authenticationModes.isEmpty()) {
                    this.authenticationModes.add(ConnectorConfig.AuthenticationMode.PSK);
                }
            }
        }
    }

    public ClientBaseConfig create(String id, byte[] secret) {
        ClientBaseConfig clone = null;
        try {
            clone = (ClientBaseConfig)this.clone();
            clone.identity = id;
            clone.secretKey = secret;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    public ClientBaseConfig create(PrivateKey privateKey, PublicKey publicKey) {
        ClientBaseConfig clone = null;
        try {
            clone = (ClientBaseConfig)this.clone();
            clone.authentication = new ConnectorConfig.Authentication();
            clone.authentication.credentials = new SslContextUtil.Credentials(privateKey, publicKey, null);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    public void setDefaultPskCredentials(String identity, String secret) {
        this.defaultIdentity = identity;
        this.defaultSecret = secret;
    }

    public void setDefaultPskCredentials(String identity) {
        this.defaultIdentity = "cali." + identity;
        this.defaultSecret = null;
    }

    public static class ProxyConfiguration {
        public final String scheme;
        public final InetSocketAddress destination;

        public ProxyConfiguration(String scheme, InetSocketAddress destination) {
            if (destination == null) {
                throw new NullPointerException("proxy destination must not be null!");
            }
            this.scheme = scheme;
            this.destination = destination;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(StringUtil.toString((InetSocketAddress)this.destination));
            if (this.scheme != null) {
                builder.append(" using ").append(this.scheme);
            }
            return builder.toString();
        }
    }
}

