/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cli;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.config.NetworkConfigDefaultHandler;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import picocli.CommandLine;

public class ConnectorConfig
implements Cloneable {
    public static final int MAX_WIDTH = 60;
    public String networkConfigHeader = "Californium CoAP Properties file";
    public NetworkConfigDefaultHandler networkConfigDefaultHandler;
    public NetworkConfig networkConfig;
    @CommandLine.Option(names={"-N", "--netconfig"}, paramLabel="FILE", description={"network config file. Default ${DEFAULT-VALUE}."})
    public File networkConfigFile;
    @CommandLine.Option(names={"-c", "--cert"}, description={"certificate store. Format keystore#hexstorepwd#hexkeypwd#alias or keystore.pem"})
    public SslContextUtil.Credentials credentials;
    @CommandLine.Option(names={"-t", "--trusts"}, description={"trusted certificates. Format keystore#hexstorepwd#alias or truststore.pem"})
    public Certificate[] trusts;
    @CommandLine.Option(names={"--psk-store"}, description={"PSK store. Lines format: identity=secretkey (in base64)."})
    public PskCredentialStore pskStore;
    @CommandLine.Option(names={"--cipher"}, split=":", description={"use ciphersuites. '--help-cipher' to list available cipher suites."})
    public List<CipherSuite> cipherSuites;
    @CommandLine.Option(names={"-a", "--auth"}, split=":", description={"use authentikation modes. '--help-auth' to list available authentication modes."})
    public List<AuthenticationMode> authenticationModes;
    @CommandLine.Option(names={"-i", "--identity"}, description={"PSK identity"})
    public String identity;
    @CommandLine.ArgGroup(exclusive=true)
    public Secret secret;
    @CommandLine.Option(names={"-v", "--verbose"}, negatable=true, description={"verbose"})
    public boolean verbose;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"display a help message"})
    public boolean helpRequested;
    @CommandLine.Option(names={"--help-cipher"}, description={"display a help message for cipher suites"})
    public boolean cipherHelpRequested;
    @CommandLine.Option(names={"--help-auth"}, description={"display a help message for authentication modes"})
    public boolean authHelpRequested;
    @CommandLine.Option(names={"-V", "--version"}, versionHelp=true, description={"display version info"})
    boolean versionInfoRequested;
    public byte[] secretKey;
    protected CommandLine.IDefaultValueProvider defaultValueProvider = new CommandLine.IDefaultValueProvider(){

        public String defaultValue(CommandLine.Model.ArgSpec argSpec) throws Exception {
            CommandLine.Model.OptionSpec optionSpec;
            if (argSpec instanceof CommandLine.Model.OptionSpec && "--netconfig".equals((optionSpec = (CommandLine.Model.OptionSpec)argSpec).longestName())) {
                return ConnectorConfig.this.networkConfigFile.getPath();
            }
            return null;
        }
    };
    private static CommandLine.ITypeConverter<Certificate[]> trustsReader = new CommandLine.ITypeConverter<Certificate[]>(){

        public Certificate[] convert(String value) throws Exception {
            return SslContextUtil.loadTrustedCertificates((String)value);
        }
    };
    private static CommandLine.ITypeConverter<SslContextUtil.Credentials> credentialsReader = new CommandLine.ITypeConverter<SslContextUtil.Credentials>(){

        public SslContextUtil.Credentials convert(String value) throws Exception {
            return SslContextUtil.loadCredentials((String)value);
        }
    };
    private static CommandLine.ITypeConverter<PskCredentialStore> pskCredentialsStoreReader = new CommandLine.ITypeConverter<PskCredentialStore>(){

        public PskCredentialStore convert(String value) throws Exception {
            return ConnectorConfig.loadPskCredentials(value);
        }
    };

    public void register(CommandLine cmd) {
        cmd.registerConverter(SslContextUtil.Credentials.class, credentialsReader);
        cmd.registerConverter(Certificate[].class, trustsReader);
        cmd.registerConverter(PskCredentialStore.class, pskCredentialsStoreReader);
        cmd.setDefaultValueProvider(this.defaultValueProvider);
    }

    public void defaults() {
        if (this.pskStore != null && (this.identity != null || this.secret != null)) {
            System.err.println("Use either '--psk-store' or single psk credentials!");
            this.helpRequested = true;
        }
        if (this.secret != null && this.secretKey == null) {
            if (this.secret.text != null) {
                this.secretKey = this.secret.text.getBytes();
            } else if (this.secret.hex != null) {
                this.secretKey = StringUtil.hex2ByteArray((String)this.secret.hex);
            } else if (this.secret.base64 != null) {
                this.secretKey = StringUtil.base64ToByteArray((String)this.secret.base64);
            }
        }
        if (this.authenticationModes == null) {
            this.authenticationModes = new ArrayList<AuthenticationMode>();
        }
        if (this.authenticationModes.isEmpty()) {
            if (this.identity != null || this.secretKey != null || this.pskStore != null) {
                this.authenticationModes.add(AuthenticationMode.PSK);
            }
            if (this.credentials != null) {
                this.authenticationModes.add(AuthenticationMode.X509);
            }
        }
        if (this.cipherHelpRequested || this.authHelpRequested) {
            this.helpRequested = true;
        }
        this.networkConfig = NetworkConfig.createWithFile((File)this.networkConfigFile, (String)this.networkConfigHeader, (NetworkConfigDefaultHandler)this.networkConfigDefaultHandler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PskCredentialStore loadPskCredentials(String file) {
        Properties credentials = new Properties();
        try (FileReader reader = new FileReader(file);){
            credentials.load(reader);
            Set<Object> keys = credentials.keySet();
            TreeSet<String> sortedKeys = new TreeSet<String>();
            for (Object key : keys) {
                if (!(key instanceof String)) continue;
                sortedKeys.add((String)key);
            }
            if (sortedKeys.isEmpty()) return null;
            PskCredentialStore pskCredentials = new PskCredentialStore();
            for (String key : sortedKeys) {
                String secret = credentials.getProperty(key);
                byte[] secretBytes = StringUtil.base64ToByteArray((String)secret);
                pskCredentials.add(key, secretBytes);
            }
            PskCredentialStore pskCredentialStore = pskCredentials;
            return pskCredentialStore;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static class PskCredentialStore {
        private List<String> identities = new ArrayList<String>();
        private List<byte[]> secrets = new ArrayList<byte[]>();

        private void add(String identity, byte[] secret) {
            this.identities.add(identity);
            this.secrets.add(secret);
        }

        public String getIdentity(int index) {
            return this.identities.get(index);
        }

        public byte[] getSecrets(int index) {
            return this.secrets.get(index);
        }

        public int size() {
            return this.secrets.size();
        }
    }

    public static class Secret {
        @CommandLine.Option(names={"-s", "--secret"}, description={"PSK secret, utf8"})
        public String text;
        @CommandLine.Option(names={"--secrethex"}, description={"PSK secret, hexadecimal"})
        public String hex;
        @CommandLine.Option(names={"--secret64"}, description={"PSK secret, base64"})
        public String base64;
    }

    public static enum AuthenticationMode {
        NONE,
        PSK,
        RPK,
        X509,
        ECDHE_PSK;

    }
}

