/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cli.tcp.netty;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import org.eclipse.californium.cli.CliConnectorFactory;
import org.eclipse.californium.cli.ClientBaseConfig;
import org.eclipse.californium.cli.ConnectorConfig;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.TcpConfig;
import org.eclipse.californium.elements.tcp.netty.TlsClientConnector;
import org.eclipse.californium.elements.util.ProtocolScheduledExecutorService;
import org.eclipse.californium.elements.util.SslContextUtil;

public class TlsConnectorFactory
implements CliConnectorFactory {
    private static final String ALIAS = "client";

    public Connector create(ClientBaseConfig clientConfig, ProtocolScheduledExecutorService executor) {
        Configuration config = clientConfig.configuration;
        int maxPeers = (Integer)config.get((BasicDefinition)CoapConfig.MAX_ACTIVE_PEERS);
        int sessionTimeout = config.getTimeAsInt(TcpConfig.TLS_SESSION_TIMEOUT, TimeUnit.SECONDS);
        if (clientConfig.noCertificatesSubjectVerification != null) {
            config.set((BasicDefinition)TcpConfig.TLS_VERIFY_SERVER_CERTIFICATES_SUBJECT, (Object)(clientConfig.noCertificatesSubjectVerification == false ? 1 : 0));
        }
        SSLContext clientSslContext = null;
        try {
            if (clientConfig.authentication == null) {
                clientConfig.authentication = new ConnectorConfig.Authentication();
            }
            clientConfig.authentication.defaults(clientConfig.defaultEcCredentials);
            KeyManager[] keyManager = clientConfig.authentication.anonymous ? SslContextUtil.createAnonymousKeyManager() : SslContextUtil.createKeyManager((String)ALIAS, (PrivateKey)clientConfig.authentication.credentials.getPrivateKey(), (X509Certificate[])clientConfig.authentication.credentials.getCertificateChain());
            if (clientConfig.trust == null) {
                clientConfig.trust = new ConnectorConfig.Trust();
            }
            clientConfig.trust.defaults(clientConfig.defaultEcTrusts);
            TrustManager[] trustManager = clientConfig.trust.trustall ? SslContextUtil.createTrustAllManager() : SslContextUtil.createTrustManager((String)ALIAS, (Certificate[])clientConfig.trust.trusts);
            clientSslContext = SSLContext.getInstance("TLSv1.2");
            clientSslContext.init(keyManager, trustManager, null);
            SSLSessionContext clientSessionContext = clientSslContext.getClientSessionContext();
            if (clientSessionContext != null) {
                clientSessionContext.setSessionTimeout(sessionTimeout);
                clientSessionContext.setSessionCacheSize(maxPeers);
            }
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        return new TlsClientConnector(clientSslContext, clientConfig.configuration);
    }
}

